package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ActiveContext(name: primitives.ActiveContextName, timeToLive: ActiveContextTimeToLive, parameters: Map[primitives.ParameterName, primitives.Text]) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.ActiveContext = {
    import ActiveContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ActiveContext.builder().name(name: java.lang.String).timeToLive(timeToLive.buildAwsValue()).parameters(parameters.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava).build()
  }
  def asReadOnly: ActiveContext.ReadOnly = ActiveContext.wrap(buildAwsValue())
}
object ActiveContext {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.ActiveContext] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ActiveContext = ActiveContext(nameValue, timeToLiveValue.editable, parametersValue)
    def nameValue: primitives.ActiveContextName
    def timeToLiveValue: ActiveContextTimeToLive.ReadOnly
    def parametersValue: Map[primitives.ParameterName, primitives.Text]
    def name: ZIO[Any, Nothing, primitives.ActiveContextName] = ZIO.succeed(nameValue)
    def timeToLive: ZIO[Any, Nothing, ActiveContextTimeToLive.ReadOnly] = ZIO.succeed(timeToLiveValue)
    def parameters: ZIO[Any, Nothing, Map[primitives.ParameterName, primitives.Text]] = ZIO.succeed(parametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.ActiveContext) extends ActiveContext.ReadOnly {
    override def nameValue: primitives.ActiveContextName = impl.name(): primitives.ActiveContextName
    override def timeToLiveValue: ActiveContextTimeToLive.ReadOnly = ActiveContextTimeToLive.wrap(impl.timeToLive())
    override def parametersValue: Map[primitives.ParameterName, primitives.Text] = impl.parameters().asScala.map({
      case (key, value) =>
        (key: primitives.ParameterName) -> (value: primitives.Text)
    }).toMap
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.ActiveContext): ReadOnly = new Wrapper(impl)
}