package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class IntentSummary(intentName: scala.Option[primitives.IntentName] = None, checkpointLabel: scala.Option[primitives.IntentSummaryCheckpointLabel] = None, slots: scala.Option[Map[String, String]] = None, confirmationStatus: scala.Option[ConfirmationStatus] = None, dialogActionType: DialogActionType, fulfillmentState: scala.Option[FulfillmentState] = None, slotToElicit: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.IntentSummary = {
    import IntentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentSummary.builder().optionallyWith(intentName.map(value => value: java.lang.String))(_.intentName).optionallyWith(checkpointLabel.map(value => value: java.lang.String))(_.checkpointLabel).optionallyWith(slots.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> (value: java.lang.String)
    }).asJava))(_.slots).optionallyWith(confirmationStatus.map(value => value.unwrap))(_.confirmationStatus).dialogActionType(dialogActionType.unwrap).optionallyWith(fulfillmentState.map(value => value.unwrap))(_.fulfillmentState).optionallyWith(slotToElicit.map(value => value: java.lang.String))(_.slotToElicit).build()
  }
  def asReadOnly: IntentSummary.ReadOnly = IntentSummary.wrap(buildAwsValue())
}
object IntentSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.IntentSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: IntentSummary = IntentSummary(intentNameValue.map(value => value), checkpointLabelValue.map(value => value), slotsValue.map(value => value), confirmationStatusValue.map(value => value), dialogActionTypeValue, fulfillmentStateValue.map(value => value), slotToElicitValue.map(value => value))
    def intentNameValue: scala.Option[primitives.IntentName]
    def checkpointLabelValue: scala.Option[primitives.IntentSummaryCheckpointLabel]
    def slotsValue: scala.Option[Map[String, String]]
    def confirmationStatusValue: scala.Option[ConfirmationStatus]
    def dialogActionTypeValue: DialogActionType
    def fulfillmentStateValue: scala.Option[FulfillmentState]
    def slotToElicitValue: scala.Option[String]
    def intentName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("intentName", intentNameValue)
    def checkpointLabel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentSummaryCheckpointLabel] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("checkpointLabel", checkpointLabelValue)
    def slots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slots", slotsValue)
    def confirmationStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConfirmationStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("confirmationStatus", confirmationStatusValue)
    def dialogActionType: ZIO[Any, Nothing, DialogActionType] = ZIO.succeed(dialogActionTypeValue)
    def fulfillmentState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, FulfillmentState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fulfillmentState", fulfillmentStateValue)
    def slotToElicit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary) extends IntentSummary.ReadOnly {
    override def intentNameValue: scala.Option[primitives.IntentName] = scala.Option(impl.intentName()).map(value => value: primitives.IntentName)
    override def checkpointLabelValue: scala.Option[primitives.IntentSummaryCheckpointLabel] = scala.Option(impl.checkpointLabel()).map(value => value: primitives.IntentSummaryCheckpointLabel)
    override def slotsValue: scala.Option[Map[String, String]] = scala.Option(impl.slots()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> (value: String)
    }).toMap)
    override def confirmationStatusValue: scala.Option[ConfirmationStatus] = scala.Option(impl.confirmationStatus()).map(value => ConfirmationStatus.wrap(value))
    override def dialogActionTypeValue: DialogActionType = DialogActionType.wrap(impl.dialogActionType())
    override def fulfillmentStateValue: scala.Option[FulfillmentState] = scala.Option(impl.fulfillmentState()).map(value => FulfillmentState.wrap(value))
    override def slotToElicitValue: scala.Option[String] = scala.Option(impl.slotToElicit()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.IntentSummary): ReadOnly = new Wrapper(impl)
}