package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PostContentRequest(botName: primitives.BotName, botAlias: primitives.BotAlias, userId: primitives.UserId, sessionAttributes: scala.Option[primitives.AttributesString] = None, requestAttributes: scala.Option[primitives.AttributesString] = None, contentType: primitives.HttpContentType, accept: scala.Option[primitives.Accept] = None, activeContexts: scala.Option[primitives.ActiveContextsString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PostContentRequest = {
    import PostContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostContentRequest.builder().botName(botName: java.lang.String).botAlias(botAlias: java.lang.String).userId(userId: java.lang.String).optionallyWith(sessionAttributes.map(value => value: java.lang.String))(_.sessionAttributes).optionallyWith(requestAttributes.map(value => value: java.lang.String))(_.requestAttributes).contentType(contentType: java.lang.String).optionallyWith(accept.map(value => value: java.lang.String))(_.accept).optionallyWith(activeContexts.map(value => value: java.lang.String))(_.activeContexts).build()
  }
  def asReadOnly: PostContentRequest.ReadOnly = PostContentRequest.wrap(buildAwsValue())
}
object PostContentRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PostContentRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PostContentRequest = PostContentRequest(botNameValue, botAliasValue, userIdValue, sessionAttributesValue.map(value => value), requestAttributesValue.map(value => value), contentTypeValue, acceptValue.map(value => value), activeContextsValue.map(value => value))
    def botNameValue: primitives.BotName
    def botAliasValue: primitives.BotAlias
    def userIdValue: primitives.UserId
    def sessionAttributesValue: scala.Option[primitives.AttributesString]
    def requestAttributesValue: scala.Option[primitives.AttributesString]
    def contentTypeValue: primitives.HttpContentType
    def acceptValue: scala.Option[primitives.Accept]
    def activeContextsValue: scala.Option[primitives.ActiveContextsString]
    def botName: ZIO[Any, Nothing, primitives.BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, primitives.BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, primitives.UserId] = ZIO.succeed(userIdValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AttributesString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def requestAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AttributesString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requestAttributes", requestAttributesValue)
    def contentType: ZIO[Any, Nothing, primitives.HttpContentType] = ZIO.succeed(contentTypeValue)
    def accept: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Accept] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accept", acceptValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ActiveContextsString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PostContentRequest) extends PostContentRequest.ReadOnly {
    override def botNameValue: primitives.BotName = impl.botName(): primitives.BotName
    override def botAliasValue: primitives.BotAlias = impl.botAlias(): primitives.BotAlias
    override def userIdValue: primitives.UserId = impl.userId(): primitives.UserId
    override def sessionAttributesValue: scala.Option[primitives.AttributesString] = scala.Option(impl.sessionAttributes()).map(value => value: primitives.AttributesString)
    override def requestAttributesValue: scala.Option[primitives.AttributesString] = scala.Option(impl.requestAttributes()).map(value => value: primitives.AttributesString)
    override def contentTypeValue: primitives.HttpContentType = impl.contentType(): primitives.HttpContentType
    override def acceptValue: scala.Option[primitives.Accept] = scala.Option(impl.accept()).map(value => value: primitives.Accept)
    override def activeContextsValue: scala.Option[primitives.ActiveContextsString] = scala.Option(impl.activeContexts()).map(value => value: primitives.ActiveContextsString)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PostContentRequest): ReadOnly = new Wrapper(impl)
}