package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteSessionRequest(botName: primitives.BotName, botAlias: primitives.BotAlias, userId: primitives.UserId) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest = {
    import DeleteSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest.builder().botName(botName: java.lang.String).botAlias(botAlias: java.lang.String).userId(userId: java.lang.String).build()
  }
  def asReadOnly: DeleteSessionRequest.ReadOnly = DeleteSessionRequest.wrap(buildAwsValue())
}
object DeleteSessionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteSessionRequest = DeleteSessionRequest(botNameValue, botAliasValue, userIdValue)
    def botNameValue: primitives.BotName
    def botAliasValue: primitives.BotAlias
    def userIdValue: primitives.UserId
    def botName: ZIO[Any, Nothing, primitives.BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, primitives.BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, primitives.UserId] = ZIO.succeed(userIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest) extends DeleteSessionRequest.ReadOnly {
    override def botNameValue: primitives.BotName = impl.botName(): primitives.BotName
    override def botAliasValue: primitives.BotAlias = impl.botAlias(): primitives.BotAlias
    override def userIdValue: primitives.UserId = impl.userId(): primitives.UserId
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionRequest): ReadOnly = new Wrapper(impl)
}