package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait FulfillmentState { def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState }
object FulfillmentState {
  def wrap(value: software.amazon.awssdk.services.lexruntime.model.FulfillmentState): FulfillmentState = value match {
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
  }
  case object unknownToSdkVersion extends FulfillmentState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState = software.amazon.awssdk.services.lexruntime.model.FulfillmentState.UNKNOWN_TO_SDK_VERSION }
  case object Fulfilled extends FulfillmentState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState = software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FULFILLED }
  case object Failed extends FulfillmentState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState = software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FAILED }
  case object ReadyForFulfillment extends FulfillmentState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState = software.amazon.awssdk.services.lexruntime.model.FulfillmentState.READY_FOR_FULFILLMENT }
}