package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetSessionRequest(botName: primitives.BotName, botAlias: primitives.BotAlias, userId: primitives.UserId, checkpointLabelFilter: scala.Option[primitives.IntentSummaryCheckpointLabel] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.GetSessionRequest.builder().botName(botName: java.lang.String).botAlias(botAlias: java.lang.String).userId(userId: java.lang.String).optionallyWith(checkpointLabelFilter.map(value => value: java.lang.String))(_.checkpointLabelFilter).build()
  }
  def asReadOnly: GetSessionRequest.ReadOnly = GetSessionRequest.wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.GetSessionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetSessionRequest = GetSessionRequest(botNameValue, botAliasValue, userIdValue, checkpointLabelFilterValue.map(value => value))
    def botNameValue: primitives.BotName
    def botAliasValue: primitives.BotAlias
    def userIdValue: primitives.UserId
    def checkpointLabelFilterValue: scala.Option[primitives.IntentSummaryCheckpointLabel]
    def botName: ZIO[Any, Nothing, primitives.BotName] = ZIO.succeed(botNameValue)
    def botAlias: ZIO[Any, Nothing, primitives.BotAlias] = ZIO.succeed(botAliasValue)
    def userId: ZIO[Any, Nothing, primitives.UserId] = ZIO.succeed(userIdValue)
    def checkpointLabelFilter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentSummaryCheckpointLabel] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("checkpointLabelFilter", checkpointLabelFilterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.GetSessionRequest) extends GetSessionRequest.ReadOnly {
    override def botNameValue: primitives.BotName = impl.botName(): primitives.BotName
    override def botAliasValue: primitives.BotAlias = impl.botAlias(): primitives.BotAlias
    override def userIdValue: primitives.UserId = impl.userId(): primitives.UserId
    override def checkpointLabelFilterValue: scala.Option[primitives.IntentSummaryCheckpointLabel] = scala.Option(impl.checkpointLabelFilter()).map(value => value: primitives.IntentSummaryCheckpointLabel)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.GetSessionRequest): ReadOnly = new Wrapper(impl)
}