package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PutSessionResponse(contentType: scala.Option[primitives.HttpContentType] = None, intentName: scala.Option[primitives.IntentName] = None, slots: scala.Option[String] = None, sessionAttributes: scala.Option[String] = None, message: scala.Option[primitives.Text] = None, encodedMessage: scala.Option[primitives.SensitiveString] = None, messageFormat: scala.Option[MessageFormatType] = None, dialogState: scala.Option[DialogState] = None, slotToElicit: scala.Option[String] = None, sessionId: scala.Option[String] = None, activeContexts: scala.Option[primitives.ActiveContextsString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lexruntime.model.PutSessionResponse = {
    import PutSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PutSessionResponse.builder().optionallyWith(contentType.map(value => value: java.lang.String))(_.contentType).optionallyWith(intentName.map(value => value: java.lang.String))(_.intentName).optionallyWith(slots.map(value => value: java.lang.String))(_.slots).optionallyWith(sessionAttributes.map(value => value: java.lang.String))(_.sessionAttributes).optionallyWith(message.map(value => value: java.lang.String))(_.message).optionallyWith(encodedMessage.map(value => value: java.lang.String))(_.encodedMessage).optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat).optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState).optionallyWith(slotToElicit.map(value => value: java.lang.String))(_.slotToElicit).optionallyWith(sessionId.map(value => value: java.lang.String))(_.sessionId).optionallyWith(activeContexts.map(value => value: java.lang.String))(_.activeContexts).build()
  }
  def asReadOnly: PutSessionResponse.ReadOnly = PutSessionResponse.wrap(buildAwsValue())
}
object PutSessionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lexruntime.model.PutSessionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PutSessionResponse = PutSessionResponse(contentTypeValue.map(value => value), intentNameValue.map(value => value), slotsValue.map(value => value), sessionAttributesValue.map(value => value), messageValue.map(value => value), encodedMessageValue.map(value => value), messageFormatValue.map(value => value), dialogStateValue.map(value => value), slotToElicitValue.map(value => value), sessionIdValue.map(value => value), activeContextsValue.map(value => value))
    def contentTypeValue: scala.Option[primitives.HttpContentType]
    def intentNameValue: scala.Option[primitives.IntentName]
    def slotsValue: scala.Option[String]
    def sessionAttributesValue: scala.Option[String]
    def messageValue: scala.Option[primitives.Text]
    def encodedMessageValue: scala.Option[primitives.SensitiveString]
    def messageFormatValue: scala.Option[MessageFormatType]
    def dialogStateValue: scala.Option[DialogState]
    def slotToElicitValue: scala.Option[String]
    def sessionIdValue: scala.Option[String]
    def activeContextsValue: scala.Option[primitives.ActiveContextsString]
    def contentType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.HttpContentType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contentType", contentTypeValue)
    def intentName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntentName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("intentName", intentNameValue)
    def slots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slots", slotsValue)
    def sessionAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionAttributes", sessionAttributesValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Text] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    def encodedMessage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SensitiveString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("encodedMessage", encodedMessageValue)
    def messageFormat: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MessageFormatType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("messageFormat", messageFormatValue)
    def dialogState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DialogState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dialogState", dialogStateValue)
    def slotToElicit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("slotToElicit", slotToElicitValue)
    def sessionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionId", sessionIdValue)
    def activeContexts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ActiveContextsString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activeContexts", activeContextsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lexruntime.model.PutSessionResponse) extends PutSessionResponse.ReadOnly {
    override def contentTypeValue: scala.Option[primitives.HttpContentType] = scala.Option(impl.contentType()).map(value => value: primitives.HttpContentType)
    override def intentNameValue: scala.Option[primitives.IntentName] = scala.Option(impl.intentName()).map(value => value: primitives.IntentName)
    override def slotsValue: scala.Option[String] = scala.Option(impl.slots()).map(value => value: String)
    override def sessionAttributesValue: scala.Option[String] = scala.Option(impl.sessionAttributes()).map(value => value: String)
    override def messageValue: scala.Option[primitives.Text] = scala.Option(impl.message()).map(value => value: primitives.Text)
    override def encodedMessageValue: scala.Option[primitives.SensitiveString] = scala.Option(impl.encodedMessage()).map(value => value: primitives.SensitiveString)
    override def messageFormatValue: scala.Option[MessageFormatType] = scala.Option(impl.messageFormat()).map(value => MessageFormatType.wrap(value))
    override def dialogStateValue: scala.Option[DialogState] = scala.Option(impl.dialogState()).map(value => DialogState.wrap(value))
    override def slotToElicitValue: scala.Option[String] = scala.Option(impl.slotToElicit()).map(value => value: String)
    override def sessionIdValue: scala.Option[String] = scala.Option(impl.sessionId()).map(value => value: String)
    override def activeContextsValue: scala.Option[primitives.ActiveContextsString] = scala.Option(impl.activeContexts()).map(value => value: primitives.ActiveContextsString)
  }
  def wrap(impl: software.amazon.awssdk.services.lexruntime.model.PutSessionResponse): ReadOnly = new Wrapper(impl)
}