package io.github.vigoo.zioaws.lexruntime.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait DialogState { def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState }
object DialogState {
  def wrap(value: software.amazon.awssdk.services.lexruntime.model.DialogState): DialogState = value match {
    case software.amazon.awssdk.services.lexruntime.model.DialogState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.UNKNOWN_TO_SDK_VERSION }
  case object ElicitIntent extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_INTENT }
  case object ConfirmIntent extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.CONFIRM_INTENT }
  case object ElicitSlot extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_SLOT }
  case object Fulfilled extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.FULFILLED }
  case object ReadyForFulfillment extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.READY_FOR_FULFILLMENT }
  case object Failed extends DialogState { override def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState = software.amazon.awssdk.services.lexruntime.model.DialogState.FAILED }
}