/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.ObjectProvider;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.narcissus.Narcissus;
import java.util.Map;
import sun.misc.Unsafe;

public interface AllocateInstanceFunction
extends Function<Class<?>, Object> {

    public static interface Native
    extends AllocateInstanceFunction {

        public static class ForJava7
        implements Native {
            public ForJava7(Map<Object, Object> context) {
            }

            @Override
            public Object apply(Class<?> cls) {
                return Narcissus.allocateInstance(cls);
            }
        }
    }

    public static class ForJava7
    implements AllocateInstanceFunction {
        final Unsafe unsafe;
        final ThrowExceptionFunction throwExceptionFunction;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }

        @Override
        public Object apply(Class<?> input) {
            try {
                return this.unsafe.allocateInstance(input);
            }
            catch (InstantiationException exc) {
                return this.throwExceptionFunction.apply(exc, new Object[0]);
            }
        }
    }
}

