/*
 * Decompiled with CFR 0.152.
 */
package io.github.thingersoft.pm.mojo;

import io.github.thingersoft.pm.api.data.PropertiesStoreOptions;
import io.github.thingersoft.pm.api.data.SupportedTypes;
import io.github.thingersoft.pm.mojo.FieldMapping;
import io.github.thingersoft.pm.mojo.jtwig.JoinAndWrapJtwigFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.EnvironmentConfigurationBuilder;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractMojo {
    public static final String GOAL = "generate";
    public static final String GENERATED_CLASS_NAME = "ApplicationProperties";
    @Parameter(property="project", defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private List<String> propertiesLocations;
    @Parameter
    private PropertiesStoreOptions options;
    @Parameter(required=true)
    private List<File> templateFiles;
    @Parameter(required=true)
    private String basePackage;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/properties-manager")
    private File generatedSourcesDirectory;
    @Parameter
    private List<FieldMapping> fieldMappings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.generateSources(this.templateFiles, this.generatedSourcesDirectory, this.basePackage, this.options, this.propertiesLocations, this.fieldMappings);
    }

    public void generateSources(List<File> templateFiles, File generatedSourcesDirectory, String basePackage, PropertiesStoreOptions options, List<String> propertiesLocations, List<FieldMapping> fieldMappings) throws MojoExecutionException {
        Properties templateProperties = new Properties();
        for (File file : templateFiles) {
            Properties properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    properties.load(fileInputStream);
                    templateProperties.putAll((Map<?, ?>)properties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Can't read properties template file", (Exception)iOException);
            }
        }
        ArrayList<String> propertiesLocationsStrings = new ArrayList<String>();
        if (propertiesLocations != null) {
            for (String string : propertiesLocations) {
                propertiesLocationsStrings.add(string.replace("\\", "/"));
            }
        }
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        if (fieldMappings != null) {
            arrayList.addAll(fieldMappings);
        }
        for (Object object : templateProperties.keySet()) {
            String stringKey = (String)object;
            FieldMapping fieldMapping = new FieldMapping();
            fieldMapping.setPropertyKey(stringKey);
            fieldMapping.setFieldName(this.toUncapitalizedCamelCase(stringKey));
            fieldMapping.setFieldtype(SupportedTypes.STRING);
            if (arrayList.contains(fieldMapping)) continue;
            arrayList.add(fieldMapping);
        }
        EnvironmentConfiguration environmentConfiguration = ((EnvironmentConfigurationBuilder)EnvironmentConfigurationBuilder.configuration().functions().add((Object)new JoinAndWrapJtwigFunction()).and()).build();
        JtwigTemplate jtwigTemplate = JtwigTemplate.classpathTemplate((String)"/ApplicationProperties.twig", (EnvironmentConfiguration)environmentConfiguration);
        JtwigModel model = JtwigModel.newModel().with("basePackage", (Object)basePackage).with("fieldMappings", arrayList).with("propertiesLocations", propertiesLocationsStrings).with("options", (Object)(options != null ? options : new PropertiesStoreOptions()));
        try {
            Path outputDirectoryPath = Files.createDirectories(Paths.get(generatedSourcesDirectory.getAbsolutePath(), basePackage.replaceAll("\\.", "/")), new FileAttribute[0]);
            Path outputFilePath = outputDirectoryPath.resolve("ApplicationProperties.java");
            try (OutputStream os = Files.newOutputStream(outputFilePath, new OpenOption[0]);){
                jtwigTemplate.render(model, os);
            }
            if (this.project != null) {
                this.project.addCompileSourceRoot(generatedSourcesDirectory.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write to output folder", (Exception)e);
        }
    }

    private String toUncapitalizedCamelCase(String inputString) {
        String[] splittedInputString = inputString.split("[_\\-\\.]");
        String outputString = StringUtils.uncapitalize((String)splittedInputString[0]);
        for (int i = 1; i < splittedInputString.length; ++i) {
            outputString = outputString + StringUtils.capitalize((String)splittedInputString[i]);
        }
        return outputString;
    }
}

