/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.views;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import io.github.thibaultbee.streampack.internal.utils.extensions.SizeExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\u00a8\u0006\b"}, d2={"getPreviewOutputSize", "Landroid/util/Size;", "T", "characteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "targetSize", "targetClass", "Ljava/lang/Class;", "core_release"})
@SourceDebugExtension(value={"SMAP\nCameraSizes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraSizes.kt\nio/github/thibaultbee/streampack/views/CameraSizesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n*S KotlinDebug\n*F\n+ 1 CameraSizes.kt\nio/github/thibaultbee/streampack/views/CameraSizesKt\n*L\n41#1:47\n41#1:48,3\n*E\n"})
public final class CameraSizesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Size getPreviewOutputSize(@NotNull CameraCharacteristics characteristics, @NotNull Size targetSize, @NotNull Class<T> targetClass) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)characteristics, (String)"characteristics");
        Intrinsics.checkNotNullParameter((Object)targetSize, (String)"targetSize");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        Object object = characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Intrinsics.checkNotNull((Object)object);
        Size[] sizeArray = ((StreamConfigurationMap)object).getOutputSizes(targetClass);
        Intrinsics.checkNotNullExpressionValue((Object)sizeArray, (String)"getOutputSizes(...)");
        List allSizes = ArraysKt.toList((Object[])sizeArray);
        Iterable iterable = CollectionsKt.sortedWith((Iterable)allSizes, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Size it = (Size)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHeight() * it.getWidth());
                it = (Size)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHeight() * it.getWidth()));
            }
        });
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Size size2 = (Size)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Size(it.getWidth(), it.getHeight()));
        }
        List validSizes = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        return SizeExtensionsKt.closestTo(validSizes, targetSize);
    }
}

