/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001)B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0016J \u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0005H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/github/thibaultbee/streampack/utils/ChunkedFileOutputStream;", "Ljava/io/OutputStream;", "filesDir", "Ljava/io/File;", "chunkSize", "", "chunkNameGenerator", "Lkotlin/Function1;", "", "listener", "Lio/github/thibaultbee/streampack/utils/ChunkedFileOutputStream$Listener;", "(Ljava/io/File;ILkotlin/jvm/functions/Function1;Lio/github/thibaultbee/streampack/utils/ChunkedFileOutputStream$Listener;)V", "_isClosed", "", "_numOfFiles", "currentFileBytesWritten", "fileId", "getFileId", "()I", "getFilesDir", "()Ljava/io/File;", "isClosed", "()Z", "numOfFiles", "getNumOfFiles", "outputStream", "Ljava/io/FileOutputStream;", "totalBytesWritten", "close", "", "closeOutputStream", "isLast", "flush", "getFile", "getOutputStream", "write", "b", "", "offset", "len", "i", "Listener", "core_release"})
@SourceDebugExtension(value={"SMAP\nChunkedFileOutputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkedFileOutputStream.kt\nio/github/thibaultbee/streampack/utils/ChunkedFileOutputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class ChunkedFileOutputStream
extends OutputStream {
    @NotNull
    private final File filesDir;
    private final int chunkSize;
    @NotNull
    private final Function1<Integer, String> chunkNameGenerator;
    @NotNull
    private final Listener listener;
    private int currentFileBytesWritten;
    private int totalBytesWritten;
    private boolean _isClosed;
    private int _numOfFiles;
    @Nullable
    private FileOutputStream outputStream;

    public ChunkedFileOutputStream(@NotNull File filesDir, int chunkSize, @NotNull Function1<? super Integer, String> chunkNameGenerator, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)filesDir, (String)"filesDir");
        Intrinsics.checkNotNullParameter(chunkNameGenerator, (String)"chunkNameGenerator");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.filesDir = filesDir;
        this.chunkSize = chunkSize;
        this.chunkNameGenerator = chunkNameGenerator;
        this.listener = listener;
        if (!(this.chunkSize > 0)) {
            boolean $i$a$-require-ChunkedFileOutputStream$62 = false;
            String $i$a$-require-ChunkedFileOutputStream$62 = "Part size must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-ChunkedFileOutputStream$62.toString());
        }
        if (!this.filesDir.isDirectory()) {
            boolean $i$a$-require-ChunkedFileOutputStream$72 = false;
            String $i$a$-require-ChunkedFileOutputStream$72 = "Files directory must be a directory";
            throw new IllegalArgumentException($i$a$-require-ChunkedFileOutputStream$72.toString());
        }
        if (!this.filesDir.canWrite()) {
            boolean bl = false;
            String string2 = "Files directory must be writable";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ ChunkedFileOutputStream(File file, int n, Function1 function1, Listener listener, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            listener = new Listener(){

                @Override
                public void onFileClosed(int index, boolean isLast, @NotNull File file) {
                    Listener.DefaultImpls.onFileClosed(this, index, isLast, file);
                }
            };
        }
        this(file, n, (Function1<? super Integer, String>)function1, listener);
    }

    @NotNull
    public final File getFilesDir() {
        return this.filesDir;
    }

    public final int getNumOfFiles() {
        return this._numOfFiles;
    }

    private final int getFileId() {
        return this.getNumOfFiles() - 1;
    }

    public final boolean isClosed() {
        return this._isClosed;
    }

    private final File getFile() {
        return new File(this.filesDir, (String)this.chunkNameGenerator.invoke((Object)this.getFileId()));
    }

    private final void closeOutputStream(FileOutputStream outputStream, boolean isLast) {
        outputStream.close();
        this.listener.onFileClosed(this.getFileId(), isLast, this.getFile());
    }

    private final FileOutputStream getOutputStream() {
        if (this.currentFileBytesWritten >= this.chunkSize || this.outputStream == null) {
            FileOutputStream fileOutputStream = this.outputStream;
            if (fileOutputStream != null) {
                FileOutputStream it = fileOutputStream;
                boolean bl = false;
                this.closeOutputStream(it, false);
            }
            this.currentFileBytesWritten = 0;
            int n = this._numOfFiles;
            this._numOfFiles = n + 1;
            this.outputStream = new FileOutputStream(this.getFile());
        }
        FileOutputStream fileOutputStream = this.outputStream;
        Intrinsics.checkNotNull((Object)fileOutputStream);
        return fileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int i) {
        if (this._isClosed) {
            throw new IllegalStateException("Stream is closed");
        }
        ChunkedFileOutputStream chunkedFileOutputStream = this;
        synchronized (chunkedFileOutputStream) {
            boolean bl = false;
            FileOutputStream outputStream = this.getOutputStream();
            outputStream.write(i);
            Unit unit = Unit.INSTANCE;
        }
        int n = this.currentFileBytesWritten;
        this.currentFileBytesWritten = n + 1;
        n = this.totalBytesWritten;
        this.totalBytesWritten = n + 1;
    }

    @Override
    public void write(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull byte[] b, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this._isClosed) {
            throw new IllegalStateException("Stream is closed");
        }
        int remainingBytes = 0;
        int numOfBytesWritten = 0;
        ChunkedFileOutputStream chunkedFileOutputStream = this;
        synchronized (chunkedFileOutputStream) {
            int bytesToWrite;
            boolean bl = false;
            for (remainingBytes = len; remainingBytes > 0; remainingBytes -= bytesToWrite) {
                FileOutputStream outputStream = this.getOutputStream();
                bytesToWrite = Math.min(remainingBytes, this.chunkSize - this.currentFileBytesWritten);
                outputStream.write(b, offset + numOfBytesWritten, bytesToWrite);
                this.currentFileBytesWritten += bytesToWrite;
                this.totalBytesWritten += bytesToWrite;
                numOfBytesWritten += bytesToWrite;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        block1: {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            FileOutputStream fileOutputStream = this.outputStream;
            if (fileOutputStream == null) break block1;
            FileOutputStream it = fileOutputStream;
            boolean bl = false;
            this.closeOutputStream(it, true);
        }
    }

    @Override
    public void flush() {
        block0: {
            FileOutputStream fileOutputStream = this.outputStream;
            if (fileOutputStream == null) break block0;
            fileOutputStream.flush();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/utils/ChunkedFileOutputStream$Listener;", "", "onFileClosed", "", "index", "", "isLast", "", "file", "Ljava/io/File;", "core_release"})
    public static interface Listener {
        public void onFileClosed(int var1, boolean var2, @NotNull File var3);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onFileClosed(@NotNull Listener $this, int index, boolean isLast, @NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            }
        }
    }
}

