/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.helpers;

import android.util.Range;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.muxers.IAudioMuxerHelper;
import io.github.thibaultbee.streampack.streamers.helpers.IAudioConfigurationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0016J\u001e\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\f0\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/github/thibaultbee/streampack/streamers/helpers/AudioStreamerConfigurationHelper;", "Lio/github/thibaultbee/streampack/streamers/helpers/IAudioConfigurationHelper;", "audioMuxerHelper", "Lio/github/thibaultbee/streampack/internal/muxers/IAudioMuxerHelper;", "(Lio/github/thibaultbee/streampack/internal/muxers/IAudioMuxerHelper;)V", "supportedEncoders", "", "", "getSupportedEncoders", "()Ljava/util/List;", "getSupportedBitrates", "Landroid/util/Range;", "", "mimeType", "getSupportedByteFormats", "getSupportedInputChannelRange", "kotlin.jvm.PlatformType", "getSupportedProfiles", "getSupportedSampleRates", "core_release"})
@SourceDebugExtension(value={"SMAP\nStreamerConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamerConfigurationHelper.kt\nio/github/thibaultbee/streampack/streamers/helpers/AudioStreamerConfigurationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n766#2:305\n857#2,2:306\n766#2:308\n857#2,2:309\n766#2:311\n857#2,2:312\n*S KotlinDebug\n*F\n+ 1 StreamerConfigurationHelper.kt\nio/github/thibaultbee/streampack/streamers/helpers/AudioStreamerConfigurationHelper\n*L\n78#1:305\n78#1:306,2\n109#1:308\n109#1:309,2\n130#1:311\n130#1:312,2\n*E\n"})
public final class AudioStreamerConfigurationHelper
implements IAudioConfigurationHelper {
    @NotNull
    private final IAudioMuxerHelper audioMuxerHelper;
    @NotNull
    private final List<String> supportedEncoders;

    /*
     * WARNING - void declaration
     */
    public AudioStreamerConfigurationHelper(@NotNull IAudioMuxerHelper audioMuxerHelper) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)audioMuxerHelper, (String)"audioMuxerHelper");
        this.audioMuxerHelper = audioMuxerHelper;
        Iterable iterable = MediaCodecHelper.Audio.INSTANCE.getSupportedEncoders();
        AudioStreamerConfigurationHelper audioStreamerConfigurationHelper = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.audioMuxerHelper.getSupportedEncoders().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        audioStreamerConfigurationHelper.supportedEncoders = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<String> getSupportedEncoders() {
        return this.supportedEncoders;
    }

    @Override
    @NotNull
    public Range<Integer> getSupportedBitrates(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.Audio.INSTANCE.getBitrateRange(mimeType);
    }

    @Override
    @NotNull
    public Range<Integer> getSupportedInputChannelRange(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.Audio.INSTANCE.getInputChannelRange(mimeType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> getSupportedSampleRates(@NotNull String mimeType) {
        List list;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        List codecSampleRates = ArraysKt.toList((int[])MediaCodecHelper.Audio.INSTANCE.getSupportedSampleRates(mimeType));
        List<Integer> list2 = this.audioMuxerHelper.getSupportedSampleRates();
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            List<Integer> muxerSampleRates = list2;
            boolean bl = false;
            Iterable $this$filter$iv = codecSampleRates;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if (!muxerSampleRates.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = codecSampleRates;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> getSupportedByteFormats() {
        List list;
        Object[] objectArray = new Integer[]{3, 2, 4};
        List codecByteFormats = CollectionsKt.listOf((Object[])objectArray);
        List<Integer> list2 = this.audioMuxerHelper.getSupportedByteFormats();
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            List<Integer> muxerByteFormats = list2;
            boolean bl = false;
            Iterable $this$filter$iv = codecByteFormats;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if (!muxerByteFormats.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = codecByteFormats;
        }
        return list;
    }

    @NotNull
    public final List<Integer> getSupportedProfiles(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.INSTANCE.getProfiles(mimeType);
    }
}

