/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.extensions;

import android.graphics.PointF;
import android.graphics.Rect;
import android.util.Range;
import android.util.Rational;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a/\u0010\u0004\u001a\u0002H\u0005\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0006*\u0002H\u00052\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\t\u001a-\u0010\u0004\u001a\u0002H\u0005\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0006*\u0002H\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u000f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0013*\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0013\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0019"}, d2={"isNormalized", "", "Landroid/graphics/PointF;", "(Landroid/graphics/PointF;)Z", "clamp", "T", "", "min", "max", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;)Ljava/lang/Comparable;", "range", "Landroid/util/Range;", "(Ljava/lang/Comparable;Landroid/util/Range;)Ljava/lang/Comparable;", "flip", "Landroid/util/Rational;", "normalize", "rect", "Landroid/graphics/Rect;", "width", "", "height", "numOfBits", "", "rotate", "rotation", "core_release"})
public final class ExtensionsKt {
    public static final int numOfBits(@NotNull Object $this$numOfBits) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$numOfBits, (String)"<this>");
        Object object = $this$numOfBits;
        if (object instanceof Byte) {
            n = 8;
        } else if (object instanceof Short) {
            n = 16;
        } else if (object instanceof Integer) {
            n = 32;
        } else if (object instanceof Long) {
            n = 64;
        } else if (object instanceof Float) {
            n = 32;
        } else if (object instanceof Double) {
            n = 64;
        } else if (object instanceof Boolean) {
            n = 1;
        } else if (object instanceof Character) {
            n = 16;
        } else if (object instanceof String) {
            n = 16 * ((String)$this$numOfBits).length();
        } else if (object instanceof byte[]) {
            n = 8 * ((byte[])$this$numOfBits).length;
        } else if (object instanceof short[]) {
            n = 16 * ((short[])$this$numOfBits).length;
        } else if (object instanceof int[]) {
            n = 32 * ((int[])$this$numOfBits).length;
        } else if (object instanceof long[]) {
            n = 64 * ((long[])$this$numOfBits).length;
        } else if (object instanceof float[]) {
            n = 32 * ((float[])$this$numOfBits).length;
        } else if (object instanceof double[]) {
            n = 64 * ((double[])$this$numOfBits).length;
        } else if (object instanceof boolean[]) {
            n = ((boolean[])$this$numOfBits).length;
        } else if (object instanceof char[]) {
            n = 16 * ((char[])$this$numOfBits).length;
        } else {
            throw new IllegalArgumentException("Unsupported type: " + $this$numOfBits.getClass().getName());
        }
        return n;
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T clamp(@NotNull T $this$clamp, @NotNull T min, @NotNull T max) {
        Intrinsics.checkNotNullParameter($this$clamp, (String)"<this>");
        Intrinsics.checkNotNullParameter(min, (String)"min");
        Intrinsics.checkNotNullParameter(max, (String)"max");
        return max.compareTo(min) >= 0 ? ($this$clamp.compareTo(min) < 0 ? min : ($this$clamp.compareTo(max) > 0 ? max : $this$clamp)) : ($this$clamp.compareTo(max) < 0 ? max : ($this$clamp.compareTo(min) > 0 ? min : $this$clamp));
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T clamp(@NotNull T $this$clamp, @NotNull Range<T> range) {
        Intrinsics.checkNotNullParameter($this$clamp, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        Comparable comparable = range.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getLower(...)");
        Comparable comparable2 = range.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getUpper(...)");
        return (T)ExtensionsKt.clamp($this$clamp, comparable, comparable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNormalized(@NotNull PointF $this$isNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$isNormalized, (String)"<this>");
        float f = $this$isNormalized.x;
        if (!(0.0f <= f)) return false;
        if (!(f <= 1.0f)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = $this$isNormalized.y;
        if (!(0.0f <= f)) return false;
        if (!(f <= 1.0f)) return false;
        return true;
    }

    @NotNull
    public static final PointF rotate(@NotNull PointF $this$rotate, int rotation) {
        PointF pointF;
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        switch (rotation) {
            case 0: {
                pointF = $this$rotate;
                break;
            }
            case 90: {
                pointF = new PointF($this$rotate.y, 1.0f - $this$rotate.x);
                break;
            }
            case 180: {
                pointF = new PointF(1.0f - $this$rotate.x, 1.0f - $this$rotate.y);
                break;
            }
            case 270: {
                pointF = new PointF(1.0f - $this$rotate.y, $this$rotate.x);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rotation: " + rotation);
            }
        }
        return pointF;
    }

    @NotNull
    public static final PointF normalize(@NotNull PointF $this$normalize, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        return new PointF($this$normalize.x / (float)width, $this$normalize.y / (float)height);
    }

    @NotNull
    public static final PointF normalize(@NotNull PointF $this$normalize, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new PointF($this$normalize.x / (float)rect.width(), $this$normalize.y / (float)rect.height());
    }

    @NotNull
    public static final Rational flip(@NotNull Rational $this$flip) {
        Intrinsics.checkNotNullParameter((Object)$this$flip, (String)"<this>");
        return new Rational($this$flip.getDenominator(), $this$flip.getNumerator());
    }
}

