/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.opus;

import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006!"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "version", "", "channelCount", "preSkip", "", "inputSampleRate", "", "outputGain", "channelMappingFamily", "channelMapping", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$ChannelMapping;", "(BBSISBLio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$ChannelMapping;)V", "getChannelCount", "()B", "getChannelMapping", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$ChannelMapping;", "getChannelMappingFamily", "getInputSampleRate", "()I", "getOutputGain", "()S", "getPreSkip", "size", "getSize", "getVersion", "write", "", "output", "Ljava/nio/ByteBuffer;", "ChannelMapping", "Companion", "core_release"})
public final class IdentificationHeader
extends ByteBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte version;
    private final byte channelCount;
    private final short preSkip;
    private final int inputSampleRate;
    private final short outputGain;
    private final byte channelMappingFamily;
    @Nullable
    private final ChannelMapping channelMapping;
    private final int size;
    private static final int MAGIC_SIGNATURE_SIZE = 8;
    @NotNull
    private static final String MAGIC_SIGNATURE = "OpusHead";

    public IdentificationHeader(byte version, byte channelCount, short preSkip, int inputSampleRate, short outputGain, byte channelMappingFamily, @Nullable ChannelMapping channelMapping) {
        this.version = version;
        this.channelCount = channelCount;
        this.preSkip = preSkip;
        this.inputSampleRate = inputSampleRate;
        this.outputGain = outputGain;
        this.channelMappingFamily = channelMappingFamily;
        ChannelMapping channelMapping2 = this.channelMapping = channelMapping;
        this.size = 19 + (channelMapping2 != null ? channelMapping2.getSize() : 0);
    }

    public final byte getVersion() {
        return this.version;
    }

    public final byte getChannelCount() {
        return this.channelCount;
    }

    public final short getPreSkip() {
        return this.preSkip;
    }

    public final int getInputSampleRate() {
        return this.inputSampleRate;
    }

    public final short getOutputGain() {
        return this.outputGain;
    }

    public final byte getChannelMappingFamily() {
        return this.channelMappingFamily;
    }

    @Nullable
    public final ChannelMapping getChannelMapping() {
        return this.channelMapping;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        throw new NotImplementedError("Write Opus identification header is not implemented");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$ChannelMapping;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "streamCount", "", "coupledCount", "channelMapping", "", "(BB[B)V", "size", "", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "Companion", "core_release"})
    public static final class ChannelMapping
    extends ByteBufferWriter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final byte streamCount;
        private final byte coupledCount;
        @NotNull
        private final byte[] channelMapping;
        private final int size;

        public ChannelMapping(byte streamCount, byte coupledCount, @NotNull byte[] channelMapping) {
            Intrinsics.checkNotNullParameter((Object)channelMapping, (String)"channelMapping");
            this.streamCount = streamCount;
            this.coupledCount = coupledCount;
            this.channelMapping = channelMapping;
            this.size = 2 + this.channelMapping.length;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void write(@NotNull ByteBuffer output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            output.put(this.streamCount);
            output.put(this.coupledCount);
            output.put(this.channelMapping);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$ChannelMapping$Companion;", "", "()V", "parse", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$ChannelMapping;", "buffer", "Ljava/nio/ByteBuffer;", "outputChannelCount", "", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ChannelMapping parse(@NotNull ByteBuffer buffer, byte outputChannelCount) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                byte streamCount = buffer.get();
                byte coupledCount = buffer.get();
                byte[] channelMappingArray = new byte[1 * outputChannelCount];
                buffer.get(channelMappingArray);
                return new ChannelMapping(streamCount, coupledCount, channelMappingArray);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$Companion;", "", "()V", "MAGIC_SIGNATURE", "", "MAGIC_SIGNATURE_SIZE", "", "isIdentificationHeader", "", "buffer", "Ljava/nio/ByteBuffer;", "parse", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nIdentificationHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentificationHeader.kt\nio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIdentificationHeader(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return ByteBufferExtensionsKt.startWith(buffer, IdentificationHeader.MAGIC_SIGNATURE);
        }

        @NotNull
        public final IdentificationHeader parse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            String magicSignature = ByteBufferExtensionsKt.getString(buffer, 8);
            if (!Intrinsics.areEqual((Object)magicSignature, (Object)IdentificationHeader.MAGIC_SIGNATURE)) {
                boolean $i$a$-require-IdentificationHeader$Companion$parse$22 = false;
                String $i$a$-require-IdentificationHeader$Companion$parse$22 = "Magic signature OpusHead expected but " + magicSignature;
                throw new IllegalArgumentException($i$a$-require-IdentificationHeader$Companion$parse$22.toString());
            }
            byte version = buffer.get();
            byte channelCount = buffer.get();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            short preSkip = buffer.getShort();
            int inputSampleRate = buffer.getInt();
            short outputGain = buffer.getShort();
            buffer.order(ByteOrder.BIG_ENDIAN);
            byte channelMappingFamily = buffer.get();
            ChannelMapping channelMapping = channelMappingFamily != 0 ? ChannelMapping.Companion.parse(buffer, channelCount) : null;
            return new IdentificationHeader(version, channelCount, preSkip, inputSampleRate, outputGain, channelMappingFamily, channelMapping);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

