/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.aac;

import io.github.thibaultbee.streampack.internal.utils.av.audio.AudioSpecificConfig;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.BitBuffer;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.BitBufferWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019Ba\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/StreamMuxConfig;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBufferWriter;", "audioMuxVersion", "", "audioMuxVersionA", "allStreamsSameTimeFraming", "", "numSubFrames", "numProgram", "numLayer", "audioSpecificConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "frameLengthType", "(IILjava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;Ljava/lang/Integer;)V", "getAllStreamsSameTimeFraming", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getAudioMuxVersionA", "()I", "bitSize", "getBitSize", "Ljava/lang/Integer;", "write", "", "output", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nAudioMuxElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioMuxElement.kt\nio/github/thibaultbee/streampack/internal/utils/av/audio/aac/StreamMuxConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class StreamMuxConfig
extends BitBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int audioMuxVersion;
    private final int audioMuxVersionA;
    @Nullable
    private final Boolean allStreamsSameTimeFraming;
    @Nullable
    private final Integer numSubFrames;
    @Nullable
    private final Integer numProgram;
    @Nullable
    private final Integer numLayer;
    @Nullable
    private final BitBuffer audioSpecificConfig;
    @Nullable
    private final Integer frameLengthType;
    private final int bitSize;

    public StreamMuxConfig(int audioMuxVersion, int audioMuxVersionA, @Nullable Boolean allStreamsSameTimeFraming, @Nullable Integer numSubFrames, @Nullable Integer numProgram, @Nullable Integer numLayer, @Nullable BitBuffer audioSpecificConfig, @Nullable Integer frameLengthType) {
        int n;
        this.audioMuxVersion = audioMuxVersion;
        this.audioMuxVersionA = audioMuxVersionA;
        this.allStreamsSameTimeFraming = allStreamsSameTimeFraming;
        this.numSubFrames = numSubFrames;
        this.numProgram = numProgram;
        this.numLayer = numLayer;
        this.audioSpecificConfig = audioSpecificConfig;
        this.frameLengthType = frameLengthType;
        int n2 = 1 + (this.audioMuxVersion == 1 ? 1 : 0);
        if (this.audioMuxVersionA == 0) {
            BitBuffer bitBuffer = this.audioSpecificConfig;
            Intrinsics.checkNotNull((Object)bitBuffer);
            n = 27 + bitBuffer.getBitEnd();
        } else {
            n = 0;
        }
        this.bitSize = n2 + n;
        if (this.audioMuxVersionA == 0) {
            if (!(this.allStreamsSameTimeFraming != null)) {
                boolean $i$a$-require-StreamMuxConfig$72 = false;
                String $i$a$-require-StreamMuxConfig$72 = "allStreamsSameTimeFraming must be set";
                throw new IllegalArgumentException($i$a$-require-StreamMuxConfig$72.toString());
            }
            if (!(this.numSubFrames != null)) {
                boolean $i$a$-require-StreamMuxConfig$82 = false;
                String $i$a$-require-StreamMuxConfig$82 = "numSubFrames must be set";
                throw new IllegalArgumentException($i$a$-require-StreamMuxConfig$82.toString());
            }
            if (!(this.numProgram != null)) {
                boolean $i$a$-require-StreamMuxConfig$92 = false;
                String $i$a$-require-StreamMuxConfig$92 = "numProgram must be set";
                throw new IllegalArgumentException($i$a$-require-StreamMuxConfig$92.toString());
            }
            if (!(this.numLayer != null)) {
                boolean $i$a$-require-StreamMuxConfig$102 = false;
                String $i$a$-require-StreamMuxConfig$102 = "numLayer must be set";
                throw new IllegalArgumentException($i$a$-require-StreamMuxConfig$102.toString());
            }
            if (!(this.audioSpecificConfig != null)) {
                boolean $i$a$-require-StreamMuxConfig$112 = false;
                String $i$a$-require-StreamMuxConfig$112 = "audioSpecificConfig must be set";
                throw new IllegalArgumentException($i$a$-require-StreamMuxConfig$112.toString());
            }
            if (!(this.frameLengthType != null)) {
                boolean bl = false;
                String string2 = "frameLengthType must be set";
                throw new IllegalArgumentException(string2.toString());
            }
        }
    }

    public /* synthetic */ StreamMuxConfig(int n, int n2, Boolean bl, Integer n3, Integer n4, Integer n5, BitBuffer bitBuffer, Integer n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 1) != 0) {
            n = 0;
        }
        if ((n7 & 2) != 0) {
            n2 = 0;
        }
        if ((n7 & 4) != 0) {
            bl = null;
        }
        if ((n7 & 8) != 0) {
            n3 = null;
        }
        if ((n7 & 0x10) != 0) {
            n4 = null;
        }
        if ((n7 & 0x20) != 0) {
            n5 = null;
        }
        if ((n7 & 0x40) != 0) {
            bitBuffer = null;
        }
        if ((n7 & 0x80) != 0) {
            n6 = null;
        }
        this(n, n2, bl, n3, n4, n5, bitBuffer, n6);
    }

    public final int getAudioMuxVersionA() {
        return this.audioMuxVersionA;
    }

    @Nullable
    public final Boolean getAllStreamsSameTimeFraming() {
        return this.allStreamsSameTimeFraming;
    }

    @Override
    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void write(@NotNull BitBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.put(this.audioMuxVersion, 1);
        if (this.audioMuxVersion == 1) {
            output.put(this.audioMuxVersionA, 1);
        }
        if (this.audioMuxVersionA == 0) {
            Boolean bl = this.allStreamsSameTimeFraming;
            Intrinsics.checkNotNull((Object)bl);
            output.put(bl);
            Integer n = this.numSubFrames;
            Intrinsics.checkNotNull((Object)n);
            output.put(n, 6);
            Integer n2 = this.numProgram;
            Intrinsics.checkNotNull((Object)n2);
            output.put(n2, 4);
            Integer n3 = this.numLayer;
            Intrinsics.checkNotNull((Object)n3);
            output.put(n3, 3);
            BitBuffer bitBuffer = this.audioSpecificConfig;
            Intrinsics.checkNotNull((Object)bitBuffer);
            output.put(bitBuffer);
            Integer n4 = this.frameLengthType;
            Intrinsics.checkNotNull((Object)n4);
            output.put(n4, 3);
            output.put(255, 8);
            output.put(0, 1);
            output.put(0, 1);
        }
    }

    public StreamMuxConfig() {
        this(0, 0, null, null, null, null, null, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/StreamMuxConfig$Companion;", "", "()V", "fromDecoderSpecificInfo", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/StreamMuxConfig;", "decoderSpecificInfo", "Ljava/nio/ByteBuffer;", "parse", "bitBuffer", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "buffer", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamMuxConfig parse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BitBuffer bitBuffer = new BitBuffer(buffer, 0, 0, 6, null);
            return this.parse(bitBuffer);
        }

        @NotNull
        public final StreamMuxConfig parse(@NotNull BitBuffer bitBuffer) {
            Intrinsics.checkNotNullParameter((Object)bitBuffer, (String)"bitBuffer");
            int audioMuxVersion = bitBuffer.getInt(1);
            int audioMuxVersionA = audioMuxVersion == 1 ? bitBuffer.getInt(1) : 0;
            Boolean allStreamsSameTimeFraming = null;
            Integer numSubFrames = null;
            Integer numProgram = null;
            List audioSpecificConfigs = new ArrayList();
            List frameLengthTypes = new ArrayList();
            if (audioMuxVersionA == 0) {
                if (audioMuxVersion == 1) {
                    throw new NotImplementedError("audioMuxVersion == 1 is not implemented yet");
                }
                allStreamsSameTimeFraming = bitBuffer.getBoolean();
                numSubFrames = bitBuffer.getInt(6);
                int i = 0;
                numProgram = bitBuffer.getInt(4);
                int n = numProgram;
                if (i <= n) {
                    while (true) {
                        int numLayer;
                        int j;
                        if ((j = 0) <= (numLayer = bitBuffer.getInt(3))) {
                            while (true) {
                                boolean useSameConfig;
                                boolean bl = useSameConfig = i == 0 && j == 0 ? false : bitBuffer.getBoolean();
                                if (!useSameConfig) {
                                    if (audioMuxVersion == 0) {
                                        audioSpecificConfigs.add(AudioSpecificConfig.Companion.parse(bitBuffer));
                                    } else {
                                        throw new NotImplementedError("audioMuxVersion == 1 is not implemented yet");
                                    }
                                }
                                int frameLengthType = bitBuffer.getInt(3);
                                frameLengthTypes.add(frameLengthType);
                                if (frameLengthType != 0) {
                                    throw new NotImplementedError("frameLengthType " + frameLengthType + " is not implemented yet");
                                }
                                bitBuffer.getLong(8);
                                boolean otherDataPresent = bitBuffer.getBoolean();
                                if (otherDataPresent) {
                                    throw new NotImplementedError("otherDataPresent is not implemented yet");
                                }
                                boolean crcCheckPresent = bitBuffer.getBoolean();
                                if (crcCheckPresent) {
                                    throw new NotImplementedError("crcCheckPresent is not implemented yet");
                                }
                                if (j == numLayer) break;
                                ++j;
                            }
                        }
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            AudioSpecificConfig audioSpecificConfig = (AudioSpecificConfig)CollectionsKt.firstOrNull((List)audioSpecificConfigs);
            return new StreamMuxConfig(audioMuxVersion, audioMuxVersionA, allStreamsSameTimeFraming, numSubFrames, null, null, audioSpecificConfig != null ? audioSpecificConfig.toBitBuffer() : null, (Integer)CollectionsKt.firstOrNull((List)frameLengthTypes), 48, null);
        }

        @NotNull
        public final StreamMuxConfig fromDecoderSpecificInfo(@NotNull ByteBuffer decoderSpecificInfo) {
            Intrinsics.checkNotNullParameter((Object)decoderSpecificInfo, (String)"decoderSpecificInfo");
            AudioSpecificConfig audioSpecificConfig = AudioSpecificConfig.Companion.parse(decoderSpecificInfo);
            decoderSpecificInfo.rewind();
            BitBuffer bitBuffer = new BitBuffer(decoderSpecificInfo, 0, audioSpecificConfig.getBitSize() - 1, 2, null);
            return new StreamMuxConfig(0, 0, true, 0, 0, 0, bitBuffer, 0, 3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

