/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags.video;

import android.os.Build;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.TagType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.FrameType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.PacketType;
import io.github.thibaultbee.streampack.internal.utils.av.FourCCs;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000eX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/ExtendedVideoTag;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag;", "pts", "", "buffer", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "isKeyFrame", "", "packetType", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/PacketType;", "mimeType", "", "(JLio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;ZLio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/PacketType;Ljava/lang/String;)V", "bodySize", "", "getBodySize", "()I", "tagHeaderSize", "getTagHeaderSize", "computeBodySize", "writeBody", "", "output", "Ljava/nio/ByteBuffer;", "writeTagHeader", "Companion", "core_release"})
public final class ExtendedVideoTag
extends FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufferWriter buffer;
    private final boolean isKeyFrame;
    @NotNull
    private final PacketType packetType;
    @NotNull
    private final String mimeType;
    private final int tagHeaderSize;
    private final int bodySize;
    private static final int VIDEO_TAG_HEADER_SIZE = 5;

    public ExtendedVideoTag(long pts, @NotNull ByteBufferWriter buffer, boolean isKeyFrame, @NotNull PacketType packetType, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)((Object)packetType), (String)"packetType");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        super(pts, TagType.VIDEO, false, 4, null);
        this.buffer = buffer;
        this.isKeyFrame = isKeyFrame;
        this.packetType = packetType;
        this.mimeType = mimeType;
        if (!Companion.isSupportedCodec(this.mimeType)) {
            boolean bl = false;
            String string2 = "Only AV1, VP9 and HEVC are supported";
            throw new IllegalArgumentException(string2.toString());
        }
        this.tagHeaderSize = 5;
        this.bodySize = this.computeBodySize();
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        FrameType frameType = this.isKeyFrame ? FrameType.KEY : FrameType.INTER;
        ByteBufferExtensionsKt.put(output, 0x80 | frameType.getValue() << 4 | this.packetType.getValue());
        output.putInt(FourCCs.Companion.fromMimeType(this.mimeType).getValue().getCode());
    }

    @Override
    protected int getTagHeaderSize() {
        return this.tagHeaderSize;
    }

    @Override
    protected void writeBody(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        switch (WhenMappings.$EnumSwitchMapping$0[this.packetType.ordinal()]) {
            case 1: {
                throw new NotImplementedError("PacketType " + (Object)((Object)this.packetType) + " is not supported for " + this.mimeType);
            }
            case 2: {
                break;
            }
            default: {
                if (this.packetType == PacketType.CODED_FRAMES && Intrinsics.areEqual((Object)this.mimeType, (Object)"video/hevc")) {
                    ByteBufferExtensionsKt.putInt24(output, 0);
                }
                this.buffer.write(output);
            }
        }
    }

    @Override
    protected int getBodySize() {
        return this.bodySize;
    }

    private final int computeBodySize() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.packetType.ordinal()]) {
            case 1: {
                throw new NotImplementedError("PacketType " + (Object)((Object)this.packetType) + " is not supported for " + this.mimeType);
            }
            case 2: {
                break;
            }
            default: {
                int size2 = this.packetType == PacketType.CODED_FRAMES && Intrinsics.areEqual((Object)this.mimeType, (Object)"video/hevc") ? 3 : 0;
                return this.buffer.getSize() + size2;
            }
        }
        return 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/ExtendedVideoTag$Companion;", "", "()V", "VIDEO_TAG_HEADER_SIZE", "", "isSupportedCodec", "", "mimeType", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupportedCodec(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            boolean isAV1 = Build.VERSION.SDK_INT >= 29 ? Intrinsics.areEqual((Object)mimeType, (Object)"video/av01") : false;
            return isAV1 || Intrinsics.areEqual((Object)mimeType, (Object)"video/x-vnd.on2.vp9") || Intrinsics.areEqual((Object)mimeType, (Object)"video/hevc");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PacketType.values().length];
            try {
                nArray[PacketType.META_DATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PacketType.SEQUENCE_END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

