/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv;

import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.data.PacketType;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.flv.FlvMuxerHelper;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.AVTagsFactory;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvHeader;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.OnMetadata;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.utils.extensions.StringExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00011B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020&H\u0016J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0002J\b\u0010/\u001a\u00020)H\u0016J\b\u00100\u001a\u00020)H\u0016R\u0014\u0010\n\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer;", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "listener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "initialStreams", "", "Lio/github/thibaultbee/streampack/data/Config;", "writeToFile", "", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Ljava/util/List;Z)V", "hasAudio", "getHasAudio", "()Z", "hasFirstFrame", "hasVideo", "getHasVideo", "helper", "Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxerHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxerHelper;", "getListener", "()Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "setListener", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;)V", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "getSourceOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "setSourceOrientationProvider", "(Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;)V", "startUpTime", "", "Ljava/lang/Long;", "streams", "", "Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer$Stream;", "addStreams", "", "", "streamsConfig", "encode", "", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "streamPid", "release", "requireStreams", "startStream", "stopStream", "Stream", "core_release"})
@SourceDebugExtension(value={"SMAP\nFlvMuxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlvMuxer.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n1549#3:146\n1620#3,3:147\n1747#3,3:150\n1747#3,3:153\n1855#3,2:156\n1549#3:158\n1620#3,3:159\n1864#3,3:162\n1549#3:165\n1620#3,3:166\n766#3:169\n857#3,2:170\n766#3:172\n857#3,2:173\n*S KotlinDebug\n*F\n+ 1 FlvMuxer.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer\n*L\n46#1:146\n46#1:147,3\n39#1:150,3\n41#1:153,3\n78#1:156,2\n93#1:158\n93#1:159,3\n95#1:162,3\n113#1:165\n113#1:166,3\n134#1:169\n134#1:170,2\n136#1:172\n136#1:173,2\n*E\n"})
public final class FlvMuxer
implements IMuxer {
    @Nullable
    private IMuxerListener listener;
    private final boolean writeToFile;
    @NotNull
    private final FlvMuxerHelper helper;
    @NotNull
    private final List<Stream> streams;
    @Nullable
    private Long startUpTime;
    private boolean hasFirstFrame;
    @Nullable
    private ISourceOrientationProvider sourceOrientationProvider;

    /*
     * WARNING - void declaration
     */
    public FlvMuxer(@Nullable IMuxerListener listener, @Nullable List<? extends Config> initialStreams, boolean writeToFile) {
        block1: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.listener = listener;
            this.writeToFile = writeToFile;
            this.helper = new FlvMuxerHelper();
            this.streams = new ArrayList();
            List<? extends Config> list = initialStreams;
            if (list == null) break block1;
            List<? extends Config> config = list;
            boolean bl = false;
            Iterable iterable = config;
            List<Stream> list2 = this.streams;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Config config2 = (Config)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Stream((Config)it));
            }
            list2.addAll((List)destination$iv$iv);
        }
    }

    public /* synthetic */ FlvMuxer(IMuxerListener iMuxerListener, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        this(iMuxerListener, list, bl);
    }

    @Override
    @Nullable
    public IMuxerListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable IMuxerListener iMuxerListener) {
        this.listener = iMuxerListener;
    }

    @Override
    @NotNull
    public FlvMuxerHelper getHelper() {
        return this.helper;
    }

    private final boolean getHasAudio() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.streams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Stream it = (Stream)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isAudio(it.getConfig().getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean getHasVideo() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.streams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Stream it = (Stream)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isVideo(it.getConfig().getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public ISourceOrientationProvider getSourceOrientationProvider() {
        return this.sourceOrientationProvider;
    }

    @Override
    public void setSourceOrientationProvider(@Nullable ISourceOrientationProvider iSourceOrientationProvider) {
        this.sourceOrientationProvider = iSourceOrientationProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encode(@NotNull Frame frame, int streamPid) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (!this.hasFirstFrame) {
            if (this.getHasVideo()) {
                if (!frame.isVideo() || !frame.isKeyFrame()) return;
                this.startUpTime = frame.getPts();
                this.hasFirstFrame = true;
            } else {
                this.startUpTime = frame.getPts();
                this.hasFirstFrame = true;
            }
        }
        long l = frame.getPts();
        Long l2 = this.startUpTime;
        Intrinsics.checkNotNull((Object)l2);
        if (l < l2) {
            return;
        }
        long l3 = frame.getPts();
        Long l4 = this.startUpTime;
        Intrinsics.checkNotNull((Object)l4);
        frame.setPts(l3 - l4);
        Stream stream = this.streams.get(streamPid);
        boolean sendHeader = stream.getSendHeader();
        stream.setSendHeader(false);
        List<FlvTag> flvTags = new AVTagsFactory(frame, stream.getConfig(), sendHeader).build();
        Iterable $this$forEach$iv = flvTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlvTag it = (FlvTag)element$iv;
            boolean bl = false;
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener == null) continue;
            iMuxerListener.onOutputFrame(new Packet(it.write(), frame.getPts(), frame.isVideo() ? PacketType.VIDEO : PacketType.AUDIO));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Config, Integer> addStreams(@NotNull List<? extends Config> streamsConfig) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(streamsConfig, (String)"streamsConfig");
        Map streamMap = new LinkedHashMap();
        Iterable iterable = streamsConfig;
        List<Stream> list = this.streams;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Config config = (Config)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Stream((Config)it));
        }
        list.addAll((List)destination$iv$iv);
        this.requireStreams();
        Iterable $this$forEachIndexed$iv = this.streams;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void stream;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Stream)item$iv;
            int index = n;
            boolean bl = false;
            Integer n2 = index;
            streamMap.put(stream.getConfig(), n2);
        }
        return streamMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startStream() {
        block3: {
            Collection<Config> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.writeToFile) {
                IMuxerListener iMuxerListener = this.getListener();
                if (iMuxerListener != null) {
                    iMuxerListener.onOutputFrame(new Packet(new FlvHeader(this.getHasAudio(), this.getHasVideo()).write(), 0L, null, 4, null));
                }
            }
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener == null) break block3;
            Iterable iterable = this.streams;
            OnMetadata.Companion companion = OnMetadata.Companion;
            IMuxerListener iMuxerListener2 = iMuxerListener;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stream stream = (Stream)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getConfig());
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            PacketType packetType = null;
            long l = 0L;
            ByteBuffer byteBuffer = companion.fromConfigs((List<? extends Config>)collection, this.getSourceOrientationProvider()).write();
            iMuxerListener2.onOutputFrame(new Packet(byteBuffer, l, packetType, n, defaultConstructorMarker));
        }
    }

    @Override
    public void stopStream() {
        this.startUpTime = null;
        this.hasFirstFrame = false;
        this.streams.clear();
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - void declaration
     */
    private final void requireStreams() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = this.streams;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Stream it = (Stream)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isAudio(it.getConfig().getMimeType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List audioStreams = (List)destination$iv$iv;
        if (!(audioStreams.size() <= 1)) {
            boolean $i$a$-require-FlvMuxer$requireStreams$32 = false;
            String $i$a$-require-FlvMuxer$requireStreams$32 = "Only one audio stream is supported by FLV but got " + audioStreams;
            throw new IllegalArgumentException($i$a$-require-FlvMuxer$requireStreams$32.toString());
        }
        Iterable $this$filter$iv2 = this.streams;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Stream it = (Stream)element$iv$iv;
            boolean bl = false;
            if (!StringExtensionsKt.isVideo(it.getConfig().getMimeType())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List videoStreams = (List)destination$iv$iv2;
        if (!(videoStreams.size() <= 1)) {
            boolean bl = false;
            String string2 = "Only one video stream is supported by FLV but got " + videoStreams;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer$Stream;", "", "config", "Lio/github/thibaultbee/streampack/data/Config;", "(Lio/github/thibaultbee/streampack/data/Config;)V", "getConfig", "()Lio/github/thibaultbee/streampack/data/Config;", "sendHeader", "", "getSendHeader", "()Z", "setSendHeader", "(Z)V", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "core_release"})
    private static final class Stream {
        @NotNull
        private final Config config;
        private boolean sendHeader;

        public Stream(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.sendHeader = true;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        public final boolean getSendHeader() {
            return this.sendHeader;
        }

        public final void setSendHeader(boolean bl) {
            this.sendHeader = bl;
        }

        @NotNull
        public final Config component1() {
            return this.config;
        }

        @NotNull
        public final Stream copy(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new Stream(config);
        }

        public static /* synthetic */ Stream copy$default(Stream stream, Config config, int n, Object object) {
            if ((n & 1) != 0) {
                config = stream.config;
            }
            return stream.copy(config);
        }

        @NotNull
        public String toString() {
            return "Stream(config=" + this.config + ')';
        }

        public int hashCode() {
            return this.config.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stream)) {
                return false;
            }
            Stream stream = (Stream)other;
            return Intrinsics.areEqual((Object)this.config, (Object)stream.config);
        }
    }
}

