/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.data;

import android.media.MediaFormat;
import android.os.Build;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.utils.extensions.StringExtensionsKt;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/data/AudioConfig;", "Lio/github/thibaultbee/streampack/data/Config;", "mimeType", "", "startBitrate", "", "sampleRate", "channelConfig", "byteFormat", "profile", "enableEchoCanceler", "", "enableNoiseSuppressor", "(Ljava/lang/String;IIIIIZZ)V", "getByteFormat", "()I", "getChannelConfig", "getEnableEchoCanceler", "()Z", "getEnableNoiseSuppressor", "getSampleRate", "getFormat", "Landroid/media/MediaFormat;", "withProfileLevel", "getFormat$core_release", "toString", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nAudioConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioConfig.kt\nio/github/thibaultbee/streampack/data/AudioConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class AudioConfig
extends Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int sampleRate;
    private final int channelConfig;
    private final int byteFormat;
    private final boolean enableEchoCanceler;
    private final boolean enableNoiseSuppressor;

    public AudioConfig(@NotNull String mimeType, int startBitrate, int sampleRate, int channelConfig, int byteFormat, int profile, boolean enableEchoCanceler, boolean enableNoiseSuppressor) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        super(mimeType, startBitrate, profile);
        this.sampleRate = sampleRate;
        this.channelConfig = channelConfig;
        this.byteFormat = byteFormat;
        this.enableEchoCanceler = enableEchoCanceler;
        this.enableNoiseSuppressor = enableNoiseSuppressor;
        if (!StringExtensionsKt.isAudio(mimeType)) {
            boolean $i$a$-require-AudioConfig$32 = false;
            String $i$a$-require-AudioConfig$32 = "MimeType must be audio";
            throw new IllegalArgumentException($i$a$-require-AudioConfig$32.toString());
        }
        if (Intrinsics.areEqual((Object)mimeType, (Object)"audio/mp4a-latm") && profile == 29 && !(this.channelConfig == 12)) {
            boolean bl = false;
            String string = "AACObjectHE_PS only supports stereo";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AudioConfig(String string, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            string = "audio/mp4a-latm";
        }
        if ((n6 & 2) != 0) {
            n = 128000;
        }
        if ((n6 & 4) != 0) {
            n2 = AudioConfig.Companion.getDefaultSampleRate(string);
        }
        if ((n6 & 8) != 0) {
            n3 = 12;
        }
        if ((n6 & 0x10) != 0) {
            n4 = 2;
        }
        if ((n6 & 0x20) != 0) {
            n5 = AudioConfig.Companion.getDefaultProfile(string);
        }
        if ((n6 & 0x40) != 0) {
            bl = true;
        }
        if ((n6 & 0x80) != 0) {
            bl2 = true;
        }
        this(string, n, n2, n3, n4, n5, bl, bl2);
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannelConfig() {
        return this.channelConfig;
    }

    public final int getByteFormat() {
        return this.byteFormat;
    }

    public final boolean getEnableEchoCanceler() {
        return this.enableEchoCanceler;
    }

    public final boolean getEnableNoiseSuppressor() {
        return this.enableNoiseSuppressor;
    }

    @Override
    @NotNull
    public MediaFormat getFormat$core_release(boolean withProfileLevel) {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)this.getMimeType(), (int)this.sampleRate, (int)Companion.getNumberOfChannels(this.channelConfig));
        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"createAudioFormat(...)");
        MediaFormat format = mediaFormat;
        if (Build.VERSION.SDK_INT >= 24) {
            format.setInteger("pcm-encoding", this.byteFormat);
        }
        format.setInteger("bitrate", this.getStartBitrate());
        if (withProfileLevel && Intrinsics.areEqual((Object)this.getMimeType(), (Object)"audio/mp4a-latm")) {
            format.setInteger("aac-profile", this.getProfile());
        }
        format.setInteger("max-input-size", 0);
        return format;
    }

    @Override
    @NotNull
    public String toString() {
        return "AudioConfig(mimeType=" + this.getMimeType() + ", startBitrate=" + this.getStartBitrate() + ", sampleRate=" + this.sampleRate + ", channelConfig=" + this.channelConfig + ", byteFormat=" + this.byteFormat + ", enableEchoCanceler=" + this.enableEchoCanceler + ", enableNoiseSuppressor=" + this.enableNoiseSuppressor + ')';
    }

    public AudioConfig() {
        this(null, 0, 0, 0, 0, 0, false, false, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lio/github/thibaultbee/streampack/data/AudioConfig$Companion;", "", "()V", "getChannelConfig", "", "nChannel", "getDefaultProfile", "mimeType", "", "getDefaultSampleRate", "getNumOfBytesPerSample", "byteFormat", "getNumberOfChannels", "channelConfig", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getDefaultSampleRate(String mimeType) {
            int n;
            String string = mimeType;
            if (Intrinsics.areEqual((Object)string, (Object)"audio/mp4a-latm")) {
                n = 44100;
            } else if (Intrinsics.areEqual((Object)string, (Object)"audio/opus")) {
                n = 48000;
            } else {
                throw new InvalidParameterException("Mimetype not supported: " + mimeType);
            }
            return n;
        }

        private final int getDefaultProfile(String mimeType) {
            int n;
            String string = mimeType;
            if (Intrinsics.areEqual((Object)string, (Object)"audio/mp4a-latm")) {
                n = 2;
            } else if (Intrinsics.areEqual((Object)string, (Object)"audio/opus")) {
                n = 0;
            } else {
                throw new InvalidParameterException("Mimetype not supported: " + mimeType);
            }
            return n;
        }

        public final int getNumberOfChannels(int channelConfig) {
            int n;
            switch (channelConfig) {
                case 16: {
                    n = 1;
                    break;
                }
                case 12: {
                    n = 2;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Audio format not supported: " + channelConfig);
                }
            }
            return n;
        }

        public final int getChannelConfig(int nChannel) {
            int n;
            switch (nChannel) {
                case 1: {
                    n = 16;
                    break;
                }
                case 2: {
                    n = 12;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Number of channels not supported: " + nChannel);
                }
            }
            return n;
        }

        public final int getNumOfBytesPerSample(int byteFormat) {
            int n;
            switch (byteFormat) {
                case 3: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 21: {
                    n = 3;
                    break;
                }
                case 22: {
                    n = 4;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Byte format not supported: " + byteFormat);
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

