/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.core.app.ActivityCompat;
import io.github.thibaultbee.streampack.R;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.utils.CameraSettings;
import io.github.thibaultbee.streampack.utils.ContextExtensionsForCameraKt;
import io.github.thibaultbee.streampack.utils.OrientationUtils;
import io.github.thibaultbee.streampack.utils.Zoom;
import io.github.thibaultbee.streampack.views.AutoFitSurfaceView;
import io.github.thibaultbee.streampack.views.CameraSizesKt;
import io.github.thibaultbee.streampack.views.FacingDirection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 /2\u00020\u0001:\u0004/012B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020\u000eH\u0016J\u0012\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraFacingDirection", "Lio/github/thibaultbee/streampack/views/FacingDirection;", "defaultCameraId", "", "enableTapToFocus", "", "getEnableTapToFocus", "()Z", "setEnableTapToFocus", "(Z)V", "enableZoomOnPinch", "getEnableZoomOnPinch", "setEnableZoomOnPinch", "listener", "Lio/github/thibaultbee/streampack/views/PreviewView$Listener;", "getListener", "()Lio/github/thibaultbee/streampack/views/PreviewView$Listener;", "setListener", "(Lio/github/thibaultbee/streampack/views/PreviewView$Listener;)V", "pinchGesture", "Landroid/view/ScaleGestureDetector;", "value", "Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "streamer", "getStreamer", "()Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "setStreamer", "(Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;)V", "surfaceView", "Lio/github/thibaultbee/streampack/views/AutoFitSurfaceView;", "touchUpEvent", "Landroid/view/MotionEvent;", "onTouchEvent", "event", "performClick", "startPreviewIfReady", "", "shouldFailSilently", "Companion", "Listener", "PinchToZoomOnScaleGestureListener", "StreamerHolderCallback", "core_release"})
public final class PreviewView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AutoFitSurfaceView surfaceView;
    @NotNull
    private final FacingDirection cameraFacingDirection;
    @Nullable
    private final String defaultCameraId;
    private boolean enableZoomOnPinch;
    private boolean enableTapToFocus;
    @Nullable
    private MotionEvent touchUpEvent;
    @Nullable
    private ICameraStreamer streamer;
    @Nullable
    private Listener listener;
    @NotNull
    private final ScaleGestureDetector pinchGesture;
    @NotNull
    private static final String TAG = "PreviewView";
    @NotNull
    private static final FacingDirection DEFAULT_CAMERA_FACING = FacingDirection.BACK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public PreviewView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.surfaceView = new AutoFitSurfaceView(context, null, 0, 6, null);
        this.pinchGesture = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new PinchToZoomOnScaleGestureListener());
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PreviewView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray a = typedArray;
        try {
            String string2;
            String string3 = a.getString(R.styleable.PreviewView_cameraFacingDirection);
            if (string3 == null) {
                string3 = DEFAULT_CAMERA_FACING.getValue();
            }
            String string4 = string3;
            Intrinsics.checkNotNull((Object)string4);
            this.cameraFacingDirection = FacingDirection.Companion.fromValue(string4);
            switch (WhenMappings.$EnumSwitchMapping$0[this.cameraFacingDirection.ordinal()]) {
                case 1: {
                    string2 = (String)CollectionsKt.firstOrNull(ContextExtensionsForCameraKt.getFrontCameraList(context));
                    break;
                }
                case 2: {
                    string2 = (String)CollectionsKt.firstOrNull(ContextExtensionsForCameraKt.getBackCameraList(context));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.defaultCameraId = string2;
            this.enableZoomOnPinch = a.getBoolean(R.styleable.PreviewView_enableZoomOnPinch, true);
            this.enableTapToFocus = a.getBoolean(R.styleable.PreviewView_enableTapToFocus, true);
        }
        finally {
            a.recycle();
        }
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new StreamerHolderCallback());
        this.addView((View)this.surfaceView);
    }

    public /* synthetic */ PreviewView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean getEnableZoomOnPinch() {
        return this.enableZoomOnPinch;
    }

    public final void setEnableZoomOnPinch(boolean bl) {
        this.enableZoomOnPinch = bl;
    }

    public final boolean getEnableTapToFocus() {
        return this.enableTapToFocus;
    }

    public final void setEnableTapToFocus(boolean bl) {
        this.enableTapToFocus = bl;
    }

    @Nullable
    public final ICameraStreamer getStreamer() {
        return this.streamer;
    }

    public final void setStreamer(@Nullable ICameraStreamer value) {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            iCameraStreamer.stopPreview();
        }
        this.streamer = value;
        PreviewView.startPreviewIfReady$default(this, false, 1, null);
    }

    @Nullable
    public final Listener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean notALongPress;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.streamer == null) {
            return super.onTouchEvent(event);
        }
        if (this.enableZoomOnPinch) {
            this.pinchGesture.onTouchEvent(event);
        }
        boolean isSingleTouch = event.getPointerCount() == 1;
        boolean isUpEvent = event.getAction() == 1;
        boolean bl = notALongPress = event.getEventTime() - event.getDownTime() < (long)ViewConfiguration.getLongPressTimeout();
        if (isSingleTouch && isUpEvent && notALongPress) {
            this.touchUpEvent = event;
            this.performClick();
            return true;
        }
        return true;
    }

    public boolean performClick() {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            ICameraStreamer it = iCameraStreamer;
            boolean bl = false;
            if (this.enableTapToFocus) {
                MotionEvent motionEvent = this.touchUpEvent;
                float x = motionEvent != null ? motionEvent.getX() : (float)this.getWidth() / 2.0f;
                MotionEvent motionEvent2 = this.touchUpEvent;
                float y = motionEvent2 != null ? motionEvent2.getY() : (float)this.getHeight() / 2.0f;
                it.getSettings().getCamera().getFocusMetering().onTap(new PointF(x, y), new Rect((int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight()), OrientationUtils.INSTANCE.getSurfaceOrientationDegrees(this.getDisplay().getRotation()));
            }
        }
        this.touchUpEvent = null;
        return super.performClick();
    }

    private final void startPreviewIfReady(boolean shouldFailSilently) {
        block5: {
            if (this.getDisplay() == null) break block5;
            ICameraStreamer iCameraStreamer = this.streamer;
            if (iCameraStreamer != null) {
                ICameraStreamer it = iCameraStreamer;
                boolean bl = false;
                try {
                    String string2 = this.defaultCameraId;
                    if (string2 == null) {
                        string2 = it.getCamera();
                    }
                    String camera = string2;
                    ILogger.DefaultImpls.i$default(Logger.INSTANCE, TAG, "Starting on camera: " + camera, null, 4, null);
                    Display display = this.getDisplay();
                    Intrinsics.checkNotNullExpressionValue((Object)display, (String)"getDisplay(...)");
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    Size previewSize = CameraSizesKt.getPreviewOutputSize$default(display, ContextExtensionsForCameraKt.getCameraCharacteristics(context, camera), SurfaceHolder.class, null, 8, null);
                    ILogger.DefaultImpls.d$default(Logger.INSTANCE, TAG, "View finder size: " + this.getWidth() + " x " + this.getHeight(), null, 4, null);
                    ILogger.DefaultImpls.d$default(Logger.INSTANCE, TAG, "Selected preview size: " + previewSize, null, 4, null);
                    this.surfaceView.setAspectRatio(previewSize.getWidth(), previewSize.getHeight());
                    Boolean bl2 = this.post(() -> PreviewView.startPreviewIfReady$lambda$2$lambda$1(this, it, camera));
                }
                catch (Exception e) {
                    if (!shouldFailSilently) {
                        throw e;
                    }
                    Logger.INSTANCE.w(TAG, e.toString(), e);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    static /* synthetic */ void startPreviewIfReady$default(PreviewView previewView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        previewView.startPreviewIfReady(bl);
    }

    @JvmOverloads
    public PreviewView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PreviewView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void startPreviewIfReady$lambda$2$lambda$1(PreviewView this$0, ICameraStreamer $it, String $camera) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            Intrinsics.checkNotNullParameter((Object)$camera, (String)"$camera");
            if (ActivityCompat.checkSelfPermission((Context)this$0.getContext(), (String)"android.permission.CAMERA") != 0) {
                throw new SecurityException("Camera permission is needed to run this application");
            }
            $it.startPreview(this$0.surfaceView, $camera);
            Listener listener = this$0.listener;
            if (listener == null) break block1;
            listener.onPreviewStarted();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$Companion;", "", "()V", "DEFAULT_CAMERA_FACING", "Lio/github/thibaultbee/streampack/views/FacingDirection;", "TAG", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$Listener;", "", "onPreviewStarted", "", "onZoomRationOnPinchChanged", "zoomRatio", "", "core_release"})
    public static interface Listener {
        public void onPreviewStarted();

        public void onZoomRationOnPinchChanged(float var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onPreviewStarted(@NotNull Listener $this) {
            }

            public static void onZoomRationOnPinchChanged(@NotNull Listener $this, float zoomRatio) {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$PinchToZoomOnScaleGestureListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lio/github/thibaultbee/streampack/views/PreviewView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "core_release"})
    private final class PinchToZoomOnScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                Object object = PreviewView.this.getStreamer();
                if (object == null || (object = object.getSettings()) == null || (object = object.getCamera()) == null || (object = ((CameraSettings)object).getZoom()) == null) break block1;
                Object object2 = object;
                PreviewView previewView = PreviewView.this;
                Object it = object2;
                boolean bl = false;
                ((Zoom)it).onPinch(detector.getScaleFactor());
                Listener listener = previewView.getListener();
                if (listener != null) {
                    listener.onZoomRationOnPinchChanged(((Zoom)it).getZoomRatio());
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/views/PreviewView$StreamerHolderCallback;", "Landroid/view/SurfaceHolder$Callback;", "(Lio/github/thibaultbee/streampack/views/PreviewView;)V", "surfaceChanged", "", "holder", "Landroid/view/SurfaceHolder;", "format", "", "width", "height", "surfaceCreated", "surfaceDestroyed", "core_release"})
    private final class StreamerHolderCallback
    implements SurfaceHolder.Callback {
        public void surfaceCreated(@NotNull SurfaceHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            PreviewView.startPreviewIfReady$default(PreviewView.this, false, 1, null);
        }

        public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        }

        public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                ICameraStreamer iCameraStreamer = PreviewView.this.getStreamer();
                if (iCameraStreamer == null) break block0;
                iCameraStreamer.stopPreview();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FacingDirection.values().length];
            try {
                nArray[FacingDirection.FRONT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FacingDirection.BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

