/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.bases;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.encoders.AudioMediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import io.github.thibaultbee.streampack.internal.encoders.VideoMediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import io.github.thibaultbee.streampack.internal.events.EventHandler;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.sources.IAudioSource;
import io.github.thibaultbee.streampack.internal.sources.IVideoSource;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import io.github.thibaultbee.streampack.streamers.helpers.StreamerConfigurationHelper;
import io.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import io.github.thibaultbee.streampack.streamers.settings.BaseStreamerSettings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009b\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t*\u0003\u0019-K\b&\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0001\\B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010P\u001a\u00020Q2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010P\u001a\u00020Q2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?H\u0017J\u0010\u0010P\u001a\u00020Q2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u00020QH\u0016J\b\u0010V\u001a\u00020QH\u0002J\b\u0010W\u001a\u00020QH\u0002J\u000e\u0010X\u001a\u00020QH\u0096@\u00a2\u0006\u0002\u0010YJ\u000e\u0010Z\u001a\u00020QH\u0096@\u00a2\u0006\u0002\u0010YJ\u000e\u0010[\u001a\u00020QH\u0082@\u00a2\u0006\u0002\u0010YR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0010\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00101R\u0014\u00106\u001a\u000207X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0016\u0010:\u001a\u0004\u0018\u00010;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001c\u0010D\u001a\u0004\u0018\u00010EX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0010\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010LR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0012\u0010O\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001f\u00a8\u0006]"}, d2={"Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lio/github/thibaultbee/streampack/internal/events/EventHandler;", "Lio/github/thibaultbee/streampack/streamers/interfaces/IStreamer;", "context", "Landroid/content/Context;", "audioSource", "Lio/github/thibaultbee/streampack/internal/sources/IAudioSource;", "videoSource", "Lio/github/thibaultbee/streampack/internal/sources/IVideoSource;", "muxer", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "endpoint", "Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "initialOnErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/IAudioSource;Lio/github/thibaultbee/streampack/internal/sources/IVideoSource;Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "audioConfig", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "audioEncoder", "Lio/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "getAudioEncoder", "()Lio/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "setAudioEncoder", "(Lio/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;)V", "audioEncoderListener", "io/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1;", "getAudioSource", "()Lio/github/thibaultbee/streampack/internal/sources/IAudioSource;", "audioStreamId", "", "Ljava/lang/Integer;", "getEndpoint", "()Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "hasAudio", "", "getHasAudio", "()Z", "hasVideo", "getHasVideo", "helper", "Lio/github/thibaultbee/streampack/streamers/helpers/StreamerConfigurationHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/streamers/helpers/StreamerConfigurationHelper;", "muxListener", "io/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1;", "onErrorListener", "getOnErrorListener", "()Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "onInternalErrorListener", "getOnInternalErrorListener", "settings", "Lio/github/thibaultbee/streampack/streamers/settings/BaseStreamerSettings;", "getSettings", "()Lio/github/thibaultbee/streampack/streamers/settings/BaseStreamerSettings;", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "getSourceOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "videoConfig", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "getVideoConfig", "()Lio/github/thibaultbee/streampack/data/VideoConfig;", "setVideoConfig", "(Lio/github/thibaultbee/streampack/data/VideoConfig;)V", "videoEncoder", "Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "getVideoEncoder", "()Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "setVideoEncoder", "(Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;)V", "videoEncoderListener", "io/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1;", "getVideoSource", "()Lio/github/thibaultbee/streampack/internal/sources/IVideoSource;", "videoStreamId", "configure", "", "onStreamError", "error", "Lio/github/thibaultbee/streampack/error/StreamPackError;", "release", "resetAudio", "resetVideo", "startStream", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopStream", "stopStreamImpl", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nBaseStreamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseStreamer.kt\nio/github/thibaultbee/streampack/streamers/bases/BaseStreamer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
public abstract class BaseStreamer
extends EventHandler
implements IStreamer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final IAudioSource audioSource;
    @Nullable
    private final IVideoSource videoSource;
    @NotNull
    private final IMuxer muxer;
    @NotNull
    private final IEndpoint endpoint;
    @Nullable
    private OnErrorListener onErrorListener;
    @NotNull
    private final StreamerConfigurationHelper helper;
    @Nullable
    private Integer audioStreamId;
    @Nullable
    private Integer videoStreamId;
    @Nullable
    private VideoConfig videoConfig;
    @Nullable
    private AudioConfig audioConfig;
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    @NotNull
    private final audioEncoderListener.1 audioEncoderListener;
    @NotNull
    private final videoEncoderListener.1 videoEncoderListener;
    @NotNull
    private final muxListener.1 muxListener;
    @Nullable
    private AudioMediaCodecEncoder audioEncoder;
    @Nullable
    private VideoMediaCodecEncoder videoEncoder;
    @NotNull
    private final BaseStreamerSettings settings;
    @NotNull
    private static final String TAG = "BaseStreamer";

    public BaseStreamer(@NotNull Context context, @Nullable IAudioSource audioSource, @Nullable IVideoSource videoSource, @NotNull IMuxer muxer, @NotNull IEndpoint endpoint, @Nullable OnErrorListener initialOnErrorListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)muxer, (String)"muxer");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.context = context;
        this.audioSource = audioSource;
        this.videoSource = videoSource;
        this.muxer = muxer;
        this.endpoint = endpoint;
        this.onErrorListener = initialOnErrorListener;
        this.helper = new StreamerConfigurationHelper(this.muxer.getHelper());
        this.onInternalErrorListener = new OnErrorListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull StreamPackError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                BaseStreamer.access$onStreamError(this.this$0, error);
            }
        };
        this.audioEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                IAudioSource iAudioSource = this.this$0.getAudioSource();
                Intrinsics.checkNotNull((Object)iAudioSource);
                return iAudioSource.getFrame(buffer);
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Integer n = BaseStreamer.access$getAudioStreamId$p(this.this$0);
                if (n != null) {
                    Integer n2 = n;
                    BaseStreamer baseStreamer = this.this$0;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    try {
                        BaseStreamer.access$getMuxer$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.videoEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                IVideoSource iVideoSource = this.this$0.getVideoSource();
                Intrinsics.checkNotNull((Object)iVideoSource);
                return iVideoSource.getFrame(buffer);
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Integer n = BaseStreamer.access$getVideoStreamId$p(this.this$0);
                if (n != null) {
                    Integer n2 = n;
                    BaseStreamer baseStreamer = this.this$0;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    try {
                        Long l;
                        long l2 = frame.getPts();
                        IVideoSource iVideoSource = baseStreamer.getVideoSource();
                        Intrinsics.checkNotNull((Object)iVideoSource);
                        frame.setPts(l2 + iVideoSource.getTimestampOffset());
                        if (frame.getDts() != null) {
                            Long l3 = frame.getDts();
                            Intrinsics.checkNotNull((Object)l3);
                            l = l3 + baseStreamer.getVideoSource().getTimestampOffset();
                        } else {
                            l = null;
                        }
                        frame.setDts(l);
                        BaseStreamer.access$getMuxer$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.muxListener = new IMuxerListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOutputFrame(@NotNull Packet packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                try {
                    this.this$0.getEndpoint().write(packet);
                }
                catch (Exception e) {
                    throw new StreamPackError(e);
                }
            }
        };
        this.audioEncoder = this.audioSource != null ? new AudioMediaCodecEncoder(this.audioEncoderListener, this.onInternalErrorListener) : null;
        this.videoEncoder = this.videoSource != null ? new VideoMediaCodecEncoder(this.videoEncoderListener, this.onInternalErrorListener, this.videoSource.getHasSurface(), this.getSourceOrientationProvider()) : null;
        this.settings = new BaseStreamerSettings(this.audioSource, this.audioEncoder, this.videoEncoder);
        this.muxer.setSourceOrientationProvider(this.getSourceOrientationProvider());
        this.muxer.setListener(this.muxListener);
    }

    public /* synthetic */ BaseStreamer(Context context, IAudioSource iAudioSource, IVideoSource iVideoSource, IMuxer iMuxer, IEndpoint iEndpoint, OnErrorListener onErrorListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            onErrorListener = null;
        }
        this(context, iAudioSource, iVideoSource, iMuxer, iEndpoint, onErrorListener);
    }

    @Nullable
    protected final IAudioSource getAudioSource() {
        return this.audioSource;
    }

    @Nullable
    protected final IVideoSource getVideoSource() {
        return this.videoSource;
    }

    @NotNull
    protected final IEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    @Override
    public void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Override
    @NotNull
    public StreamerConfigurationHelper getHelper() {
        return this.helper;
    }

    @Nullable
    protected final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    protected final void setVideoConfig(@Nullable VideoConfig videoConfig) {
        this.videoConfig = videoConfig;
    }

    private final ISourceOrientationProvider getSourceOrientationProvider() {
        IVideoSource iVideoSource = this.videoSource;
        return iVideoSource != null ? iVideoSource.getOrientationProvider() : null;
    }

    @Override
    @NotNull
    protected final OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onStreamError(StreamPackError error) {
        try {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ BaseStreamer this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.stopStream((Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, TAG, "onStreamError: Can't stop stream", null, 4, null);
        }
        finally {
            OnErrorListener onErrorListener = this.getOnErrorListener();
            if (onErrorListener != null) {
                onErrorListener.onError(error);
            }
        }
    }

    @Nullable
    protected final AudioMediaCodecEncoder getAudioEncoder() {
        return this.audioEncoder;
    }

    protected final void setAudioEncoder(@Nullable AudioMediaCodecEncoder audioMediaCodecEncoder) {
        this.audioEncoder = audioMediaCodecEncoder;
    }

    @Nullable
    protected final VideoMediaCodecEncoder getVideoEncoder() {
        return this.videoEncoder;
    }

    protected final void setVideoEncoder(@Nullable VideoMediaCodecEncoder videoMediaCodecEncoder) {
        this.videoEncoder = videoMediaCodecEncoder;
    }

    @Override
    @NotNull
    public BaseStreamerSettings getSettings() {
        return this.settings;
    }

    private final boolean getHasAudio() {
        return this.audioSource != null;
    }

    private final boolean getHasVideo() {
        return this.videoSource != null;
    }

    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        if (!this.getHasAudio()) {
            boolean bl = false;
            String string2 = "Do not need to set audio as it is a video only streamer";
            throw new IllegalArgumentException(string2.toString());
        }
        this.audioConfig = audioConfig;
        try {
            IAudioSource iAudioSource = this.audioSource;
            if (iAudioSource != null) {
                iAudioSource.configure(audioConfig);
            }
            AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
            if (audioMediaCodecEncoder != null) {
                audioMediaCodecEncoder.release();
            }
            AudioMediaCodecEncoder audioMediaCodecEncoder2 = this.audioEncoder;
            if (audioMediaCodecEncoder2 != null) {
                audioMediaCodecEncoder2.configure(audioConfig);
            }
            VideoConfig videoConfig = this.videoConfig;
            this.endpoint.configure((videoConfig != null ? videoConfig.getStartBitrate() : 0) + audioConfig.getStartBitrate());
        }
        catch (Exception e) {
            this.release();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void configure(@NotNull VideoConfig videoConfig) {
        Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
        if (!this.getHasVideo()) {
            boolean bl = false;
            String string2 = "Do not need to set video as it is a audio only streamer";
            throw new IllegalArgumentException(string2.toString());
        }
        this.videoConfig = videoConfig;
        try {
            IVideoSource iVideoSource = this.videoSource;
            if (iVideoSource != null) {
                iVideoSource.configure(videoConfig);
            }
            VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
            if (videoMediaCodecEncoder != null) {
                videoMediaCodecEncoder.release();
            }
            VideoMediaCodecEncoder videoMediaCodecEncoder2 = this.videoEncoder;
            if (videoMediaCodecEncoder2 != null) {
                videoMediaCodecEncoder2.configure(videoConfig);
            }
            AudioConfig audioConfig = this.audioConfig;
            this.endpoint.configure(videoConfig.getStartBitrate() + (audioConfig != null ? audioConfig.getStartBitrate() : 0));
        }
        catch (Exception e) {
            this.release();
            throw new StreamPackError(e);
        }
    }

    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@NotNull AudioConfig audioConfig, @NotNull VideoConfig videoConfig) {
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
        this.configure(audioConfig);
        this.configure(videoConfig);
    }

    @Override
    @Nullable
    public Object startStream(@NotNull Continuation<? super Unit> $completion) {
        return BaseStreamer.startStream$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object startStream$suspendImpl(BaseStreamer var0, Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof startStream.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseStreamer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseStreamer.startStream$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = $this.endpoint.startStream((Continuation<? super Unit>)$continuation);
                ** if (v0 != var8_4) goto lbl19
lbl18:
                // 1 sources

                return var8_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                $this = (BaseStreamer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    streams = new ArrayList<E>();
                    if ($this.getHasVideo()) {
                        if (!($this.videoConfig != null)) {
                            $i$a$-require-BaseStreamer$startStream$2 = false;
                            $i$a$-require-BaseStreamer$startStream$2 = "Requires video config";
                            throw new IllegalArgumentException($i$a$-require-BaseStreamer$startStream$2.toString());
                        }
                        v1 = $this.videoConfig;
                        Intrinsics.checkNotNull((Object)v1);
                        streams.add(v1);
                    }
                    if ($this.getHasAudio()) {
                        if (!($this.audioConfig != null)) {
                            $i$a$-require-BaseStreamer$startStream$3 = false;
                            var4_11 = "Requires audio config";
                            throw new IllegalArgumentException(var4_11.toString());
                        }
                        v2 = $this.audioConfig;
                        Intrinsics.checkNotNull((Object)v2);
                        streams.add(v2);
                    }
                    streamsIdMap = $this.muxer.addStreams(streams);
                    if ($this.videoConfig != null) {
                        $i$a$-let-BaseStreamer$startStream$4 = false;
                        v3 = $this.videoConfig;
                        Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.Config");
                        $this.videoStreamId = streamsIdMap.get(v3);
                    }
                    if ($this.audioConfig != null) {
                        $i$a$-let-BaseStreamer$startStream$5 = false;
                        v4 = $this.audioConfig;
                        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.Config");
                        $this.audioStreamId = streamsIdMap.get(v4);
                    }
                    $this.muxer.startStream();
                    v5 = $this.audioSource;
                    if (v5 != null) {
                        v5.startStream();
                    }
                    v6 = $this.audioEncoder;
                    if (v6 != null) {
                        v6.startStream();
                    }
                    v7 = $this.videoSource;
                    if (v7 != null) {
                        v7.startStream();
                    }
                    v8 = $this.videoEncoder;
                    if (v8 != null) {
                        v8.startStream();
                    }
                    break;
                }
                catch (Exception e) {
                    $continuation.L$0 = e;
                    $continuation.label = 2;
                    v9 = $this.stopStream((Continuation<? super Unit>)$continuation);
                    if (v9 == var8_4) {
                        return var8_4;
                    }
                    ** GOTO lbl84
                }
            }
            case 2: {
                e = (Exception)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl84:
                // 2 sources

                throw new StreamPackError(e);
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object stopStream(@NotNull Continuation<? super Unit> $completion) {
        return BaseStreamer.stopStream$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object stopStream$suspendImpl(BaseStreamer var0, Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof stopStream.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseStreamer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseStreamer.stopStream$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = $this.stopStreamImpl((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this = (BaseStreamer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $this.resetAudio();
                $this.resetVideo();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object stopStreamImpl(Continuation<? super Unit> $completion) {
        IVideoSource iVideoSource = this.videoSource;
        if (iVideoSource != null) {
            iVideoSource.stopStream();
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.stopStream();
        }
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.stopStream();
        }
        IAudioSource iAudioSource = this.audioSource;
        if (iAudioSource != null) {
            iAudioSource.stopStream();
        }
        this.muxer.stopStream();
        Object object = this.endpoint.stopStream($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void resetAudio() {
        block2: {
            AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
            if (audioMediaCodecEncoder != null) {
                audioMediaCodecEncoder.release();
            }
            AudioConfig audioConfig = this.audioConfig;
            if (audioConfig == null) break block2;
            AudioConfig it = audioConfig;
            boolean bl = false;
            AudioMediaCodecEncoder audioMediaCodecEncoder2 = this.audioEncoder;
            if (audioMediaCodecEncoder2 != null) {
                audioMediaCodecEncoder2.configure(it);
            }
        }
    }

    private final void resetVideo() {
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.release();
        }
        VideoConfig videoConfig = this.videoConfig;
        if (videoConfig != null) {
            VideoConfig it = videoConfig;
            boolean bl = false;
            VideoMediaCodecEncoder videoMediaCodecEncoder2 = this.videoEncoder;
            if (videoMediaCodecEncoder2 != null) {
                videoMediaCodecEncoder2.configure(it);
            }
        }
        IVideoSource iVideoSource = this.videoSource;
        if (iVideoSource != null) {
            VideoMediaCodecEncoder videoMediaCodecEncoder3 = this.videoEncoder;
            iVideoSource.setEncoderSurface((Surface)(videoMediaCodecEncoder3 != null ? videoMediaCodecEncoder3.getInputSurface() : null));
        }
    }

    @Override
    public void release() {
        Object object;
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.release();
        }
        if ((object = this.videoEncoder) != null && (object = ((VideoMediaCodecEncoder)object).getCodecSurface()) != null) {
            ((VideoMediaCodecEncoder.CodecSurface)object).release();
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.release();
        }
        IAudioSource iAudioSource = this.audioSource;
        if (iAudioSource != null) {
            iAudioSource.release();
        }
        IVideoSource iVideoSource = this.videoSource;
        if (iVideoSource != null) {
            iVideoSource.release();
        }
        this.muxer.release();
        this.endpoint.release();
    }

    public static final /* synthetic */ Object access$stopStreamImpl(BaseStreamer $this, Continuation $completion) {
        return $this.stopStreamImpl((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$onStreamError(BaseStreamer $this, StreamPackError error) {
        $this.onStreamError(error);
    }

    public static final /* synthetic */ Integer access$getAudioStreamId$p(BaseStreamer $this) {
        return $this.audioStreamId;
    }

    public static final /* synthetic */ IMuxer access$getMuxer$p(BaseStreamer $this) {
        return $this.muxer;
    }

    public static final /* synthetic */ Integer access$getVideoStreamId$p(BaseStreamer $this) {
        return $this.videoStreamId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Companion;", "", "()V", "TAG", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

