/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.video;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/DynamicRangeProfile;", "", "dynamicRange", "", "transferFunction", "", "(JI)V", "getDynamicRange", "()J", "isHdr", "", "()Z", "getTransferFunction", "()I", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "core_release"})
public final class DynamicRangeProfile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long dynamicRange;
    private final int transferFunction;
    @NotNull
    private static final DynamicRangeProfile sdr = new DynamicRangeProfile(1L, 3);
    @NotNull
    private static final DynamicRangeProfile hdr = new DynamicRangeProfile(2L, 7);
    @NotNull
    private static final DynamicRangeProfile hdr10 = new DynamicRangeProfile(4L, 6);
    @NotNull
    private static final DynamicRangeProfile hdr10Plus = new DynamicRangeProfile(8L, 6);
    @NotNull
    private static final Map<Integer, DynamicRangeProfile> avcProfilesMap;
    @NotNull
    private static final Map<Integer, DynamicRangeProfile> hevcProfilesMap;
    @NotNull
    private static final Map<Integer, DynamicRangeProfile> vp9ProfilesMap;
    @NotNull
    private static final Map<Integer, DynamicRangeProfile> av1ProfilesMap;

    public DynamicRangeProfile(long dynamicRange, int transferFunction) {
        this.dynamicRange = dynamicRange;
        this.transferFunction = transferFunction;
    }

    public final long getDynamicRange() {
        return this.dynamicRange;
    }

    public final int getTransferFunction() {
        return this.transferFunction;
    }

    public final boolean isHdr() {
        return this.dynamicRange != 1L;
    }

    public final long component1() {
        return this.dynamicRange;
    }

    public final int component2() {
        return this.transferFunction;
    }

    @NotNull
    public final DynamicRangeProfile copy(long dynamicRange, int transferFunction) {
        return new DynamicRangeProfile(dynamicRange, transferFunction);
    }

    public static /* synthetic */ DynamicRangeProfile copy$default(DynamicRangeProfile dynamicRangeProfile, long l, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = dynamicRangeProfile.dynamicRange;
        }
        if ((n2 & 2) != 0) {
            n = dynamicRangeProfile.transferFunction;
        }
        return dynamicRangeProfile.copy(l, n);
    }

    @NotNull
    public String toString() {
        return "DynamicRangeProfile(dynamicRange=" + this.dynamicRange + ", transferFunction=" + this.transferFunction + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.dynamicRange);
        result = result * 31 + Integer.hashCode(this.transferFunction);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DynamicRangeProfile)) {
            return false;
        }
        DynamicRangeProfile dynamicRangeProfile = (DynamicRangeProfile)other;
        if (this.dynamicRange != dynamicRangeProfile.dynamicRange) {
            return false;
        }
        return this.transferFunction == dynamicRangeProfile.transferFunction;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)sdr), TuplesKt.to((Object)65536, (Object)sdr), TuplesKt.to((Object)524288, (Object)sdr), TuplesKt.to((Object)4, (Object)sdr), TuplesKt.to((Object)8, (Object)sdr), TuplesKt.to((Object)16, (Object)hdr), TuplesKt.to((Object)32, (Object)sdr), TuplesKt.to((Object)64, (Object)sdr), TuplesKt.to((Object)2, (Object)sdr)};
        avcProfilesMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)sdr), TuplesKt.to((Object)2, (Object)hdr), TuplesKt.to((Object)4096, (Object)hdr10), TuplesKt.to((Object)8192, (Object)hdr10Plus)};
        hevcProfilesMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)sdr), TuplesKt.to((Object)2, (Object)hdr), TuplesKt.to((Object)4, (Object)hdr), TuplesKt.to((Object)4096, (Object)hdr), TuplesKt.to((Object)16384, (Object)hdr10Plus), TuplesKt.to((Object)8, (Object)hdr), TuplesKt.to((Object)8192, (Object)hdr10), TuplesKt.to((Object)32768, (Object)hdr10Plus)};
        vp9ProfilesMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)sdr), TuplesKt.to((Object)2, (Object)hdr), TuplesKt.to((Object)4096, (Object)hdr10), TuplesKt.to((Object)8192, (Object)hdr10Plus)};
        av1ProfilesMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/DynamicRangeProfile$Companion;", "", "()V", "av1ProfilesMap", "", "", "Lio/github/thibaultbee/streampack/internal/utils/av/video/DynamicRangeProfile;", "avcProfilesMap", "hdr", "getHdr", "()Lio/github/thibaultbee/streampack/internal/utils/av/video/DynamicRangeProfile;", "hdr10", "getHdr10", "hdr10Plus", "getHdr10Plus", "hevcProfilesMap", "sdr", "getSdr", "vp9ProfilesMap", "fromProfile", "mimetype", "", "profile", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DynamicRangeProfile getSdr() {
            return sdr;
        }

        @NotNull
        public final DynamicRangeProfile getHdr() {
            return hdr;
        }

        @NotNull
        public final DynamicRangeProfile getHdr10() {
            return hdr10;
        }

        @NotNull
        public final DynamicRangeProfile getHdr10Plus() {
            return hdr10Plus;
        }

        @NotNull
        public final DynamicRangeProfile fromProfile(@NotNull String mimetype, int profile) {
            DynamicRangeProfile dynamicRangeProfile;
            Intrinsics.checkNotNullParameter((Object)mimetype, (String)"mimetype");
            switch (mimetype) {
                case "video/avc": {
                    dynamicRangeProfile = (DynamicRangeProfile)avcProfilesMap.get(profile);
                    break;
                }
                case "video/hevc": {
                    dynamicRangeProfile = (DynamicRangeProfile)hevcProfilesMap.get(profile);
                    break;
                }
                case "video/x-vnd.on2.vp9": {
                    dynamicRangeProfile = (DynamicRangeProfile)vp9ProfilesMap.get(profile);
                    break;
                }
                case "video/av01": {
                    dynamicRangeProfile = (DynamicRangeProfile)av1ProfilesMap.get(profile);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mimetype " + mimetype);
                }
            }
            if (dynamicRangeProfile == null) {
                throw new IllegalArgumentException("Profile " + profile + " is not supported for " + mimetype);
            }
            return dynamicRangeProfile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

