/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.aac;

import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.AudioMuxElement;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/LATMFrameWriter;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "audioMuxElement", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement;", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/AudioMuxElement;)V", "size", "", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "Companion", "core_release"})
public final class LATMFrameWriter
extends ByteBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioMuxElement audioMuxElement;
    private final int size;

    public LATMFrameWriter(@NotNull AudioMuxElement audioMuxElement) {
        Intrinsics.checkNotNullParameter((Object)audioMuxElement, (String)"audioMuxElement");
        this.audioMuxElement = audioMuxElement;
        this.size = 3 + this.audioMuxElement.getSize();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int audioMuxLengthBytes = this.audioMuxElement.getSize();
        output.put((byte)86);
        ByteBufferExtensionsKt.put(output, 0xE0 | audioMuxLengthBytes >> 8 & 0x1F);
        ByteBufferExtensionsKt.put(output, audioMuxLengthBytes & 0xFF);
        this.audioMuxElement.write(output);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/LATMFrameWriter$Companion;", "", "()V", "fromDecoderSpecificInfo", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/LATMFrameWriter;", "frameBuffer", "Ljava/nio/ByteBuffer;", "decoderSpecificInfo", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LATMFrameWriter fromDecoderSpecificInfo(@NotNull ByteBuffer frameBuffer, @NotNull ByteBuffer decoderSpecificInfo) {
            Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
            Intrinsics.checkNotNullParameter((Object)decoderSpecificInfo, (String)"decoderSpecificInfo");
            return new LATMFrameWriter(AudioMuxElement.Companion.fromDecoderSpecificInfo(frameBuffer, decoderSpecificInfo));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

