/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags.video;

import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.TagType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.AVCPacketType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.CodecID;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.FrameType;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/VideoTag;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag;", "pts", "", "buffer", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "isKeyFrame", "", "packetType", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/AVCPacketType;", "mimeType", "", "(JLio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;ZLio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/AVCPacketType;Ljava/lang/String;)V", "bodySize", "", "getBodySize", "()I", "codecID", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/CodecID;", "tagHeaderSize", "getTagHeaderSize", "computeBodySize", "computeHeaderSize", "writeBody", "", "output", "Ljava/nio/ByteBuffer;", "writeTagHeader", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nVideoTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoTag.kt\nio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/VideoTag\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class VideoTag
extends FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufferWriter buffer;
    private final boolean isKeyFrame;
    @Nullable
    private final AVCPacketType packetType;
    @NotNull
    private final String mimeType;
    @NotNull
    private final CodecID codecID;
    private final int tagHeaderSize;
    private final int bodySize;
    private static final int VIDEO_TAG_HEADER_SIZE = 1;

    public VideoTag(long pts, @NotNull ByteBufferWriter buffer, boolean isKeyFrame, @Nullable AVCPacketType packetType, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        super(pts, TagType.VIDEO, false, 4, null);
        this.buffer = buffer;
        this.isKeyFrame = isKeyFrame;
        this.packetType = packetType;
        this.mimeType = mimeType;
        this.codecID = CodecID.Companion.fromMimeType(this.mimeType);
        if (!Companion.isSupportedCodec(this.mimeType)) {
            boolean $i$a$-require-VideoTag$22 = false;
            String $i$a$-require-VideoTag$22 = "Only H263 and H264 are supported";
            throw new IllegalArgumentException($i$a$-require-VideoTag$22.toString());
        }
        if (Intrinsics.areEqual((Object)this.mimeType, (Object)"video/avc")) {
            if (this.packetType == null) {
                boolean bl = false;
                String string2 = "AVC packet type is required for H264";
                throw new IllegalArgumentException(string2.toString());
            }
        }
        this.tagHeaderSize = this.computeHeaderSize();
        this.bodySize = this.computeBodySize();
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        FrameType frameType = this.isKeyFrame ? FrameType.KEY : FrameType.INTER;
        ByteBufferExtensionsKt.put(output, frameType.getValue() << 4 | this.codecID.getValue());
        if (Intrinsics.areEqual((Object)this.mimeType, (Object)"video/avc")) {
            AVCPacketType aVCPacketType = this.packetType;
            Intrinsics.checkNotNull((Object)((Object)aVCPacketType));
            ByteBufferExtensionsKt.put(output, aVCPacketType.getValue());
            ByteBufferExtensionsKt.putInt24(output, 0);
        }
    }

    @Override
    protected int getTagHeaderSize() {
        return this.tagHeaderSize;
    }

    private final int computeHeaderSize() {
        int size2 = 1;
        if (Intrinsics.areEqual((Object)this.mimeType, (Object)"video/avc")) {
            size2 += 4;
        }
        return size2;
    }

    @Override
    protected void writeBody(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        AVCPacketType aVCPacketType = this.packetType;
        if ((aVCPacketType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[aVCPacketType.ordinal()]) != 1) {
            this.buffer.write(output);
        }
    }

    @Override
    protected int getBodySize() {
        return this.bodySize;
    }

    private final int computeBodySize() {
        AVCPacketType aVCPacketType = this.packetType;
        return (aVCPacketType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[aVCPacketType.ordinal()]) == 1 ? 0 : this.buffer.getSize();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/video/VideoTag$Companion;", "", "()V", "VIDEO_TAG_HEADER_SIZE", "", "isSupportedCodec", "", "mimeType", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupportedCodec(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return Intrinsics.areEqual((Object)mimeType, (Object)"video/avc") || Intrinsics.areEqual((Object)mimeType, (Object)"video/3gpp");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AVCPacketType.values().length];
            try {
                nArray[AVCPacketType.END_OF_SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

