/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts.data;

import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "", "config", "Lio/github/thibaultbee/streampack/data/Config;", "pid", "", "discontinuity", "", "(Lio/github/thibaultbee/streampack/data/Config;SZ)V", "getConfig", "()Lio/github/thibaultbee/streampack/data/Config;", "getDiscontinuity", "()Z", "isAudio", "isVideo", "getPid", "()S", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "core_release"})
public final class Stream {
    @NotNull
    private final Config config;
    private final short pid;
    private final boolean discontinuity;
    private final boolean isVideo;
    private final boolean isAudio;

    public Stream(@NotNull Config config, short pid, boolean discontinuity) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.pid = pid;
        this.discontinuity = discontinuity;
        this.isVideo = StringExtensionsKt.isVideo(this.config.getMimeType());
        this.isAudio = StringExtensionsKt.isAudio(this.config.getMimeType());
    }

    public /* synthetic */ Stream(Config config, short s, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(config, s, bl);
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public final short getPid() {
        return this.pid;
    }

    public final boolean getDiscontinuity() {
        return this.discontinuity;
    }

    public final boolean isVideo() {
        return this.isVideo;
    }

    public final boolean isAudio() {
        return this.isAudio;
    }

    @NotNull
    public final Config component1() {
        return this.config;
    }

    public final short component2() {
        return this.pid;
    }

    public final boolean component3() {
        return this.discontinuity;
    }

    @NotNull
    public final Stream copy(@NotNull Config config, short pid, boolean discontinuity) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new Stream(config, pid, discontinuity);
    }

    public static /* synthetic */ Stream copy$default(Stream stream, Config config, short s, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            config = stream.config;
        }
        if ((n & 2) != 0) {
            s = stream.pid;
        }
        if ((n & 4) != 0) {
            bl = stream.discontinuity;
        }
        return stream.copy(config, s, bl);
    }

    @NotNull
    public String toString() {
        return "Stream(config=" + this.config + ", pid=" + this.pid + ", discontinuity=" + this.discontinuity + ')';
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = result * 31 + Short.hashCode(this.pid);
        int n = this.discontinuity ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Stream)) {
            return false;
        }
        Stream stream = (Stream)other;
        if (!Intrinsics.areEqual((Object)this.config, (Object)stream.config)) {
            return false;
        }
        if (this.pid != stream.pid) {
            return false;
        }
        return this.discontinuity == stream.discontinuity;
    }
}

