/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Range;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\t\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\t\u001a\u00020\u0006J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\t\u001a\u00020\u0006J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u000eJ(\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper;", "", "()V", "codecList", "Landroid/media/MediaCodecList;", "findEncoder", "", "format", "Landroid/media/MediaFormat;", "mimeType", "getCodecCapabilities", "Landroid/media/MediaCodecInfo$CodecCapabilities;", "name", "getCodecInfo", "Landroid/media/MediaCodecInfo;", "getEncodersName", "", "filter", "Lkotlin/Function1;", "", "getEncodersType", "getMaxLevel", "", "profile", "getNamesForType", "getProfileLevel", "Landroid/media/MediaCodecInfo$CodecProfileLevel;", "getProfiles", "getTypesForName", "isFormatSupported", "isHardwareAccelerated", "codecInfo", "isSoftwareOnly", "secureMediaFormatAction", "action", "Audio", "Video", "core_release"})
public final class MediaCodecHelper {
    @NotNull
    public static final MediaCodecHelper INSTANCE = new MediaCodecHelper();
    @NotNull
    private static final MediaCodecList codecList = new MediaCodecList(0);

    private MediaCodecHelper() {
    }

    private final Object secureMediaFormatAction(MediaFormat format, Function1<? super MediaFormat, ? extends Object> action) {
        Integer n;
        try {
            n = format.getInteger("frame-rate");
        }
        catch (Exception e) {
            n = null;
        }
        Integer frameRate = n;
        if (Build.VERSION.SDK_INT == 21) {
            format.setString("frame-rate", null);
        }
        Object result = action.invoke((Object)format);
        if (Build.VERSION.SDK_INT == 21) {
            Integer n2 = frameRate;
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                format.setInteger("frame-rate", it);
            }
        }
        return result;
    }

    @NotNull
    public final String findEncoder(@NotNull MediaFormat format) {
        String encoderName2;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = encoderName2 = (String)this.secureMediaFormatAction(format, (Function1<? super MediaFormat, ? extends Object>)((Function1)new Function1<MediaFormat, Object>(format){
            final /* synthetic */ MediaFormat $format;
            {
                this.$format = $format;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull MediaFormat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MediaCodecHelper.access$getCodecList$p().findEncoderForFormat(this.$format);
            }
        }));
        if (string == null) {
            throw new InvalidParameterException(Intrinsics.stringPlus((String)"Failed to create codec for: ", (Object)format));
        }
        return string;
    }

    @NotNull
    public final String findEncoder(@NotNull String mimeType) {
        MediaFormat mediaFormat;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        MediaFormat $this$findEncoder_u24lambda_u2d1 = mediaFormat = new MediaFormat();
        boolean bl = false;
        $this$findEncoder_u24lambda_u2d1.setString("mime", mimeType);
        MediaFormat format = mediaFormat;
        return this.findEncoder(format);
    }

    private final List<String> getEncodersType(Function1<? super String, Boolean> filter) {
        Object it;
        Object $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List encoders = new ArrayList();
        MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"codecList.codecInfos");
        Object $this$filter$iv = mediaCodecInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo it2 = (MediaCodecInfo)element$iv$iv;
            boolean bl = false;
            if (!it2.isEncoder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            it = (MediaCodecInfo)t;
            boolean bl = false;
            String[] stringArray = it.getSupportedTypes();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"it.supportedTypes");
            Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (String)t;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!((Boolean)filter.invoke(it)).booleanValue()) continue;
            destination$iv$iv.add(t);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it3 = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
            encoders.add(it3);
        }
        return encoders;
    }

    private final List<String> getEncodersName(Function1<? super String, Boolean> filter) {
        Object $this$filterTo$iv$iv;
        List encoders = new ArrayList();
        MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"codecList.codecInfos");
        Object $this$filter$iv = mediaCodecInfoArray;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
            boolean bl3 = false;
            if (!it.isEncoder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block4: {
                element$iv$iv = iterator.next();
                MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
                boolean bl2 = false;
                String[] bl3 = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"it.supportedTypes");
                Object[] $this$any$iv = bl3;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String type = (String)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                    if (!((Boolean)filter.invoke((Object)type)).booleanValue()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            encoders.add(string);
        }
        return encoders;
    }

    @NotNull
    public final List<String> getNamesForType(@NotNull String mimeType) {
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        List encoders = new ArrayList();
        MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"codecList.codecInfos");
        Object $this$filter$iv = mediaCodecInfoArray;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
            boolean bl3 = false;
            if (!it.isEncoder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block4: {
                element$iv$iv = iterator.next();
                MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
                boolean bl2 = false;
                String[] bl3 = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"it.supportedTypes");
                Object[] $this$any$iv = bl3;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String type = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)type, (Object)mimeType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaCodecInfo it = (MediaCodecInfo)element$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            encoders.add(string);
        }
        return encoders;
    }

    @NotNull
    public final List<String> getTypesForName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = this.getCodecInfo(name).getSupportedTypes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCodecInfo(name).supportedTypes");
        return ArraysKt.toList((Object[])stringArray);
    }

    @NotNull
    public final MediaCodecInfo getCodecInfo(@NotNull String name) {
        Object element$iv2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            MediaCodecInfo[] mediaCodecInfoArray = codecList.getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"codecList.codecInfos");
            Object[] $this$first$iv = mediaCodecInfoArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MediaCodecInfo it = (MediaCodecInfo)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object object = element$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"codecList.codecInfos.first { it.name == name }");
        return (MediaCodecInfo)object;
    }

    public final boolean isHardwareAccelerated(@NotNull MediaCodecInfo codecInfo) {
        Intrinsics.checkNotNullParameter((Object)codecInfo, (String)"codecInfo");
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isHardwareAccelerated();
        }
        return !this.isSoftwareOnly(codecInfo);
    }

    public final boolean isSoftwareOnly(@NotNull MediaCodecInfo codecInfo) {
        Intrinsics.checkNotNullParameter((Object)codecInfo, (String)"codecInfo");
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isSoftwareOnly();
        }
        String string = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codecInfo.name");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String codecName = string2;
        return StringsKt.startsWith$default((String)codecName, (String)"arc.", (boolean)false, (int)2, null) ? false : StringsKt.startsWith$default((String)codecName, (String)"omx.google.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"omx.ffmpeg.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"omx.sec.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)codecName, (CharSequence)".sw.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)codecName, (Object)"omx.qcom.video.decoder.hevcswvdec") || StringsKt.startsWith$default((String)codecName, (String)"c2.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"c2.google.", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)codecName, (String)"omx.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)codecName, (String)"c2.", (boolean)false, (int)2, null);
    }

    private final MediaCodecInfo.CodecCapabilities getCodecCapabilities(String mimeType) {
        String encoderName2 = this.findEncoder(mimeType);
        return this.getCodecCapabilities(mimeType, encoderName2);
    }

    private final MediaCodecInfo.CodecCapabilities getCodecCapabilities(String mimeType, String name) {
        MediaCodecInfo codecInfo = this.getCodecInfo(name);
        MediaCodecInfo.CodecCapabilities codecCapabilities = codecInfo.getCapabilitiesForType(mimeType);
        Intrinsics.checkNotNullExpressionValue((Object)codecCapabilities, (String)"codecInfo.getCapabilitie\u2026       mimeType\n        )");
        return codecCapabilities;
    }

    @NotNull
    public final List<MediaCodecInfo.CodecProfileLevel> getProfileLevel(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = this.getCodecCapabilities((String)mimeType).profileLevels;
        Intrinsics.checkNotNullExpressionValue((Object)codecProfileLevelArray, (String)"getCodecCapabilities(mimeType).profileLevels");
        return ArraysKt.toList((Object[])codecProfileLevelArray);
    }

    @NotNull
    public final List<MediaCodecInfo.CodecProfileLevel> getProfileLevel(@NotNull String mimeType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = this.getCodecCapabilities((String)mimeType, (String)name).profileLevels;
        Intrinsics.checkNotNullExpressionValue((Object)codecProfileLevelArray, (String)"getCodecCapabilities(mimeType, name).profileLevels");
        return ArraysKt.toList((Object[])codecProfileLevelArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getProfiles(@NotNull String mimeType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$map$iv = this.getProfileLevel(mimeType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = (MediaCodecInfo.CodecProfileLevel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.profile);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getProfiles(@NotNull String mimeType, @NotNull String name) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$map$iv = this.getProfileLevel(mimeType, name);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = (MediaCodecInfo.CodecProfileLevel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.profile);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMaxLevel(@NotNull String mimeType, int profile) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$filter$iv = this.getProfileLevel(mimeType);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)element$iv$iv;
            boolean bl = false;
            if (!(it.profile == profile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)iterator.next();
        boolean bl = false;
        int n = it.level;
        while (iterator.hasNext()) {
            MediaCodecInfo.CodecProfileLevel it2 = (MediaCodecInfo.CodecProfileLevel)iterator.next();
            $i$a$-maxOf-MediaCodecHelper$getMaxLevel$2 = false;
            int n2 = it2.level;
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMaxLevel(@NotNull String mimeType, @NotNull String name, int profile) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable iterable = this.getProfileLevel(mimeType, name);
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)element$iv$iv;
            boolean bl = false;
            if (!(it.profile == profile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MediaCodecInfo.CodecProfileLevel it = (MediaCodecInfo.CodecProfileLevel)iterator.next();
        boolean bl = false;
        int n = it.level;
        while (iterator.hasNext()) {
            MediaCodecInfo.CodecProfileLevel it2 = (MediaCodecInfo.CodecProfileLevel)iterator.next();
            $i$a$-maxOf-MediaCodecHelper$getMaxLevel$4 = false;
            int n2 = it2.level;
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public final boolean isFormatSupported(@NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = format.getString("mime");
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String mimeType = string;
        Object object = this.secureMediaFormatAction(format, (Function1<? super MediaFormat, ? extends Object>)((Function1)new Function1<MediaFormat, Object>(mimeType, format){
            final /* synthetic */ String $mimeType;
            final /* synthetic */ MediaFormat $format;
            {
                this.$mimeType = $mimeType;
                this.$format = $format;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull MediaFormat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MediaCodecHelper.access$getCodecCapabilities(MediaCodecHelper.INSTANCE, this.$mimeType).isFormatSupported(this.$format);
            }
        }));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)object;
    }

    public final boolean isFormatSupported(@NotNull MediaFormat format, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = format.getString("mime");
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String mimeType = string;
        Object object = this.secureMediaFormatAction(format, (Function1<? super MediaFormat, ? extends Object>)((Function1)new Function1<MediaFormat, Object>(mimeType, name, format){
            final /* synthetic */ String $mimeType;
            final /* synthetic */ String $name;
            final /* synthetic */ MediaFormat $format;
            {
                this.$mimeType = $mimeType;
                this.$name = $name;
                this.$format = $format;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull MediaFormat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MediaCodecHelper.access$getCodecCapabilities(MediaCodecHelper.INSTANCE, this.$mimeType, this.$name).isFormatSupported(this.$format);
            }
        }));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)object;
    }

    public static final /* synthetic */ MediaCodecList access$getCodecList$p() {
        return codecList;
    }

    public static final /* synthetic */ MediaCodecInfo.CodecCapabilities access$getCodecCapabilities(MediaCodecHelper $this, String mimeType) {
        return $this.getCodecCapabilities(mimeType);
    }

    public static final /* synthetic */ List access$getEncodersType(MediaCodecHelper $this, Function1 filter) {
        return $this.getEncodersType((Function1<? super String, Boolean>)filter);
    }

    public static final /* synthetic */ List access$getEncodersName(MediaCodecHelper $this, Function1 filter) {
        return $this.getEncodersName((Function1<? super String, Boolean>)filter);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Video;", "", "()V", "encodersName", "", "", "getEncodersName", "()Ljava/util/List;", "supportedEncoders", "getSupportedEncoders", "getBitrateRange", "Landroid/util/Range;", "", "mimeType", "name", "getFramerateRange", "getSupportedHeights", "getSupportedWidths", "getVideoCapabilities", "Landroid/media/MediaCodecInfo$VideoCapabilities;", "core_release"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE = new Video();
        @NotNull
        private static final List<String> supportedEncoders = MediaCodecHelper.access$getEncodersType(INSTANCE, supportedEncoders.1.INSTANCE);
        @NotNull
        private static final List<String> encodersName = MediaCodecHelper.access$getEncodersName(INSTANCE, encodersName.1.INSTANCE);

        private Video() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        @NotNull
        public final List<String> getEncodersName() {
            return encodersName;
        }

        private final MediaCodecInfo.VideoCapabilities getVideoCapabilities(String mimeType) {
            if (!StringExtensionsKt.isVideo(mimeType)) {
                boolean bl = false;
                String string = "MimeType must be video";
                throw new IllegalArgumentException(string.toString());
            }
            String encoderName2 = INSTANCE.findEncoder(mimeType);
            return this.getVideoCapabilities(mimeType, encoderName2);
        }

        private final MediaCodecInfo.VideoCapabilities getVideoCapabilities(String mimeType, String name) {
            if (!StringExtensionsKt.isVideo(mimeType)) {
                boolean bl = false;
                String string = "MimeType must be video";
                throw new IllegalArgumentException(string.toString());
            }
            MediaCodecInfo.VideoCapabilities videoCapabilities = INSTANCE.getCodecCapabilities(mimeType, name).getVideoCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)videoCapabilities, (String)"getCodecCapabilities(mim\u2026, name).videoCapabilities");
            return videoCapabilities;
        }

        @NotNull
        public final Range<Integer> getSupportedHeights(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mimeType).supportedHeights");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedHeights(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mim\u2026e, name).supportedHeights");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedWidths(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mimeType).supportedHeights");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedWidths(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mim\u2026e, name).supportedHeights");
            return range;
        }

        @NotNull
        public final Range<Integer> getFramerateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getSupportedFrameRates();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mimeType).supportedFrameRates");
            return range;
        }

        @NotNull
        public final Range<Integer> getFramerateRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getSupportedFrameRates();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mim\u2026name).supportedFrameRates");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getVideoCapabilities(mimeType).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mimeType).bitrateRange");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getVideoCapabilities(mimeType, name).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getVideoCapabilities(mimeType, name).bitrateRange");
            return range;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0005J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u00100\u000f2\u0006\u0010\f\u001a\u00020\u0005J$\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00100\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Audio;", "", "()V", "encodersName", "", "", "getEncodersName", "()Ljava/util/List;", "supportedEncoders", "getSupportedEncoders", "getAudioCapabilities", "Landroid/media/MediaCodecInfo$AudioCapabilities;", "mimeType", "name", "getBitrateRange", "Landroid/util/Range;", "", "getInputChannelRange", "kotlin.jvm.PlatformType", "getSupportedSampleRates", "", "core_release"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE = new Audio();
        @NotNull
        private static final List<String> supportedEncoders = MediaCodecHelper.access$getEncodersType(INSTANCE, supportedEncoders.1.INSTANCE);
        @NotNull
        private static final List<String> encodersName = MediaCodecHelper.access$getEncodersName(INSTANCE, encodersName.1.INSTANCE);

        private Audio() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        @NotNull
        public final List<String> getEncodersName() {
            return encodersName;
        }

        private final MediaCodecInfo.AudioCapabilities getAudioCapabilities(String mimeType) {
            if (!StringExtensionsKt.isAudio(mimeType)) {
                boolean bl = false;
                String string = "MimeType must be audio";
                throw new IllegalArgumentException(string.toString());
            }
            String encoderName2 = INSTANCE.findEncoder(mimeType);
            return this.getAudioCapabilities(mimeType, encoderName2);
        }

        private final MediaCodecInfo.AudioCapabilities getAudioCapabilities(String mimeType, String name) {
            if (!StringExtensionsKt.isAudio(mimeType)) {
                boolean bl = false;
                String string = "MimeType must be audio";
                throw new IllegalArgumentException(string.toString());
            }
            MediaCodecInfo.AudioCapabilities audioCapabilities = INSTANCE.getCodecCapabilities(mimeType, name).getAudioCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)audioCapabilities, (String)"getCodecCapabilities(mim\u2026, name).audioCapabilities");
            return audioCapabilities;
        }

        @NotNull
        public final Range<Integer> getInputChannelRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.getAudioCapabilities(mimeType).getMaxInputChannelCount()));
        }

        @NotNull
        public final Range<Integer> getInputChannelRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.getAudioCapabilities(mimeType, name).getMaxInputChannelCount()));
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getAudioCapabilities(mimeType).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getAudioCapabilities(mimeType).bitrateRange");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Range range = this.getAudioCapabilities(mimeType, name).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getAudioCapabilities(mimeType, name).bitrateRange");
            return range;
        }

        @NotNull
        public final int[] getSupportedSampleRates(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            int[] nArray = this.getAudioCapabilities(mimeType).getSupportedSampleRates();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getAudioCapabilities(mim\u2026ype).supportedSampleRates");
            return nArray;
        }

        @NotNull
        public final int[] getSupportedSampleRates(@NotNull String mimeType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int[] nArray = this.getAudioCapabilities(mimeType, name).getSupportedSampleRates();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getAudioCapabilities(mim\u2026ame).supportedSampleRates");
            return nArray;
        }
    }
}

