/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.services;

import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.app.ActivityCompat;
import io.github.thibaultbee.streampack.R;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.listeners.OnConnectionListener;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.streamers.bases.BaseScreenRecorderStreamer;
import io.github.thibaultbee.streampack.streamers.interfaces.ILiveStreamer;
import io.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import io.github.thibaultbee.streampack.utils.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.NotificationUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 92\u00020\u0001:\u00029:B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H$J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010*2\u0006\u00100\u001a\u00020\u0005H\u0014J\u0012\u00101\u001a\u0004\u0018\u00010*2\u0006\u00100\u001a\u00020\u0005H\u0014J\n\u00102\u001a\u0004\u0018\u00010*H\u0014J\b\u00103\u001a\u00020(H\u0016J\b\u00104\u001a\u00020(H\u0016J\u0016\u00105\u001a\u0004\u0018\u00010*2\n\u00106\u001a\u000607j\u0002`8H\u0014R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006;"}, d2={"Lio/github/thibaultbee/streampack/streamers/services/BaseScreenRecorderService;", "Landroid/app/Service;", "notificationId", "", "channelId", "", "channelNameResourceId", "channelDescriptionResourceId", "notificationIconResourceId", "(ILjava/lang/String;III)V", "binder", "Lio/github/thibaultbee/streampack/streamers/services/BaseScreenRecorderService$ScreenRecorderServiceBinder;", "getChannelDescriptionResourceId", "()I", "getChannelId", "()Ljava/lang/String;", "getChannelNameResourceId", "hasNotified", "", "liveStreamer", "Lio/github/thibaultbee/streampack/streamers/interfaces/ILiveStreamer;", "getLiveStreamer", "()Lio/github/thibaultbee/streampack/streamers/interfaces/ILiveStreamer;", "getNotificationIconResourceId", "notificationUtils", "Lio/github/thibaultbee/streampack/utils/NotificationUtils;", "getNotificationUtils", "()Lio/github/thibaultbee/streampack/utils/NotificationUtils;", "notificationUtils$delegate", "Lkotlin/Lazy;", "streamer", "Lio/github/thibaultbee/streampack/streamers/bases/BaseScreenRecorderStreamer;", "getStreamer", "()Lio/github/thibaultbee/streampack/streamers/bases/BaseScreenRecorderStreamer;", "setStreamer", "(Lio/github/thibaultbee/streampack/streamers/bases/BaseScreenRecorderStreamer;)V", "createStreamer", "bundle", "Landroid/os/Bundle;", "notify", "", "notification", "Landroid/app/Notification;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onConnectionFailedNotification", "message", "onConnectionLostNotification", "onConnectionSuccessNotification", "onCreate", "onDestroy", "onErrorNotification", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "ScreenRecorderServiceBinder", "core_release"})
public abstract class BaseScreenRecorderService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int notificationId;
    @NotNull
    private final String channelId;
    private final int channelNameResourceId;
    private final int channelDescriptionResourceId;
    private final int notificationIconResourceId;
    @Nullable
    private BaseScreenRecorderStreamer streamer;
    @NotNull
    private final ScreenRecorderServiceBinder binder;
    @NotNull
    private final Lazy notificationUtils$delegate;
    private boolean hasNotified;
    @NotNull
    public static final String DEFAULT_NOTIFICATION_CHANNEL_ID = "io.github.thibaultbee.streampack.streamers.services";
    public static final int DEFAULT_NOTIFICATION_ID = 3782;
    @NotNull
    private static final String CONSTRUCTOR_BUNDLE_KEY = "config";
    @NotNull
    public static final String ENABLE_AUDIO_KEY = "enableAudio";
    @NotNull
    public static final String MUXER_CONFIG_KEY = "muxerConfig";
    @NotNull
    public static final String ENDPOINT_CONFIG_KEY = "endpointConfig";

    public BaseScreenRecorderService(int notificationId, @NotNull String channelId, @StringRes int channelNameResourceId, @StringRes int channelDescriptionResourceId, @DrawableRes int notificationIconResourceId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.notificationId = notificationId;
        this.channelId = channelId;
        this.channelNameResourceId = channelNameResourceId;
        this.channelDescriptionResourceId = channelDescriptionResourceId;
        this.notificationIconResourceId = notificationIconResourceId;
        this.binder = new ScreenRecorderServiceBinder();
        this.notificationUtils$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationUtils>(this){
            final /* synthetic */ BaseScreenRecorderService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationUtils invoke() {
                return new NotificationUtils(this.this$0, this.this$0.getChannelId(), BaseScreenRecorderService.access$getNotificationId$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ BaseScreenRecorderService(int n, String string2, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 3782;
        }
        if ((n5 & 2) != 0) {
            string2 = DEFAULT_NOTIFICATION_CHANNEL_ID;
        }
        if ((n5 & 4) != 0) {
            n2 = R.string.default_channel_name;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = R.drawable.ic_baseline_linked_camera_24;
        }
        this(n, string2, n2, n3, n4);
    }

    @NotNull
    protected final String getChannelId() {
        return this.channelId;
    }

    protected final int getChannelNameResourceId() {
        return this.channelNameResourceId;
    }

    protected final int getChannelDescriptionResourceId() {
        return this.channelDescriptionResourceId;
    }

    protected final int getNotificationIconResourceId() {
        return this.notificationIconResourceId;
    }

    @Nullable
    protected final BaseScreenRecorderStreamer getStreamer() {
        return this.streamer;
    }

    protected final void setStreamer(@Nullable BaseScreenRecorderStreamer baseScreenRecorderStreamer) {
        this.streamer = baseScreenRecorderStreamer;
    }

    private final NotificationUtils getNotificationUtils() {
        Lazy lazy = this.notificationUtils$delegate;
        return (NotificationUtils)lazy.getValue();
    }

    private final ILiveStreamer getLiveStreamer() {
        ILiveStreamer iLiveStreamer;
        BaseScreenRecorderStreamer baseScreenRecorderStreamer = this.streamer;
        if (baseScreenRecorderStreamer == null) {
            iLiveStreamer = null;
        } else {
            IStreamer $this$getStreamer$iv = baseScreenRecorderStreamer;
            boolean $i$f$getStreamer = false;
            iLiveStreamer = (ILiveStreamer)((Object)($this$getStreamer$iv instanceof ILiveStreamer ? $this$getStreamer$iv : null));
        }
        return iLiveStreamer;
    }

    public void onCreate() {
        super.onCreate();
        this.getNotificationUtils().createNotificationChannel(this.channelNameResourceId, this.channelDescriptionResourceId);
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            boolean enableAudio;
            Bundle bundle = intent.getExtras();
            Bundle bundle2 = (Bundle)(bundle == null ? null : bundle.get(CONSTRUCTOR_BUNDLE_KEY));
            if (bundle2 == null) {
                throw new IllegalStateException("Config bundle must be pass to the service");
            }
            Bundle constructorBundle = bundle2;
            boolean bl = enableAudio = !Intrinsics.areEqual((Object)constructorBundle.get(ENABLE_AUDIO_KEY), (Object)false);
            if (enableAudio && ActivityCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.RECORD_AUDIO") != 0) {
                throw new SecurityException("Permission RECORD_AUDIO must have been granted!");
            }
            BaseScreenRecorderStreamer baseScreenRecorderStreamer = this.streamer = this.createStreamer(constructorBundle);
            if (baseScreenRecorderStreamer != null) {
                baseScreenRecorderStreamer.setOnErrorListener(new OnErrorListener(this){
                    final /* synthetic */ BaseScreenRecorderService this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onError(@NotNull StreamPackError error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        Logger.INSTANCE.e(ExtensionsKt.getTAG(this), "An error occurred", error);
                        Notification notification = this.this$0.onErrorNotification(error);
                        if (notification != null) {
                            Notification notification2 = notification;
                            BaseScreenRecorderService baseScreenRecorderService = this.this$0;
                            Notification it = notification2;
                            boolean bl = false;
                            BaseScreenRecorderService.access$notify(baseScreenRecorderService, it);
                        }
                        this.this$0.stopSelf();
                    }
                });
            }
            ILiveStreamer iLiveStreamer = this.getLiveStreamer();
            if (iLiveStreamer != null) {
                iLiveStreamer.setOnConnectionListener(new OnConnectionListener(this){
                    final /* synthetic */ BaseScreenRecorderService this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onLost(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), Intrinsics.stringPlus((String)"Connection lost: ", (Object)message), null, 4, null);
                        Notification notification = this.this$0.onConnectionLostNotification(message);
                        if (notification != null) {
                            Notification notification2 = notification;
                            BaseScreenRecorderService baseScreenRecorderService = this.this$0;
                            Notification it = notification2;
                            boolean bl = false;
                            BaseScreenRecorderService.access$notify(baseScreenRecorderService, it);
                        }
                        this.this$0.stopSelf();
                    }

                    public void onFailed(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), Intrinsics.stringPlus((String)"Connection failed: ", (Object)message), null, 4, null);
                        Notification notification = this.this$0.onConnectionFailedNotification(message);
                        if (notification != null) {
                            Notification notification2 = notification;
                            BaseScreenRecorderService baseScreenRecorderService = this.this$0;
                            Notification it = notification2;
                            boolean bl = false;
                            BaseScreenRecorderService.access$notify(baseScreenRecorderService, it);
                        }
                        this.this$0.stopSelf();
                    }

                    public void onSuccess() {
                        ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), "Connection succeeded", null, 4, null);
                        Notification notification = this.this$0.onConnectionSuccessNotification();
                        if (notification != null) {
                            Notification notification2 = notification;
                            BaseScreenRecorderService baseScreenRecorderService = this.this$0;
                            Notification it = notification2;
                            boolean bl = false;
                            BaseScreenRecorderService.access$notify(baseScreenRecorderService, it);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(ExtensionsKt.getTAG((Object)this), "An error occurred", e);
            Notification notification = this.onErrorNotification(e);
            if (notification != null) {
                Notification it = notification;
                boolean bl = false;
                this.notify(it);
            }
            this.stopSelf();
        }
        return (IBinder)this.binder;
    }

    @NotNull
    protected abstract BaseScreenRecorderStreamer createStreamer(@NotNull Bundle var1);

    public void onDestroy() {
        super.onDestroy();
        BaseScreenRecorderStreamer baseScreenRecorderStreamer = this.streamer;
        if (baseScreenRecorderStreamer != null) {
            baseScreenRecorderStreamer.stopStream();
        }
        ILiveStreamer iLiveStreamer = (ILiveStreamer)((Object)this.streamer);
        if (iLiveStreamer != null) {
            iLiveStreamer.disconnect();
        }
        BaseScreenRecorderStreamer baseScreenRecorderStreamer2 = this.streamer;
        if (baseScreenRecorderStreamer2 != null) {
            baseScreenRecorderStreamer2.release();
        }
        this.streamer = null;
    }

    @Nullable
    protected Notification onErrorNotification(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NotificationUtils notificationUtils2 = this.getNotificationUtils();
        String string2 = this.getString(R.string.service_notification_error);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.service_notification_error)");
        return notificationUtils2.createNotification(string2, e.getLocalizedMessage(), this.notificationIconResourceId);
    }

    @Nullable
    protected Notification onConnectionLostNotification(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationUtils notificationUtils2 = this.getNotificationUtils();
        String string2 = this.getString(R.string.service_notification_connection_lost);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.servi\u2026fication_connection_lost)");
        return notificationUtils2.createNotification(string2, message, this.notificationIconResourceId);
    }

    @Nullable
    protected Notification onConnectionFailedNotification(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationUtils notificationUtils2 = this.getNotificationUtils();
        String string2 = this.getString(R.string.service_notification_connection_failed);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.servi\u2026cation_connection_failed)");
        return notificationUtils2.createNotification(string2, message, this.notificationIconResourceId);
    }

    @Nullable
    protected Notification onConnectionSuccessNotification() {
        return this.getNotificationUtils().createNotification(R.string.service_notification_connection_succeeded, 0, this.notificationIconResourceId);
    }

    private final void notify(Notification notification) {
        if (!this.hasNotified) {
            this.startForeground(this.notificationId, notification);
            this.hasNotified = true;
        } else {
            this.getNotificationUtils().notify(notification);
        }
    }

    public BaseScreenRecorderService() {
        this(0, null, 0, 0, 0, 31, null);
    }

    public static final /* synthetic */ void access$notify(BaseScreenRecorderService $this, Notification notification) {
        $this.notify(notification);
    }

    public static final /* synthetic */ int access$getNotificationId$p(BaseScreenRecorderService $this) {
        return $this.notificationId;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/streamers/services/BaseScreenRecorderService$ScreenRecorderServiceBinder;", "Landroid/os/Binder;", "(Lio/github/thibaultbee/streampack/streamers/services/BaseScreenRecorderService;)V", "streamer", "Lio/github/thibaultbee/streampack/streamers/bases/BaseScreenRecorderStreamer;", "getStreamer", "()Lio/github/thibaultbee/streampack/streamers/bases/BaseScreenRecorderStreamer;", "core_release"})
    protected final class ScreenRecorderServiceBinder
    extends Binder {
        public ScreenRecorderServiceBinder() {
            Intrinsics.checkNotNullParameter((Object)((Object)BaseScreenRecorderService.this), (String)"this$0");
        }

        @Nullable
        public final BaseScreenRecorderStreamer getStreamer() {
            return BaseScreenRecorderService.this.getStreamer();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J_\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\u00152#\u0010\u0017\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\f0\u0015J_\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\u00152#\u0010\u0017\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\f0\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/thibaultbee/streampack/streamers/services/BaseScreenRecorderService$Companion;", "", "()V", "CONSTRUCTOR_BUNDLE_KEY", "", "DEFAULT_NOTIFICATION_CHANNEL_ID", "DEFAULT_NOTIFICATION_ID", "", "ENABLE_AUDIO_KEY", "ENDPOINT_CONFIG_KEY", "MUXER_CONFIG_KEY", "launch", "", "context", "Landroid/content/Context;", "serviceClass", "Ljava/lang/Class;", "Lio/github/thibaultbee/streampack/streamers/services/BaseScreenRecorderService;", "constructorBundle", "Landroid/os/Bundle;", "onServiceCreated", "Lkotlin/Function1;", "Lio/github/thibaultbee/streampack/streamers/bases/BaseScreenRecorderStreamer;", "onServiceDisconnected", "Landroid/content/ComponentName;", "Lkotlin/ParameterName;", "name", "enableAudio", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void launch(@NotNull Context context, @NotNull Class<? extends BaseScreenRecorderService> serviceClass, boolean enableAudio, @NotNull Function1<? super BaseScreenRecorderStreamer, Unit> onServiceCreated, @NotNull Function1<? super ComponentName, Unit> onServiceDisconnected) {
            void $this$launch_u24lambda_u2d0;
            Bundle bundle;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter(onServiceCreated, (String)"onServiceCreated");
            Intrinsics.checkNotNullParameter(onServiceDisconnected, (String)"onServiceDisconnected");
            Bundle bundle2 = bundle = new Bundle();
            Class<? extends BaseScreenRecorderService> clazz = serviceClass;
            Context context2 = context;
            Companion companion = this;
            boolean bl = false;
            $this$launch_u24lambda_u2d0.putBoolean(BaseScreenRecorderService.ENABLE_AUDIO_KEY, enableAudio);
            Unit unit = Unit.INSTANCE;
            companion.launch(context2, clazz, bundle, onServiceCreated, onServiceDisconnected);
        }

        public final void launch(@NotNull Context context, @NotNull Class<? extends BaseScreenRecorderService> serviceClass, @NotNull Bundle constructorBundle, @NotNull Function1<? super BaseScreenRecorderStreamer, Unit> onServiceCreated, @NotNull Function1<? super ComponentName, Unit> onServiceDisconnected) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)constructorBundle, (String)"constructorBundle");
            Intrinsics.checkNotNullParameter(onServiceCreated, (String)"onServiceCreated");
            Intrinsics.checkNotNullParameter(onServiceDisconnected, (String)"onServiceDisconnected");
            ServiceConnection connection2 = new ServiceConnection(onServiceCreated, onServiceDisconnected){
                final /* synthetic */ Function1<BaseScreenRecorderStreamer, Unit> $onServiceCreated;
                final /* synthetic */ Function1<ComponentName, Unit> $onServiceDisconnected;
                {
                    this.$onServiceCreated = $onServiceCreated;
                    this.$onServiceDisconnected = $onServiceDisconnected;
                }

                public void onServiceConnected(@Nullable ComponentName name, @NotNull IBinder service) {
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    if (service instanceof ScreenRecorderServiceBinder) {
                        BaseScreenRecorderStreamer baseScreenRecorderStreamer = ((ScreenRecorderServiceBinder)service).getStreamer();
                        if (baseScreenRecorderStreamer != null) {
                            BaseScreenRecorderStreamer baseScreenRecorderStreamer2 = baseScreenRecorderStreamer;
                            Function1<BaseScreenRecorderStreamer, Unit> function1 = this.$onServiceCreated;
                            BaseScreenRecorderStreamer it = baseScreenRecorderStreamer2;
                            boolean bl = false;
                            function1.invoke((Object)it);
                        }
                    }
                }

                public void onServiceDisconnected(@Nullable ComponentName name) {
                    this.$onServiceDisconnected.invoke((Object)name);
                }
            };
            Intent $this$launch_u24lambda_u2d1 = intent = new Intent(context, serviceClass);
            boolean bl = false;
            $this$launch_u24lambda_u2d1.putExtra(BaseScreenRecorderService.CONSTRUCTOR_BUNDLE_KEY, constructorBundle);
            Intent intent2 = intent;
            context.bindService(intent2, connection2, 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

