/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.helpers;

import android.util.Range;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.muxers.IVideoMuxerHelper;
import io.github.thibaultbee.streampack.streamers.helpers.IVideoConfigurationHelper;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\nJ(\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\u00132\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/thibaultbee/streampack/streamers/helpers/VideoStreamerConfigurationHelper;", "Lio/github/thibaultbee/streampack/streamers/helpers/IVideoConfigurationHelper;", "videoMuxerHelper", "Lio/github/thibaultbee/streampack/internal/muxers/IVideoMuxerHelper;", "(Lio/github/thibaultbee/streampack/internal/muxers/IVideoMuxerHelper;)V", "avcProfiles", "", "", "hevcProfiles", "supportedEncoders", "", "getSupportedEncoders", "()Ljava/util/List;", "getSupportedBitrates", "Landroid/util/Range;", "mimeType", "getSupportedFramerate", "getSupportedProfiles", "getSupportedResolutions", "Lkotlin/Pair;", "core_release"})
public class VideoStreamerConfigurationHelper
implements IVideoConfigurationHelper {
    @NotNull
    private final IVideoMuxerHelper videoMuxerHelper;
    @NotNull
    private final List<String> supportedEncoders;
    @NotNull
    private final List<Integer> hevcProfiles;
    @NotNull
    private final List<Integer> avcProfiles;

    /*
     * WARNING - void declaration
     */
    public VideoStreamerConfigurationHelper(@NotNull IVideoMuxerHelper videoMuxerHelper) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)videoMuxerHelper, (String)"videoMuxerHelper");
        this.videoMuxerHelper = videoMuxerHelper;
        Object[] objectArray = (Object[])MediaCodecHelper.Video.INSTANCE.getSupportedEncoders();
        VideoStreamerConfigurationHelper videoStreamerConfigurationHelper = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.videoMuxerHelper.getSupportedEncoders().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        videoStreamerConfigurationHelper.supportedEncoders = (List)destination$iv$iv;
        this.hevcProfiles = CollectionsKt.listOf((Object)1);
        objectArray = new Integer[]{1, 65536, 524288, 4, 8, 2};
        this.avcProfiles = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getSupportedEncoders() {
        return this.supportedEncoders;
    }

    @Override
    @NotNull
    public Range<Integer> getSupportedBitrates(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.Video.INSTANCE.getBitrateRange(mimeType);
    }

    @NotNull
    public Pair<Range<Integer>, Range<Integer>> getSupportedResolutions(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Range<Integer> codecSupportedWidths = MediaCodecHelper.Video.INSTANCE.getSupportedWidths(mimeType);
        Range<Integer> codecSupportedHeights = MediaCodecHelper.Video.INSTANCE.getSupportedHeights(mimeType);
        return new Pair(codecSupportedWidths, codecSupportedHeights);
    }

    @NotNull
    public final Range<Integer> getSupportedFramerate(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.Video.INSTANCE.getFramerateRange(mimeType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getSupportedProfiles(@NotNull String mimeType) {
        void $this$filterTo$iv$iv;
        List<Integer> list;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        String string2 = mimeType;
        if (Intrinsics.areEqual((Object)string2, (Object)"video/avc")) {
            list = this.avcProfiles;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"video/hevc")) {
            list = this.hevcProfiles;
        } else {
            throw new InvalidParameterException(Intrinsics.stringPlus((String)"Unknow mimetype ", (Object)mimeType));
        }
        List<Integer> profiles = list;
        List<Integer> supportedProfiles = MediaCodecHelper.INSTANCE.getProfiles(mimeType);
        Iterable $this$filter$iv = supportedProfiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!profiles.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

