/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceHolder;
import android.view.ViewConfiguration;
import androidx.core.app.ActivityCompat;
import io.github.thibaultbee.streampack.R;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.streamers.interfaces.settings.IBaseCameraStreamerSettings;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import io.github.thibaultbee.streampack.utils.CameraSettings;
import io.github.thibaultbee.streampack.utils.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.OrientationUtils;
import io.github.thibaultbee.streampack.utils.Zoom;
import io.github.thibaultbee.streampack.views.AutoFitSurfaceView;
import io.github.thibaultbee.streampack.views.CameraSizesKt;
import io.github.thibaultbee.streampack.views.FacingDirection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 -2\u00020\u0001:\u0004-./0B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\u0012\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/github/thibaultbee/streampack/views/StreamerSurfaceView;", "Lio/github/thibaultbee/streampack/views/AutoFitSurfaceView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraFacingDirection", "Lio/github/thibaultbee/streampack/views/FacingDirection;", "defaultCameraId", "", "enableTapToFocus", "", "getEnableTapToFocus", "()Z", "setEnableTapToFocus", "(Z)V", "enableZoomOnPinch", "getEnableZoomOnPinch", "setEnableZoomOnPinch", "listener", "Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$Listener;", "getListener", "()Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$Listener;", "setListener", "(Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$Listener;)V", "pinchGesture", "Landroid/view/ScaleGestureDetector;", "value", "Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "streamer", "getStreamer", "()Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "setStreamer", "(Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;)V", "touchUpEvent", "Landroid/view/MotionEvent;", "onTouchEvent", "event", "performClick", "startPreviewIfReady", "", "shouldFailSilently", "Companion", "Listener", "PinchToZoomOnScaleGestureListener", "StreamerHolderCallback", "core_release"})
public class StreamerSurfaceView
extends AutoFitSurfaceView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FacingDirection cameraFacingDirection;
    @Nullable
    private final String defaultCameraId;
    private boolean enableZoomOnPinch;
    private boolean enableTapToFocus;
    @Nullable
    private MotionEvent touchUpEvent;
    @Nullable
    private ICameraStreamer streamer;
    @Nullable
    private Listener listener;
    @NotNull
    private final ScaleGestureDetector pinchGesture;
    @NotNull
    private static final FacingDirection DEFAULT_CAMERA_FACING = FacingDirection.BACK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public StreamerSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.pinchGesture = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new PinchToZoomOnScaleGestureListener());
        this.getHolder().addCallback((SurfaceHolder.Callback)new StreamerHolderCallback());
        Object object = context.obtainStyledAttributes(attrs, R.styleable.StreamerSurfaceView);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.obtainStyledAttr\u2026able.StreamerSurfaceView)");
        TypedArray a = object;
        try {
            String string2;
            String string3 = a.getString(R.styleable.StreamerSurfaceView_cameraFacingDirection);
            object = string3 == null ? DEFAULT_CAMERA_FACING.getValue() : string3;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"a.getString(R.styleable.\u2026FAULT_CAMERA_FACING.value");
            this.cameraFacingDirection = FacingDirection.Companion.fromValue((String)object);
            switch (WhenMappings.$EnumSwitchMapping$0[this.cameraFacingDirection.ordinal()]) {
                case 1: {
                    string2 = (String)CollectionsKt.firstOrNull(CameraExtensionsKt.getFrontCameraList(context));
                    break;
                }
                case 2: {
                    string2 = (String)CollectionsKt.firstOrNull(CameraExtensionsKt.getBackCameraList(context));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.defaultCameraId = string2;
            this.enableZoomOnPinch = a.getBoolean(R.styleable.StreamerSurfaceView_enableZoomOnPinch, true);
            this.enableTapToFocus = a.getBoolean(R.styleable.StreamerSurfaceView_enableTapToFocus, true);
        }
        finally {
            a.recycle();
        }
    }

    public /* synthetic */ StreamerSurfaceView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean getEnableZoomOnPinch() {
        return this.enableZoomOnPinch;
    }

    public final void setEnableZoomOnPinch(boolean bl) {
        this.enableZoomOnPinch = bl;
    }

    public final boolean getEnableTapToFocus() {
        return this.enableTapToFocus;
    }

    public final void setEnableTapToFocus(boolean bl) {
        this.enableTapToFocus = bl;
    }

    @Nullable
    public final ICameraStreamer getStreamer() {
        return this.streamer;
    }

    public final void setStreamer(@Nullable ICameraStreamer value) {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            iCameraStreamer.stopPreview();
        }
        this.streamer = value;
        StreamerSurfaceView.startPreviewIfReady$default(this, false, 1, null);
    }

    @Nullable
    public final Listener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean notALongPress;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.streamer == null) {
            return super.onTouchEvent(event);
        }
        if (this.enableZoomOnPinch) {
            this.pinchGesture.onTouchEvent(event);
        }
        boolean isSingleTouch = event.getPointerCount() == 1;
        boolean isUpEvent = event.getAction() == 1;
        boolean bl = notALongPress = event.getEventTime() - event.getDownTime() < (long)ViewConfiguration.getLongPressTimeout();
        if (isSingleTouch && isUpEvent && notALongPress) {
            this.touchUpEvent = event;
            this.performClick();
            return true;
        }
        return true;
    }

    public boolean performClick() {
        ICameraStreamer iCameraStreamer = this.streamer;
        if (iCameraStreamer != null) {
            ICameraStreamer it = iCameraStreamer;
            boolean bl = false;
            if (this.getEnableTapToFocus()) {
                MotionEvent motionEvent = this.touchUpEvent;
                Float f = motionEvent == null ? null : Float.valueOf(motionEvent.getX());
                float x = f == null ? (float)this.getWidth() / 2.0f : f.floatValue();
                MotionEvent motionEvent2 = this.touchUpEvent;
                Float f2 = motionEvent2 == null ? null : Float.valueOf(motionEvent2.getY());
                float y = f2 == null ? (float)this.getHeight() / 2.0f : f2.floatValue();
                it.getSettings().getCamera().getFocusMetering().onTap(new PointF(x, y), new Rect((int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight()), OrientationUtils.INSTANCE.getSurfaceOrientation(this.getDisplay().getRotation()));
            }
        }
        this.touchUpEvent = null;
        return super.performClick();
    }

    private final void startPreviewIfReady(boolean shouldFailSilently) {
        if (this.getDisplay() != null) {
            ICameraStreamer iCameraStreamer = this.streamer;
            if (iCameraStreamer != null) {
                ICameraStreamer it = iCameraStreamer;
                boolean bl = false;
                try {
                    String string2 = this.defaultCameraId;
                    if (string2 == null) {
                        string2 = it.getCamera();
                    }
                    String camera = string2;
                    ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)this), Intrinsics.stringPlus((String)"Starting on camera: ", (Object)camera), null, 4, null);
                    Display display = this.getDisplay();
                    Intrinsics.checkNotNullExpressionValue((Object)display, (String)"this.display");
                    Display display2 = display;
                    display = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)display, (String)"context");
                    Size previewSize = CameraSizesKt.getPreviewOutputSize$default(display2, CameraExtensionsKt.getCameraCharacteristics((Context)display, camera), SurfaceHolder.class, null, 8, null);
                    ILogger.DefaultImpls.d$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)this), "View finder size: " + this.getWidth() + " x " + this.getHeight(), null, 4, null);
                    ILogger.DefaultImpls.d$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)this), Intrinsics.stringPlus((String)"Selected preview size: ", (Object)previewSize), null, 4, null);
                    this.setAspectRatio(previewSize.getWidth(), previewSize.getHeight());
                    Boolean bl2 = this.post(() -> StreamerSurfaceView.startPreviewIfReady$lambda-2$lambda-1(this, it, camera));
                }
                catch (Exception e) {
                    if (!shouldFailSilently) {
                        throw e;
                    }
                    Logger.INSTANCE.w(ExtensionsKt.getTAG((Object)this), e.toString(), e);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    static /* synthetic */ void startPreviewIfReady$default(StreamerSurfaceView streamerSurfaceView, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startPreviewIfReady");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        streamerSurfaceView.startPreviewIfReady(bl);
    }

    @JvmOverloads
    public StreamerSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StreamerSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void startPreviewIfReady$lambda-2$lambda-1(StreamerSurfaceView this$0, ICameraStreamer $it, String $camera) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$camera, (String)"$camera");
        if (ActivityCompat.checkSelfPermission((Context)this$0.getContext(), (String)"android.permission.CAMERA") != 0) {
            throw new SecurityException("Camera permission is needed to run this application");
        }
        $it.startPreview(this$0, $camera);
        Listener listener = this$0.listener;
        if (listener != null) {
            listener.onPreviewStarted();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$Companion;", "", "()V", "DEFAULT_CAMERA_FACING", "Lio/github/thibaultbee/streampack/views/FacingDirection;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$StreamerHolderCallback;", "Landroid/view/SurfaceHolder$Callback;", "(Lio/github/thibaultbee/streampack/views/StreamerSurfaceView;)V", "surfaceChanged", "", "holder", "Landroid/view/SurfaceHolder;", "format", "", "width", "height", "surfaceCreated", "surfaceDestroyed", "core_release"})
    private final class StreamerHolderCallback
    implements SurfaceHolder.Callback {
        public StreamerHolderCallback() {
            Intrinsics.checkNotNullParameter((Object)((Object)StreamerSurfaceView.this), (String)"this$0");
        }

        public void surfaceCreated(@NotNull SurfaceHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            StreamerSurfaceView.startPreviewIfReady$default(StreamerSurfaceView.this, false, 1, null);
        }

        public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        }

        public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            ICameraStreamer iCameraStreamer = StreamerSurfaceView.this.getStreamer();
            if (iCameraStreamer != null) {
                iCameraStreamer.stopPreview();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$PinchToZoomOnScaleGestureListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lio/github/thibaultbee/streampack/views/StreamerSurfaceView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "core_release"})
    private final class PinchToZoomOnScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public PinchToZoomOnScaleGestureListener() {
            Intrinsics.checkNotNullParameter((Object)((Object)StreamerSurfaceView.this), (String)"this$0");
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            ICameraStreamer iCameraStreamer = StreamerSurfaceView.this.getStreamer();
            if (iCameraStreamer != null) {
                IBaseCameraStreamerSettings iBaseCameraStreamerSettings = iCameraStreamer.getSettings();
                if (iBaseCameraStreamerSettings != null) {
                    CameraSettings cameraSettings = iBaseCameraStreamerSettings.getCamera();
                    if (cameraSettings != null) {
                        Zoom zoom = cameraSettings.getZoom();
                        if (zoom != null) {
                            Zoom zoom2 = zoom;
                            StreamerSurfaceView streamerSurfaceView = StreamerSurfaceView.this;
                            Zoom it = zoom2;
                            boolean bl = false;
                            it.onPinch(detector.getScaleFactor());
                            Listener listener = streamerSurfaceView.getListener();
                            if (listener != null) {
                                listener.onZoomRationOnPinchChanged(it.getZoomRatio());
                            }
                        }
                    }
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/views/StreamerSurfaceView$Listener;", "", "onPreviewStarted", "", "onZoomRationOnPinchChanged", "zoomRatio", "", "core_release"})
    public static interface Listener {
        public void onPreviewStarted();

        public void onZoomRationOnPinchChanged(float var1);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onPreviewStarted(@NotNull Listener this_) {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            }

            public static void onZoomRationOnPinchChanged(@NotNull Listener this_, float zoomRatio) {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FacingDirection.values().length];
            nArray[FacingDirection.FRONT.ordinal()] = 1;
            nArray[FacingDirection.BACK.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

