/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils;

import android.content.Context;
import android.hardware.display.DisplayManager;
import io.github.thibaultbee.streampack.utils.OrientationUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u00a8\u0006\u0006"}, d2={"getDeviceOrientation", "", "Landroid/content/Context;", "isDeviceLandscape", "", "isDevicePortrait", "core_release"})
public final class OrientationExtensionsKt {
    public static final int getDeviceOrientation(@NotNull Context $this$getDeviceOrientation) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getDeviceOrientation, (String)"<this>");
        Object object = $this$getDeviceOrientation.getSystemService("display");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
        }
        DisplayManager displayManager = (DisplayManager)object;
        int displayRotation = displayManager.getDisplay(0).getRotation();
        switch (displayRotation) {
            case 0: {
                n = 90;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 270;
                break;
            }
            case 3: {
                n = 180;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unsupported display rotation: ", (Object)displayRotation));
            }
        }
        return n;
    }

    public static final boolean isDevicePortrait(@NotNull Context $this$isDevicePortrait) {
        Intrinsics.checkNotNullParameter((Object)$this$isDevicePortrait, (String)"<this>");
        int orientation = OrientationExtensionsKt.getDeviceOrientation($this$isDevicePortrait);
        return OrientationUtils.INSTANCE.isPortrait(orientation);
    }

    public static final boolean isDeviceLandscape(@NotNull Context $this$isDeviceLandscape) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeviceLandscape, (String)"<this>");
        return !OrientationExtensionsKt.isDevicePortrait($this$isDeviceLandscape);
    }
}

