/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts.packets;

import io.github.thibaultbee.streampack.internal.muxers.ts.data.ITSElement;
import io.github.thibaultbee.streampack.internal.utils.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/TableHeader;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/ITSElement;", "tableId", "", "sectionSyntaxIndicator", "", "reservedFutureUse", "payloadLength", "", "tableIdExtension", "versionNumber", "currentNextIndicator", "sectionNumber", "lastSectionNumber", "(BZZSSBZBB)V", "bitSize", "", "getBitSize", "()I", "sectionLength", "size", "getSize", "toByteBuffer", "Ljava/nio/ByteBuffer;", "core_release"})
public final class TableHeader
implements ITSElement {
    private final byte tableId;
    private final boolean sectionSyntaxIndicator;
    private final boolean reservedFutureUse;
    private final short tableIdExtension;
    private final byte versionNumber;
    private final boolean currentNextIndicator;
    private final byte sectionNumber;
    private final byte lastSectionNumber;
    private final int bitSize;
    private final int size;
    private final int sectionLength;

    public TableHeader(byte tableId, boolean sectionSyntaxIndicator, boolean reservedFutureUse, short payloadLength, short tableIdExtension, byte versionNumber, boolean currentNextIndicator, byte sectionNumber, byte lastSectionNumber) {
        this.tableId = tableId;
        this.sectionSyntaxIndicator = sectionSyntaxIndicator;
        this.reservedFutureUse = reservedFutureUse;
        this.tableIdExtension = tableIdExtension;
        this.versionNumber = versionNumber;
        this.currentNextIndicator = currentNextIndicator;
        this.sectionNumber = sectionNumber;
        this.lastSectionNumber = lastSectionNumber;
        this.bitSize = 64;
        this.size = this.getBitSize() / 8;
        this.sectionLength = payloadLength + 5 + 4;
    }

    public /* synthetic */ TableHeader(byte by, boolean bl, boolean bl2, short s, short s2, byte by2, boolean bl3, byte by3, byte by4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            s2 = 0;
        }
        if ((n & 0x40) != 0) {
            bl3 = true;
        }
        this(by, bl, bl2, s, s2, by2, bl3, by3, by4);
    }

    @Override
    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        buffer.put(this.tableId);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        ByteBufferExtensionsKt.put(buffer, BitOperationExtensionsKt.shl(this.sectionSyntaxIndicator, 7) | BitOperationExtensionsKt.shl(this.reservedFutureUse, 6) | 0x30 | this.sectionLength >> 8 & 3);
        ByteBufferExtensionsKt.put(buffer, this.sectionLength);
        buffer.putShort(this.tableIdExtension);
        ByteBufferExtensionsKt.put(buffer, 0xC0 | BitOperationExtensionsKt.shl(this.versionNumber, 1) | BitOperationExtensionsKt.toInt(this.currentNextIndicator));
        buffer.put(this.sectionNumber);
        buffer.put(this.lastSectionNumber);
        buffer.rewind();
        return buffer;
    }
}

