/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.bases;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.encoders.VideoMediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.sources.AudioCapture;
import io.github.thibaultbee.streampack.internal.sources.IVideoCapture;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraCapture;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.StreamPackLogger;
import io.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import io.github.thibaultbee.streampack.streamers.helpers.CameraStreamerConfigurationHelper;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.streamers.settings.BaseCameraStreamerSettings;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0011H\u0017J\b\u0010)\u001a\u00020$H\u0016R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006*"}, d2={"Lio/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer;", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lio/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "context", "Landroid/content/Context;", "logger", "Lio/github/thibaultbee/streampack/logger/ILogger;", "enableAudio", "", "muxer", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "endpoint", "Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "initialOnErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/logger/ILogger;ZLio/github/thibaultbee/streampack/internal/muxers/IMuxer;Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "value", "", "camera", "getCamera", "()Ljava/lang/String;", "setCamera", "(Ljava/lang/String;)V", "cameraCapture", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraCapture;", "helper", "Lio/github/thibaultbee/streampack/streamers/helpers/CameraStreamerConfigurationHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/streamers/helpers/CameraStreamerConfigurationHelper;", "settings", "Lio/github/thibaultbee/streampack/streamers/settings/BaseCameraStreamerSettings;", "getSettings", "()Lio/github/thibaultbee/streampack/streamers/settings/BaseCameraStreamerSettings;", "setSettings", "(Lio/github/thibaultbee/streampack/streamers/settings/BaseCameraStreamerSettings;)V", "release", "", "startPreview", "previewSurface", "Landroid/view/Surface;", "cameraId", "stopPreview", "core_release"})
public class BaseCameraStreamer
extends BaseStreamer
implements ICameraStreamer {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraCapture cameraCapture;
    @NotNull
    private final CameraStreamerConfigurationHelper helper;
    @NotNull
    private BaseCameraStreamerSettings settings;

    public BaseCameraStreamer(@NotNull Context context, @NotNull ILogger logger, boolean enableAudio, @NotNull IMuxer muxer, @NotNull IEndpoint endpoint, @Nullable OnErrorListener initialOnErrorListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)muxer, (String)"muxer");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        CameraCapture cameraCapture = new CameraCapture(context, logger);
        AudioCapture audioCapture = enableAudio ? new AudioCapture(logger) : null;
        super(context, logger, audioCapture, cameraCapture, true, muxer, endpoint, initialOnErrorListener);
        this.context = context;
        IVideoCapture iVideoCapture = this.getVideoCapture();
        if (iVideoCapture == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.github.thibaultbee.streampack.internal.sources.camera.CameraCapture");
        }
        this.cameraCapture = (CameraCapture)iVideoCapture;
        this.helper = new CameraStreamerConfigurationHelper(muxer.getHelper());
        this.settings = new BaseCameraStreamerSettings(this.getAudioCapture(), this.cameraCapture, this.getAudioEncoder(), this.getVideoEncoder());
    }

    public /* synthetic */ BaseCameraStreamer(Context context, ILogger iLogger, boolean bl, IMuxer iMuxer, IEndpoint iEndpoint, OnErrorListener onErrorListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iLogger = new StreamPackLogger();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            onErrorListener = null;
        }
        this(context, iLogger, bl, iMuxer, iEndpoint, onErrorListener);
    }

    @Override
    @NotNull
    public CameraStreamerConfigurationHelper getHelper() {
        return this.helper;
    }

    @Override
    @NotNull
    public String getCamera() {
        return this.cameraCapture.getCameraId();
    }

    @Override
    @RequiresPermission(value="android.permission.CAMERA")
    public void setCamera(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.cameraCapture.setCameraId(value);
    }

    @Override
    @NotNull
    public BaseCameraStreamerSettings getSettings() {
        return this.settings;
    }

    public void setSettings(@NotNull BaseCameraStreamerSettings baseCameraStreamerSettings) {
        Intrinsics.checkNotNullParameter((Object)baseCameraStreamerSettings, (String)"<set-?>");
        this.settings = baseCameraStreamerSettings;
    }

    @Override
    @RequiresPermission(allOf={"android.permission.CAMERA"})
    public void startPreview(@NotNull Surface previewSurface, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)previewSurface, (String)"previewSurface");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        if (!(this.getVideoConfig() != null)) {
            boolean bl = false;
            String string = "Video has not been configured!";
            throw new IllegalArgumentException(string.toString());
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, previewSurface, cameraId2, null){
            int label;
            final /* synthetic */ BaseCameraStreamer this$0;
            final /* synthetic */ Surface $previewSurface;
            final /* synthetic */ String $cameraId;
            {
                this.this$0 = $receiver;
                this.$previewSurface = $previewSurface;
                this.$cameraId = $cameraId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BaseCameraStreamer.access$getCameraCapture$p(this.this$0).setPreviewSurface(this.$previewSurface);
                        VideoMediaCodecEncoder videoMediaCodecEncoder = this.this$0.getVideoEncoder();
                        BaseCameraStreamer.access$getCameraCapture$p(this.this$0).setEncoderSurface((Surface)(videoMediaCodecEncoder == null ? null : videoMediaCodecEncoder.getInputSurface()));
                        this.label = 1;
                        Object object3 = CameraCapture.startPreview$default(BaseCameraStreamer.access$getCameraCapture$p(this.this$0), this.$cameraId, false, (Continuation)this, 2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.stopPreview();
                            throw new StreamPackError(e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    public void stopPreview() {
        this.stopStream();
        this.cameraCapture.stopPreview();
    }

    @Override
    public void release() {
        this.stopPreview();
        super.release();
    }

    public static final /* synthetic */ CameraCapture access$getCameraCapture$p(BaseCameraStreamer $this) {
        return $this.cameraCapture;
    }
}

