/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.camera;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.os.SystemClock;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraHelper;", "", "()V", "CLOCK_OFFSET_CALIBRATION_ATTEMPTS", "", "getOffsetFromRealtimeTimestampSource", "", "getOffsetFromUnknownTimestampSource", "getTimeOffsetToMonoClock", "context", "Landroid/content/Context;", "cameraId", "", "core_release"})
public final class CameraHelper {
    @NotNull
    public static final CameraHelper INSTANCE = new CameraHelper();
    private static final int CLOCK_OFFSET_CALIBRATION_ATTEMPTS = 3;

    private CameraHelper() {
    }

    public final long getTimeOffsetToMonoClock(@NotNull Context context, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = (Integer)CameraExtensionsKt.getCameraCharacteristics(context, cameraId2).get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE);
        int n2 = 1;
        return n != null && n == n2 ? this.getOffsetFromRealtimeTimestampSource() : this.getOffsetFromUnknownTimestampSource();
    }

    private final long getOffsetFromUnknownTimestampSource() {
        return 0L;
    }

    private final long getOffsetFromRealtimeTimestampSource() {
        long offset = Long.MAX_VALUE;
        long lowestGap = Long.MAX_VALUE;
        int n = 0;
        while (n < 3) {
            int i = n++;
            long startMonoTs = System.nanoTime();
            long realTs = SystemClock.elapsedRealtimeNanos();
            long endMonoTs = System.nanoTime();
            long gapMonoTs = endMonoTs - startMonoTs;
            if (gapMonoTs >= lowestGap) continue;
            lowestGap = gapMonoTs;
            offset = (startMonoTs + endMonoTs) / (long)2 - realTs;
        }
        return offset / (long)1000;
    }
}

