/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.camera;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.sources.IVideoCapture;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraCapture;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraHelper;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import io.github.thibaultbee.streampack.utils.CameraSettings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020/H\u0016J%\u00108\u001a\u00020/2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u00109\u001a\u00020\u0019H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020/H\u0016J\u0006\u0010<\u001a\u00020/J\b\u0010=\u001a\u00020/H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001b\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u0015R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006>"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraCapture;", "Lio/github/thibaultbee/streampack/internal/sources/IVideoCapture;", "context", "Landroid/content/Context;", "logger", "Lio/github/thibaultbee/streampack/logger/ILogger;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/logger/ILogger;)V", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "value", "", "cameraId", "getCameraId", "()Ljava/lang/String;", "setCameraId", "(Ljava/lang/String;)V", "encoderSurface", "Landroid/view/Surface;", "getEncoderSurface", "()Landroid/view/Surface;", "setEncoderSurface", "(Landroid/view/Surface;)V", "fps", "", "hasSurface", "", "getHasSurface", "()Z", "isPreviewing", "isPreviewing$core_release", "setPreviewing$core_release", "(Z)V", "isStreaming", "previewSurface", "getPreviewSurface", "setPreviewSurface", "settings", "Lio/github/thibaultbee/streampack/utils/CameraSettings;", "getSettings", "()Lio/github/thibaultbee/streampack/utils/CameraSettings;", "setSettings", "(Lio/github/thibaultbee/streampack/utils/CameraSettings;)V", "timestampOffset", "", "getTimestampOffset", "()J", "checkStream", "", "configure", "config", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "getFrame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "release", "startPreview", "restartStream", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startStream", "stopPreview", "stopStream", "core_release"})
public final class CameraCapture
implements IVideoCapture {
    @NotNull
    private final Context context;
    @Nullable
    private Surface previewSurface;
    @Nullable
    private Surface encoderSurface;
    @NotNull
    private String cameraId;
    @NotNull
    private CameraController cameraController;
    @NotNull
    private CameraSettings settings;
    private final long timestampOffset;
    private final boolean hasSurface;
    private int fps;
    private boolean isStreaming;
    private boolean isPreviewing;

    public CameraCapture(@NotNull Context context, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.cameraId = "0";
        this.cameraController = new CameraController(this.context, null, logger, 2, null);
        this.settings = new CameraSettings(this.context, this.cameraController);
        this.timestampOffset = CameraHelper.INSTANCE.getTimeOffsetToMonoClock(this.context, this.getCameraId());
        this.hasSurface = true;
        this.fps = 30;
    }

    @Nullable
    public final Surface getPreviewSurface() {
        return this.previewSurface;
    }

    public final void setPreviewSurface(@Nullable Surface surface) {
        this.previewSurface = surface;
    }

    @Override
    @Nullable
    public Surface getEncoderSurface() {
        return this.encoderSurface;
    }

    @Override
    public void setEncoderSurface(@Nullable Surface surface) {
        this.encoderSurface = surface;
    }

    @NotNull
    public final String getCameraId() {
        String string = this.cameraController.getCameraId();
        if (string == null) {
            string = this.cameraId;
        }
        return string;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public final void setCameraId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!CameraExtensionsKt.isFrameRateSupported(this.context, value, this.fps)) {
            throw new UnsupportedOperationException("Camera " + value + " does not support " + this.fps + " fps");
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ CameraCapture this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean restartStream = CameraCapture.access$isStreaming$p(this.this$0);
                        this.this$0.stopPreview();
                        this.label = 1;
                        Object object3 = this.this$0.startPreview(this.$value, restartStream, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.cameraId = value;
    }

    @NotNull
    public final CameraSettings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull CameraSettings cameraSettings) {
        Intrinsics.checkNotNullParameter((Object)cameraSettings, (String)"<set-?>");
        this.settings = cameraSettings;
    }

    @Override
    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    @Override
    public boolean getHasSurface() {
        return this.hasSurface;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        throw new UnsupportedOperationException("Camera expects to run in Surface mode");
    }

    public final boolean isPreviewing$core_release() {
        return this.isPreviewing;
    }

    public final void setPreviewing$core_release(boolean bl) {
        this.isPreviewing = bl;
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.fps = config.getFps();
    }

    /*
     * Unable to fully structure code
     */
    @RequiresPermission(value="android.permission.CAMERA")
    @Nullable
    public final Object startPreview(@NotNull String var1_1, boolean var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof startPreview.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ CameraCapture this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startPreview(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                targets = new Ref.ObjectRef();
                targets.element = new ArrayList<E>();
                v0 = this.getPreviewSurface();
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-CameraCapture$startPreview$2 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                v1 = this.getEncoderSurface();
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-CameraCapture$startPreview$3 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = targets;
                $continuation.Z$0 = restartStream;
                $continuation.label = 1;
                v2 = this.cameraController.startCamera((String)cameraId, (List)targets.element, (Continuation<? super Unit>)$continuation);
                if (v2 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl42
            }
            case 1: {
                restartStream = $continuation.Z$0;
                targets = (Ref.ObjectRef)$continuation.L$1;
                this = (CameraCapture)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                targets.element = new ArrayList<E>();
                v3 = this.getPreviewSurface();
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-CameraCapture$startPreview$4 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                if (restartStream) {
                    v4 = this.getEncoderSurface();
                    if (v4 != null) {
                        it = v4;
                        $i$a$-let-CameraCapture$startPreview$5 = false;
                        Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                    }
                }
                this.cameraController.startRequestSession(this.fps, (List)targets.element);
                this.setPreviewing$core_release(true);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object startPreview$default(CameraCapture cameraCapture, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = cameraCapture.getCameraId();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return cameraCapture.startPreview(string, bl, (Continuation<? super Unit>)continuation);
    }

    public final void stopPreview() {
        this.isPreviewing = false;
        this.cameraController.stopCamera();
    }

    private final void checkStream() {
        if (!(this.getEncoderSurface() != null)) {
            boolean bl = false;
            String string = "encoder surface must not be null";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void startStream() {
        this.checkStream();
        this.cameraController.muteVibrationAndSound();
        Surface surface = this.getEncoderSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.cameraController.addTarget(surface);
        this.isStreaming = true;
    }

    @Override
    public void stopStream() {
        if (this.isStreaming) {
            this.checkStream();
            this.cameraController.unmuteVibrationAndSound();
            this.isStreaming = false;
            Surface surface = this.getEncoderSurface();
            Intrinsics.checkNotNull((Object)surface);
            this.cameraController.removeTarget(surface);
        }
    }

    @Override
    public void release() {
        this.cameraController.release();
    }

    public static final /* synthetic */ boolean access$isStreaming$p(CameraCapture $this) {
        return $this.isStreaming;
    }
}

