/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.data;

import android.content.Context;
import android.os.Build;
import android.util.Size;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.utils.DeviceExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/github/thibaultbee/streampack/data/VideoConfig;", "Lio/github/thibaultbee/streampack/data/Config;", "mimeType", "", "startBitrate", "", "resolution", "Landroid/util/Size;", "fps", "profile", "level", "(Ljava/lang/String;ILandroid/util/Size;III)V", "getFps", "()I", "getLevel", "getProfile", "getResolution", "()Landroid/util/Size;", "getOrientedResolution", "context", "Landroid/content/Context;", "Companion", "core_release"})
public final class VideoConfig
extends Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Size resolution;
    private final int fps;
    private final int profile;
    private final int level;

    public VideoConfig(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, int profile, int level) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        super(mimeType, startBitrate);
        this.resolution = resolution;
        this.fps = fps;
        this.profile = profile;
        this.level = level;
        if (!StringExtensionsKt.isVideo(mimeType)) {
            boolean bl = false;
            String string = "MimeType must be video";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ VideoConfig(String string, int n, Size size, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            string = "video/avc";
        }
        if ((n5 & 2) != 0) {
            n = 2000000;
        }
        if ((n5 & 4) != 0) {
            size = new Size(1280, 720);
        }
        if ((n5 & 8) != 0) {
            n2 = 30;
        }
        if ((n5 & 0x10) != 0) {
            n3 = VideoConfig.Companion.getDefaultProfile(string);
        }
        if ((n5 & 0x20) != 0) {
            n4 = VideoConfig.Companion.getDefaultLevel(string);
        }
        this(string, n, size, n2, n3, n4);
    }

    @NotNull
    public final Size getResolution() {
        return this.resolution;
    }

    public final int getFps() {
        return this.fps;
    }

    public final int getProfile() {
        return this.profile;
    }

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public final Size getOrientedResolution(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return DeviceExtensionsKt.isPortrait(context) ? new Size(this.resolution.getHeight(), this.resolution.getWidth()) : new Size(this.resolution.getWidth(), this.resolution.getHeight());
    }

    public VideoConfig() {
        this(null, 0, null, 0, 0, 0, 63, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lio/github/thibaultbee/streampack/data/VideoConfig$Companion;", "", "()V", "getDefaultLevel", "", "mimeType", "", "getDefaultProfile", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getDefaultProfile(String mimeType) {
            int n;
            String string = mimeType;
            if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
                n = 8;
            } else if (Intrinsics.areEqual((Object)string, (Object)"video/hevc")) {
                n = 1;
            } else {
                throw new IOException(Intrinsics.stringPlus((String)"Not supported mime type: ", (Object)mimeType));
            }
            return n;
        }

        private final int getDefaultLevel(String mimeType) {
            int n;
            String string = mimeType;
            if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
                n = Build.VERSION.SDK_INT >= 29 ? 524288 : 65536;
            } else if (Intrinsics.areEqual((Object)string, (Object)"video/hevc")) {
                n = 0x1000000;
            } else {
                throw new IOException(Intrinsics.stringPlus((String)"Not supported mime type: ", (Object)mimeType));
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

