/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.data;

import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014BK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lio/github/thibaultbee/streampack/data/AudioConfig;", "Lio/github/thibaultbee/streampack/data/Config;", "mimeType", "", "startBitrate", "", "sampleRate", "channelConfig", "byteFormat", "enableEchoCanceler", "", "enableNoiseSuppressor", "(Ljava/lang/String;IIIIZZ)V", "getByteFormat", "()I", "getChannelConfig", "getEnableEchoCanceler", "()Z", "getEnableNoiseSuppressor", "getSampleRate", "Companion", "core_release"})
public final class AudioConfig
extends Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int sampleRate;
    private final int channelConfig;
    private final int byteFormat;
    private final boolean enableEchoCanceler;
    private final boolean enableNoiseSuppressor;

    public AudioConfig(@NotNull String mimeType, int startBitrate, int sampleRate, int channelConfig, int byteFormat, boolean enableEchoCanceler, boolean enableNoiseSuppressor) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        super(mimeType, startBitrate);
        this.sampleRate = sampleRate;
        this.channelConfig = channelConfig;
        this.byteFormat = byteFormat;
        this.enableEchoCanceler = enableEchoCanceler;
        this.enableNoiseSuppressor = enableNoiseSuppressor;
        if (!StringExtensionsKt.isAudio(mimeType)) {
            boolean bl = false;
            String string = "MimeType must be audio";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AudioConfig(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            string = "audio/mp4a-latm";
        }
        if ((n5 & 2) != 0) {
            n = 128000;
        }
        if ((n5 & 4) != 0) {
            n2 = 44100;
        }
        if ((n5 & 8) != 0) {
            n3 = 12;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 2;
        }
        if ((n5 & 0x20) != 0) {
            bl = true;
        }
        if ((n5 & 0x40) != 0) {
            bl2 = true;
        }
        this(string, n, n2, n3, n4, bl, bl2);
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannelConfig() {
        return this.channelConfig;
    }

    public final int getByteFormat() {
        return this.byteFormat;
    }

    public final boolean getEnableEchoCanceler() {
        return this.enableEchoCanceler;
    }

    public final boolean getEnableNoiseSuppressor() {
        return this.enableNoiseSuppressor;
    }

    public AudioConfig() {
        this(null, 0, 0, 0, 0, false, false, 127, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/data/AudioConfig$Companion;", "", "()V", "getChannelConfig", "", "nChannel", "getNumOfBytesPerSample", "byteFormat", "getNumberOfChannels", "channelConfig", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNumberOfChannels(int channelConfig) {
            int n;
            switch (channelConfig) {
                case 16: {
                    n = 1;
                    break;
                }
                case 12: {
                    n = 2;
                    break;
                }
                default: {
                    throw new InvalidParameterException(Intrinsics.stringPlus((String)"Audio format not supported: ", (Object)channelConfig));
                }
            }
            return n;
        }

        public final int getChannelConfig(int nChannel) {
            int n;
            switch (nChannel) {
                case 1: {
                    n = 16;
                    break;
                }
                case 2: {
                    n = 12;
                    break;
                }
                default: {
                    throw new InvalidParameterException(Intrinsics.stringPlus((String)"Number of channels not supported: ", (Object)nChannel));
                }
            }
            return n;
        }

        public final int getNumOfBytesPerSample(int byteFormat) {
            int n;
            switch (byteFormat) {
                case 3: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 21: {
                    n = 3;
                    break;
                }
                case 22: {
                    n = 4;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                default: {
                    throw new InvalidParameterException(Intrinsics.stringPlus((String)"Byte format not supported: ", (Object)byteFormat));
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

