/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.streamers;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import com.github.thibaultbee.streampack.data.AudioConfig;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.internal.endpoints.FileWriter;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.ServiceInfo;
import com.github.thibaultbee.streampack.internal.sources.AudioCapture;
import com.github.thibaultbee.streampack.logger.ILogger;
import com.github.thibaultbee.streampack.logger.StreamPackLogger;
import com.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.IFileStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.builders.IFileStreamerBuilder;
import com.github.thibaultbee.streampack.streamers.interfaces.builders.IStreamerBuilder;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0017R(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/thibaultbee/streampack/streamers/AudioOnlyTsFileStreamer;", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/IFileStreamer;", "context", "Landroid/content/Context;", "tsServiceInfo", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "value", "Ljava/io/File;", "file", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "fileWriter", "Lcom/github/thibaultbee/streampack/internal/endpoints/FileWriter;", "startStream", "", "Builder", "sdk_release"})
public final class AudioOnlyTsFileStreamer
extends BaseStreamer
implements IFileStreamer {
    @NotNull
    private final FileWriter fileWriter;

    public AudioOnlyTsFileStreamer(@NotNull Context context, @NotNull ServiceInfo tsServiceInfo, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(context, tsServiceInfo, null, new AudioCapture(logger), false, new FileWriter(logger), logger);
        this.fileWriter = (FileWriter)this.getEndpoint();
    }

    @Override
    @Nullable
    public File getFile() {
        return this.fileWriter.getFile();
    }

    @Override
    public void setFile(@Nullable File value) {
        this.fileWriter.setFile(value);
    }

    @Override
    @RequiresPermission(allOf={"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"})
    public void startStream() {
        super.startStream();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002BI\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0017J\t\u0010\u0016\u001a\u00020\u0004H\u00c2\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u00c2\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c2\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u000eH\u00c2\u0003JM\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\b\u0010\u001d\u001a\u00020\u0001H\u0016J\u0013\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010$\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/github/thibaultbee/streampack/streamers/AudioOnlyTsFileStreamer$Builder;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/builders/IStreamerBuilder;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/builders/IFileStreamerBuilder;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "audioConfig", "Lcom/github/thibaultbee/streampack/data/AudioConfig;", "videoConfig", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "previewSurface", "Landroid/view/Surface;", "file", "Ljava/io/File;", "enableAudio", "", "(Lcom/github/thibaultbee/streampack/logger/ILogger;Lcom/github/thibaultbee/streampack/data/AudioConfig;Lcom/github/thibaultbee/streampack/data/VideoConfig;Landroid/view/Surface;Ljava/io/File;Z)V", "context", "Landroid/content/Context;", "serviceInfo", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;", "build", "Lcom/github/thibaultbee/streampack/streamers/AudioOnlyTsFileStreamer;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "disableAudio", "equals", "other", "", "hashCode", "", "setAudioConfiguration", "setConfiguration", "setContext", "setFile", "setLogger", "setServiceInfo", "setVideoConfiguration", "toString", "", "sdk_release"})
    public static final class Builder
    implements IStreamerBuilder,
    IFileStreamerBuilder {
        @NotNull
        private ILogger logger;
        @Nullable
        private AudioConfig audioConfig;
        @Nullable
        private VideoConfig videoConfig;
        @Nullable
        private Surface previewSurface;
        @Nullable
        private File file;
        private boolean enableAudio;
        private Context context;
        private ServiceInfo serviceInfo;

        public Builder(@NotNull ILogger logger, @Nullable AudioConfig audioConfig, @Nullable VideoConfig videoConfig, @Nullable Surface previewSurface, @Nullable File file, boolean enableAudio) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            this.audioConfig = audioConfig;
            this.videoConfig = videoConfig;
            this.previewSurface = previewSurface;
            this.file = file;
            this.enableAudio = enableAudio;
        }

        public /* synthetic */ Builder(ILogger iLogger, AudioConfig audioConfig, VideoConfig videoConfig, Surface surface, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                iLogger = new StreamPackLogger();
            }
            if ((n & 2) != 0) {
                audioConfig = null;
            }
            if ((n & 4) != 0) {
                videoConfig = null;
            }
            if ((n & 8) != 0) {
                surface = null;
            }
            if ((n & 0x10) != 0) {
                file = null;
            }
            if ((n & 0x20) != 0) {
                bl = true;
            }
            this(iLogger, audioConfig, videoConfig, surface, file, bl);
        }

        @Override
        @NotNull
        public Builder setContext(@NotNull Context context) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Builder $this$setContext_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$setContext_u24lambda_u2d0.context = context;
            return builder;
        }

        @Override
        @NotNull
        public Builder setServiceInfo(@NotNull ServiceInfo serviceInfo) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            Builder $this$setServiceInfo_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$setServiceInfo_u24lambda_u2d1.serviceInfo = serviceInfo;
            return builder;
        }

        @Override
        @NotNull
        public Builder setLogger(@NotNull ILogger logger) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Builder $this$setLogger_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$setLogger_u24lambda_u2d2.logger = logger;
            return builder;
        }

        @Override
        @NotNull
        public Builder setConfiguration(@NotNull AudioConfig audioConfig, @NotNull VideoConfig videoConfig) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
            Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
            Builder $this$setConfiguration_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$setConfiguration_u24lambda_u2d3.audioConfig = audioConfig;
            return builder;
        }

        @Override
        @NotNull
        public Builder setAudioConfiguration(@NotNull AudioConfig audioConfig) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
            Builder $this$setAudioConfiguration_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$setAudioConfiguration_u24lambda_u2d4.audioConfig = audioConfig;
            return builder;
        }

        @Override
        @NotNull
        public Builder setVideoConfiguration(@NotNull VideoConfig videoConfig) {
            Intrinsics.checkNotNullParameter((Object)videoConfig, (String)"videoConfig");
            Builder $this$setVideoConfiguration_u24lambda_u2d5 = this;
            boolean bl = false;
            throw new UnsupportedOperationException("Do not set video configuration on audio only streamer");
        }

        @Override
        @NotNull
        public IStreamerBuilder disableAudio() {
            throw new UnsupportedOperationException("Do not disable audio on audio only streamer");
        }

        @Override
        @NotNull
        public Builder setFile(@NotNull File file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$setFile_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$setFile_u24lambda_u2d6.file = file;
            return builder;
        }

        @Override
        @RequiresPermission(allOf={"android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
        @NotNull
        public AudioOnlyTsFileStreamer build() {
            AudioOnlyTsFileStreamer audioOnlyTsFileStreamer;
            ServiceInfo serviceInfo;
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            if ((serviceInfo = this.serviceInfo) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceInfo");
                serviceInfo = null;
            }
            AudioOnlyTsFileStreamer streamer = audioOnlyTsFileStreamer = new AudioOnlyTsFileStreamer(context, serviceInfo, this.logger);
            boolean bl = false;
            IStreamer.DefaultImpls.configure$default(streamer, this.audioConfig, null, 2, null);
            streamer.setFile(this.file);
            return audioOnlyTsFileStreamer;
        }

        private final ILogger component1() {
            return this.logger;
        }

        private final AudioConfig component2() {
            return this.audioConfig;
        }

        private final VideoConfig component3() {
            return this.videoConfig;
        }

        private final Surface component4() {
            return this.previewSurface;
        }

        private final File component5() {
            return this.file;
        }

        private final boolean component6() {
            return this.enableAudio;
        }

        @NotNull
        public final Builder copy(@NotNull ILogger logger, @Nullable AudioConfig audioConfig, @Nullable VideoConfig videoConfig, @Nullable Surface previewSurface, @Nullable File file, boolean enableAudio) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            return new Builder(logger, audioConfig, videoConfig, previewSurface, file, enableAudio);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, ILogger iLogger, AudioConfig audioConfig, VideoConfig videoConfig, Surface surface, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                iLogger = builder.logger;
            }
            if ((n & 2) != 0) {
                audioConfig = builder.audioConfig;
            }
            if ((n & 4) != 0) {
                videoConfig = builder.videoConfig;
            }
            if ((n & 8) != 0) {
                surface = builder.previewSurface;
            }
            if ((n & 0x10) != 0) {
                file = builder.file;
            }
            if ((n & 0x20) != 0) {
                bl = builder.enableAudio;
            }
            return builder.copy(iLogger, audioConfig, videoConfig, surface, file, bl);
        }

        @NotNull
        public String toString() {
            return "Builder(logger=" + this.logger + ", audioConfig=" + this.audioConfig + ", videoConfig=" + this.videoConfig + ", previewSurface=" + this.previewSurface + ", file=" + this.file + ", enableAudio=" + this.enableAudio + ')';
        }

        public int hashCode() {
            int result = this.logger.hashCode();
            result = result * 31 + (this.audioConfig == null ? 0 : this.audioConfig.hashCode());
            result = result * 31 + (this.videoConfig == null ? 0 : this.videoConfig.hashCode());
            result = result * 31 + (this.previewSurface == null ? 0 : this.previewSurface.hashCode());
            result = result * 31 + (this.file == null ? 0 : this.file.hashCode());
            int n = this.enableAudio ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.logger, (Object)builder.logger)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.audioConfig, (Object)builder.audioConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.videoConfig, (Object)builder.videoConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previewSurface, (Object)builder.previewSurface)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)builder.file)) {
                return false;
            }
            return this.enableAudio == builder.enableAudio;
        }

        public Builder() {
            this(null, null, null, null, null, false, 63, null);
        }
    }
}

