/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.regulator;

import com.github.thibaultbee.srtdroid.models.Stats;
import com.github.thibaultbee.streampack.data.BitrateRegulatorConfig;
import com.github.thibaultbee.streampack.regulator.SrtBitrateRegulator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/github/thibaultbee/streampack/regulator/DefaultSrtBitrateRegulator;", "Lcom/github/thibaultbee/streampack/regulator/SrtBitrateRegulator;", "bitrateRegulatorConfig", "Lcom/github/thibaultbee/streampack/data/BitrateRegulatorConfig;", "onVideoTargetBitrateChange", "Lkotlin/Function1;", "", "", "onAudioTargetBitrateChange", "(Lcom/github/thibaultbee/streampack/data/BitrateRegulatorConfig;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "update", "stats", "Lcom/github/thibaultbee/srtdroid/models/Stats;", "currentVideoBitrate", "currentAudioBitrate", "Companion", "sdk_release"})
public final class DefaultSrtBitrateRegulator
extends SrtBitrateRegulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MINIMUM_DECREASE_THRESHOLD = 100000;
    public static final int MAXIMUM_INCREASE_THRESHOLD = 200000;
    public static final int SEND_PACKET_THRESHOLD = 50;

    public DefaultSrtBitrateRegulator(@NotNull BitrateRegulatorConfig bitrateRegulatorConfig, @NotNull Function1<? super Integer, Unit> onVideoTargetBitrateChange, @NotNull Function1<? super Integer, Unit> onAudioTargetBitrateChange) {
        Intrinsics.checkNotNullParameter((Object)bitrateRegulatorConfig, (String)"bitrateRegulatorConfig");
        Intrinsics.checkNotNullParameter(onVideoTargetBitrateChange, (String)"onVideoTargetBitrateChange");
        Intrinsics.checkNotNullParameter(onAudioTargetBitrateChange, (String)"onAudioTargetBitrateChange");
        super(bitrateRegulatorConfig, onVideoTargetBitrateChange, onAudioTargetBitrateChange);
    }

    @Override
    public void update(@NotNull Stats stats, int currentVideoBitrate, int currentAudioBitrate) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        int estimatedBandwidth = (int)(stats.getMbpsBandwidth() * (double)1000000);
        Comparable comparable = this.getBitrateRegulatorConfig().getVideoBitrateRange().getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"bitrateRegulatorConfig.videoBitrateRange.lower");
        if (currentVideoBitrate > ((Number)((Object)comparable)).intValue()) {
            int newVideoBitrate;
            int n3;
            if (stats.getPktSndLoss() > 0) {
                n2 = currentVideoBitrate * 20 / 100;
                n = 100000;
                n3 = currentVideoBitrate - Math.max(n2, n);
            } else if (stats.getPktSndBuf() > 50) {
                n2 = currentVideoBitrate * 10 / 100;
                n = 100000;
                n3 = currentVideoBitrate - Math.max(n2, n);
            } else {
                n3 = newVideoBitrate = currentVideoBitrate + currentAudioBitrate > estimatedBandwidth ? estimatedBandwidth - currentAudioBitrate : 0;
            }
            if (newVideoBitrate != 0) {
                Function1<Integer, Unit> function1 = this.getOnVideoTargetBitrateChange();
                Comparable comparable2 = this.getBitrateRegulatorConfig().getVideoBitrateRange().getLower();
                Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"bitrateRegulatorConfig.videoBitrateRange.lower");
                int n4 = ((Number)((Object)comparable2)).intValue();
                function1.invoke((Object)Math.max(newVideoBitrate, n4));
                return;
            }
        }
        Comparable newVideoBitrate = this.getBitrateRegulatorConfig().getVideoBitrateRange().getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)newVideoBitrate, (String)"bitrateRegulatorConfig.videoBitrateRange.upper");
        if (currentVideoBitrate < ((Number)((Object)newVideoBitrate)).intValue()) {
            int n5;
            if (currentVideoBitrate + currentAudioBitrate < estimatedBandwidth) {
                n2 = (((Number)((Object)this.getBitrateRegulatorConfig().getVideoBitrateRange().getUpper())).intValue() - currentVideoBitrate) * 50 / 100;
                n = 200000;
                n5 = currentVideoBitrate + Math.min(n2, n);
            } else {
                n5 = newVideoBitrate = 0;
            }
            if (newVideoBitrate != 0) {
                Function1<Integer, Unit> function1 = this.getOnVideoTargetBitrateChange();
                Comparable comparable3 = this.getBitrateRegulatorConfig().getVideoBitrateRange().getLower();
                Intrinsics.checkNotNullExpressionValue((Object)comparable3, (String)"bitrateRegulatorConfig.videoBitrateRange.lower");
                int n6 = ((Number)((Object)comparable3)).intValue();
                function1.invoke((Object)Math.max(newVideoBitrate, n6));
                return;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/thibaultbee/streampack/regulator/DefaultSrtBitrateRegulator$Companion;", "", "()V", "MAXIMUM_INCREASE_THRESHOLD", "", "MINIMUM_DECREASE_THRESHOLD", "SEND_PACKET_THRESHOLD", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

