/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.endpoints;

import com.github.thibaultbee.streampack.internal.data.Packet;
import com.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import com.github.thibaultbee.streampack.logger.ILogger;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/github/thibaultbee/streampack/internal/endpoints/FileWriter;", "Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "value", "Ljava/io/File;", "file", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "fileOutputStream", "Ljava/io/FileOutputStream;", "getLogger", "()Lcom/github/thibaultbee/streampack/logger/ILogger;", "configure", "", "startBitrate", "", "release", "startStream", "stopStream", "write", "packet", "Lcom/github/thibaultbee/streampack/internal/data/Packet;", "sdk_release"})
public final class FileWriter
implements IEndpoint {
    @NotNull
    private final ILogger logger;
    @Nullable
    private File file;
    @Nullable
    private FileOutputStream fileOutputStream;

    public FileWriter(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@Nullable File value) {
        File file = value;
        if (file != null) {
            File it = file;
            boolean bl = false;
            this.fileOutputStream = new FileOutputStream(value, false);
        }
        this.file = value;
    }

    @Override
    public void startStream() {
        if (this.fileOutputStream == null) {
            throw new UnsupportedOperationException("Set a file before trying to write it");
        }
    }

    @Override
    public void configure(int startBitrate) {
    }

    @Override
    public void write(@NotNull Packet packet) {
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        FileOutputStream fileOutputStream = this.fileOutputStream;
        if (fileOutputStream == null) {
            n2 = null;
        } else {
            FileChannel fileChannel = fileOutputStream.getChannel();
            n2 = n = fileChannel == null ? null : Integer.valueOf(fileChannel.write(packet.getBuffer()));
        }
        if (n == null) {
            throw new UnsupportedOperationException("Set a file before trying to write it");
        }
        n.intValue();
    }

    @Override
    public void stopStream() {
        FileOutputStream fileOutputStream = this.fileOutputStream;
        if (fileOutputStream != null) {
            FileChannel fileChannel = fileOutputStream.getChannel();
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
    }

    @Override
    public void release() {
    }
}

