/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.encoders.format.aac;

import android.media.MediaFormat;
import com.github.thibaultbee.streampack.internal.muxers.ts.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\t\u0010\r\u001a\u00020\bH\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/format/aac/Adts;", "", "format", "Landroid/media/MediaFormat;", "payloadLength", "", "(Landroid/media/MediaFormat;I)V", "protectionAbsent", "", "sampleRate", "channelCount", "(ZIII)V", "channelConfiguration", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "samplingFrequencyIndex", "samplingFrequency", "toByteBuffer", "Ljava/nio/ByteBuffer;", "toString", "", "sdk_release"})
public final class Adts {
    private final boolean protectionAbsent;
    private final int sampleRate;
    private final int channelCount;
    private final int payloadLength;

    public Adts(boolean protectionAbsent, int sampleRate, int channelCount, int payloadLength) {
        this.protectionAbsent = protectionAbsent;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.payloadLength = payloadLength;
    }

    public Adts(@NotNull MediaFormat format, int payloadLength) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this(true, format.getInteger("sample-rate"), format.getInteger("channel-count"), payloadLength);
    }

    private final int samplingFrequencyIndex(int samplingFrequency) {
        int n;
        switch (samplingFrequency) {
            case 96000: {
                n = 0;
                break;
            }
            case 88200: {
                n = 1;
                break;
            }
            case 64000: {
                n = 2;
                break;
            }
            case 48000: {
                n = 3;
                break;
            }
            case 44100: {
                n = 4;
                break;
            }
            case 32000: {
                n = 5;
                break;
            }
            case 24000: {
                n = 6;
                break;
            }
            case 22050: {
                n = 7;
                break;
            }
            case 16000: {
                n = 8;
                break;
            }
            case 12000: {
                n = 9;
                break;
            }
            case 11025: {
                n = 10;
                break;
            }
            case 8000: {
                n = 11;
                break;
            }
            case 7350: {
                n = 12;
                break;
            }
            default: {
                n = 15;
            }
        }
        return n;
    }

    private final int channelConfiguration(int channelCount) {
        int n;
        switch (channelCount) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        ByteBuffer adts = ByteBuffer.allocate(this.protectionAbsent ? 7 : 9);
        Intrinsics.checkNotNullExpressionValue((Object)adts, (String)"adts");
        ExtensionsKt.putShort(adts, 0xFFF0 | ExtensionsKt.toInt(this.protectionAbsent));
        int samplingFrequencyIndex = this.samplingFrequencyIndex(this.sampleRate);
        int channelConfiguration = this.channelConfiguration(this.channelCount);
        int frameLength = this.payloadLength + (this.protectionAbsent ? 7 : 9);
        adts.putInt(0x40000000 | samplingFrequencyIndex << 26 | channelConfiguration << 22 | frameLength << 5 | 0x1F);
        ExtensionsKt.put(adts, 252);
        adts.rewind();
        return adts;
    }

    private final boolean component1() {
        return this.protectionAbsent;
    }

    private final int component2() {
        return this.sampleRate;
    }

    private final int component3() {
        return this.channelCount;
    }

    private final int component4() {
        return this.payloadLength;
    }

    @NotNull
    public final Adts copy(boolean protectionAbsent, int sampleRate, int channelCount, int payloadLength) {
        return new Adts(protectionAbsent, sampleRate, channelCount, payloadLength);
    }

    public static /* synthetic */ Adts copy$default(Adts adts, boolean bl, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            bl = adts.protectionAbsent;
        }
        if ((n4 & 2) != 0) {
            n = adts.sampleRate;
        }
        if ((n4 & 4) != 0) {
            n2 = adts.channelCount;
        }
        if ((n4 & 8) != 0) {
            n3 = adts.payloadLength;
        }
        return adts.copy(bl, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "Adts(protectionAbsent=" + this.protectionAbsent + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ", payloadLength=" + this.payloadLength + ')';
    }

    public int hashCode() {
        int n = this.protectionAbsent ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + Integer.hashCode(this.sampleRate);
        result = result * 31 + Integer.hashCode(this.channelCount);
        result = result * 31 + Integer.hashCode(this.payloadLength);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Adts)) {
            return false;
        }
        Adts adts = (Adts)other;
        if (this.protectionAbsent != adts.protectionAbsent) {
            return false;
        }
        if (this.sampleRate != adts.sampleRate) {
            return false;
        }
        if (this.channelCount != adts.channelCount) {
            return false;
        }
        return this.payloadLength == adts.payloadLength;
    }
}

