/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.data;

import com.github.thibaultbee.streampack.internal.utils.AVExtensionsKt;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001b\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0002#$B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003JO\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/github/thibaultbee/streampack/data/AudioConfig;", "", "mimeType", "", "startBitrate", "", "sampleRate", "channelConfig", "byteFormat", "enableEchoCanceler", "", "enableNoiseSuppressor", "(Ljava/lang/String;IIIIZZ)V", "getByteFormat", "()I", "getChannelConfig", "getEnableEchoCanceler", "()Z", "getEnableNoiseSuppressor", "getMimeType", "()Ljava/lang/String;", "getSampleRate", "getStartBitrate", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "Builder", "Companion", "sdk_release"})
public final class AudioConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mimeType;
    private final int startBitrate;
    private final int sampleRate;
    private final int channelConfig;
    private final int byteFormat;
    private final boolean enableEchoCanceler;
    private final boolean enableNoiseSuppressor;

    public AudioConfig(@NotNull String mimeType, int startBitrate, int sampleRate, int channelConfig, int byteFormat, boolean enableEchoCanceler, boolean enableNoiseSuppressor) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.mimeType = mimeType;
        this.startBitrate = startBitrate;
        this.sampleRate = sampleRate;
        this.channelConfig = channelConfig;
        this.byteFormat = byteFormat;
        this.enableEchoCanceler = enableEchoCanceler;
        this.enableNoiseSuppressor = enableNoiseSuppressor;
        if (!AVExtensionsKt.isAudio(this.mimeType)) {
            boolean bl = false;
            String string = "Mime Type must be audio";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    public final int getStartBitrate() {
        return this.startBitrate;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannelConfig() {
        return this.channelConfig;
    }

    public final int getByteFormat() {
        return this.byteFormat;
    }

    public final boolean getEnableEchoCanceler() {
        return this.enableEchoCanceler;
    }

    public final boolean getEnableNoiseSuppressor() {
        return this.enableNoiseSuppressor;
    }

    @NotNull
    public final String component1() {
        return this.mimeType;
    }

    public final int component2() {
        return this.startBitrate;
    }

    public final int component3() {
        return this.sampleRate;
    }

    public final int component4() {
        return this.channelConfig;
    }

    public final int component5() {
        return this.byteFormat;
    }

    public final boolean component6() {
        return this.enableEchoCanceler;
    }

    public final boolean component7() {
        return this.enableNoiseSuppressor;
    }

    @NotNull
    public final AudioConfig copy(@NotNull String mimeType, int startBitrate, int sampleRate, int channelConfig, int byteFormat, boolean enableEchoCanceler, boolean enableNoiseSuppressor) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return new AudioConfig(mimeType, startBitrate, sampleRate, channelConfig, byteFormat, enableEchoCanceler, enableNoiseSuppressor);
    }

    public static /* synthetic */ AudioConfig copy$default(AudioConfig audioConfig, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, Object object) {
        if ((n5 & 1) != 0) {
            string = audioConfig.mimeType;
        }
        if ((n5 & 2) != 0) {
            n = audioConfig.startBitrate;
        }
        if ((n5 & 4) != 0) {
            n2 = audioConfig.sampleRate;
        }
        if ((n5 & 8) != 0) {
            n3 = audioConfig.channelConfig;
        }
        if ((n5 & 0x10) != 0) {
            n4 = audioConfig.byteFormat;
        }
        if ((n5 & 0x20) != 0) {
            bl = audioConfig.enableEchoCanceler;
        }
        if ((n5 & 0x40) != 0) {
            bl2 = audioConfig.enableNoiseSuppressor;
        }
        return audioConfig.copy(string, n, n2, n3, n4, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "AudioConfig(mimeType=" + this.mimeType + ", startBitrate=" + this.startBitrate + ", sampleRate=" + this.sampleRate + ", channelConfig=" + this.channelConfig + ", byteFormat=" + this.byteFormat + ", enableEchoCanceler=" + this.enableEchoCanceler + ", enableNoiseSuppressor=" + this.enableNoiseSuppressor + ')';
    }

    public int hashCode() {
        int result = this.mimeType.hashCode();
        result = result * 31 + Integer.hashCode(this.startBitrate);
        result = result * 31 + Integer.hashCode(this.sampleRate);
        result = result * 31 + Integer.hashCode(this.channelConfig);
        result = result * 31 + Integer.hashCode(this.byteFormat);
        int n = this.enableEchoCanceler ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.enableNoiseSuppressor ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioConfig)) {
            return false;
        }
        AudioConfig audioConfig = (AudioConfig)other;
        if (!Intrinsics.areEqual((Object)this.mimeType, (Object)audioConfig.mimeType)) {
            return false;
        }
        if (this.startBitrate != audioConfig.startBitrate) {
            return false;
        }
        if (this.sampleRate != audioConfig.sampleRate) {
            return false;
        }
        if (this.channelConfig != audioConfig.channelConfig) {
            return false;
        }
        if (this.byteFormat != audioConfig.byteFormat) {
            return false;
        }
        if (this.enableEchoCanceler != audioConfig.enableEchoCanceler) {
            return false;
        }
        return this.enableNoiseSuppressor == audioConfig.enableNoiseSuppressor;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/github/thibaultbee/streampack/data/AudioConfig$Companion;", "", "()V", "getChannelConfig", "", "nChannel", "getNumberOfChannels", "channelConfig", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNumberOfChannels(int channelConfig) {
            int n;
            switch (channelConfig) {
                case 16: {
                    n = 1;
                    break;
                }
                case 12: {
                    n = 2;
                    break;
                }
                default: {
                    throw new InvalidParameterException(Intrinsics.stringPlus((String)"Audio format not supported: ", (Object)channelConfig));
                }
            }
            return n;
        }

        public final int getChannelConfig(int nChannel) {
            int n;
            switch (nChannel) {
                case 1: {
                    n = 16;
                    break;
                }
                case 2: {
                    n = 12;
                    break;
                }
                default: {
                    throw new InvalidParameterException(Intrinsics.stringPlus((String)"Number of channels not supported: ", (Object)nChannel));
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c2\u0003J\t\u0010\u0015\u001a\u00020\nH\u00c2\u0003JO\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J\u0013\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/thibaultbee/streampack/data/AudioConfig$Builder;", "", "mimeType", "", "startBitrate", "", "sampleRate", "nChannel", "byteFormat", "enableEchoCanceler", "", "enableNoiseSuppressor", "(Ljava/lang/String;IIIIZZ)V", "build", "Lcom/github/thibaultbee/streampack/data/AudioConfig;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "setByteFormat", "setEchoCanceler", "enable", "setMimeType", "setNoiseSuppressor", "setNumberOfChannel", "setSampleRate", "setStartBitrate", "toString", "sdk_release"})
    public static final class Builder {
        @NotNull
        private String mimeType;
        private int startBitrate;
        private int sampleRate;
        private int nChannel;
        private int byteFormat;
        private boolean enableEchoCanceler;
        private boolean enableNoiseSuppressor;

        public Builder(@NotNull String mimeType, int startBitrate, int sampleRate, int nChannel, int byteFormat, boolean enableEchoCanceler, boolean enableNoiseSuppressor) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            this.mimeType = mimeType;
            this.startBitrate = startBitrate;
            this.sampleRate = sampleRate;
            this.nChannel = nChannel;
            this.byteFormat = byteFormat;
            this.enableEchoCanceler = enableEchoCanceler;
            this.enableNoiseSuppressor = enableNoiseSuppressor;
        }

        public /* synthetic */ Builder(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                string = "audio/mp4a-latm";
            }
            if ((n5 & 2) != 0) {
                n = 128000;
            }
            if ((n5 & 4) != 0) {
                n2 = 44100;
            }
            if ((n5 & 8) != 0) {
                n3 = 2;
            }
            if ((n5 & 0x10) != 0) {
                n4 = 2;
            }
            if ((n5 & 0x20) != 0) {
                bl = false;
            }
            if ((n5 & 0x40) != 0) {
                bl2 = false;
            }
            this(string, n, n2, n3, n4, bl, bl2);
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Builder $this$setMimeType_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$setMimeType_u24lambda_u2d0.mimeType = mimeType;
            return builder;
        }

        @NotNull
        public final Builder setStartBitrate(int startBitrate) {
            Builder builder;
            Builder $this$setStartBitrate_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$setStartBitrate_u24lambda_u2d1.startBitrate = startBitrate;
            return builder;
        }

        @NotNull
        public final Builder setSampleRate(int sampleRate) {
            Builder builder;
            Builder $this$setSampleRate_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$setSampleRate_u24lambda_u2d2.sampleRate = sampleRate;
            return builder;
        }

        @NotNull
        public final Builder setNumberOfChannel(int nChannel) {
            Builder builder;
            Builder $this$setNumberOfChannel_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$setNumberOfChannel_u24lambda_u2d3.nChannel = nChannel;
            return builder;
        }

        @NotNull
        public final Builder setByteFormat(int byteFormat) {
            Builder builder;
            Builder $this$setByteFormat_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$setByteFormat_u24lambda_u2d4.byteFormat = byteFormat;
            return builder;
        }

        @NotNull
        public final Builder enableEchoCanceler() {
            Builder builder;
            Builder $this$enableEchoCanceler_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$enableEchoCanceler_u24lambda_u2d5.enableEchoCanceler = true;
            return builder;
        }

        @NotNull
        public final Builder setEchoCanceler(boolean enable) {
            Builder builder;
            Builder $this$setEchoCanceler_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$setEchoCanceler_u24lambda_u2d6.enableEchoCanceler = enable;
            return builder;
        }

        @NotNull
        public final Builder enableNoiseSuppressor() {
            Builder builder;
            Builder $this$enableNoiseSuppressor_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            $this$enableNoiseSuppressor_u24lambda_u2d7.enableNoiseSuppressor = true;
            return builder;
        }

        @NotNull
        public final Builder setNoiseSuppressor(boolean enable) {
            Builder builder;
            Builder $this$setNoiseSuppressor_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$setNoiseSuppressor_u24lambda_u2d8.enableNoiseSuppressor = enable;
            return builder;
        }

        @NotNull
        public final AudioConfig build() {
            return new AudioConfig(this.mimeType, this.startBitrate, this.sampleRate, Companion.getChannelConfig(this.nChannel), this.byteFormat, this.enableEchoCanceler, this.enableNoiseSuppressor);
        }

        private final String component1() {
            return this.mimeType;
        }

        private final int component2() {
            return this.startBitrate;
        }

        private final int component3() {
            return this.sampleRate;
        }

        private final int component4() {
            return this.nChannel;
        }

        private final int component5() {
            return this.byteFormat;
        }

        private final boolean component6() {
            return this.enableEchoCanceler;
        }

        private final boolean component7() {
            return this.enableNoiseSuppressor;
        }

        @NotNull
        public final Builder copy(@NotNull String mimeType, int startBitrate, int sampleRate, int nChannel, int byteFormat, boolean enableEchoCanceler, boolean enableNoiseSuppressor) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new Builder(mimeType, startBitrate, sampleRate, nChannel, byteFormat, enableEchoCanceler, enableNoiseSuppressor);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = builder.mimeType;
            }
            if ((n5 & 2) != 0) {
                n = builder.startBitrate;
            }
            if ((n5 & 4) != 0) {
                n2 = builder.sampleRate;
            }
            if ((n5 & 8) != 0) {
                n3 = builder.nChannel;
            }
            if ((n5 & 0x10) != 0) {
                n4 = builder.byteFormat;
            }
            if ((n5 & 0x20) != 0) {
                bl = builder.enableEchoCanceler;
            }
            if ((n5 & 0x40) != 0) {
                bl2 = builder.enableNoiseSuppressor;
            }
            return builder.copy(string, n, n2, n3, n4, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Builder(mimeType=" + this.mimeType + ", startBitrate=" + this.startBitrate + ", sampleRate=" + this.sampleRate + ", nChannel=" + this.nChannel + ", byteFormat=" + this.byteFormat + ", enableEchoCanceler=" + this.enableEchoCanceler + ", enableNoiseSuppressor=" + this.enableNoiseSuppressor + ')';
        }

        public int hashCode() {
            int result = this.mimeType.hashCode();
            result = result * 31 + Integer.hashCode(this.startBitrate);
            result = result * 31 + Integer.hashCode(this.sampleRate);
            result = result * 31 + Integer.hashCode(this.nChannel);
            result = result * 31 + Integer.hashCode(this.byteFormat);
            int n = this.enableEchoCanceler ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.enableNoiseSuppressor ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.mimeType, (Object)builder.mimeType)) {
                return false;
            }
            if (this.startBitrate != builder.startBitrate) {
                return false;
            }
            if (this.sampleRate != builder.sampleRate) {
                return false;
            }
            if (this.nChannel != builder.nChannel) {
                return false;
            }
            if (this.byteFormat != builder.byteFormat) {
                return false;
            }
            if (this.enableEchoCanceler != builder.enableEchoCanceler) {
                return false;
            }
            return this.enableNoiseSuppressor == builder.enableNoiseSuppressor;
        }

        public Builder() {
            this(null, 0, 0, 0, 0, false, false, 127, null);
        }
    }
}

