/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.sources.camera;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Range;
import android.util.Size;
import com.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006*\u00020\u0002\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"getCameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "Landroid/content/Context;", "cameraId", "", "getCameraFpsList", "", "Landroid/util/Range;", "", "getCameraOutputStreamSizes", "Landroid/util/Size;", "sdk_release"})
public final class InternalCameraExtensionsKt {
    @NotNull
    public static final CameraCharacteristics getCameraCharacteristics(@NotNull Context $this$getCameraCharacteristics, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraCharacteristics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Object object = $this$getCameraCharacteristics.getSystemService("camera");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        CameraManager cameraManager = (CameraManager)object;
        object = cameraManager.getCameraCharacteristics(cameraId2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cameraManager.getCameraCharacteristics(cameraId)");
        return object;
    }

    @NotNull
    public static final List<Size> getCameraOutputStreamSizes(@NotNull Context $this$getCameraOutputStreamSizes) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputStreamSizes, (String)"<this>");
        List<String> cameraIdList = CameraExtensionsKt.getCameraList($this$getCameraOutputStreamSizes);
        boolean bl = false;
        Set resolutionSet = new LinkedHashSet();
        Iterable $this$forEach$iv = cameraIdList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String cameraId2 = (String)element$iv;
            boolean bl2 = false;
            resolutionSet.addAll((Collection)InternalCameraExtensionsKt.getCameraOutputStreamSizes($this$getCameraOutputStreamSizes, cameraId2));
        }
        return CollectionsKt.toList((Iterable)resolutionSet);
    }

    @NotNull
    public static final List<Size> getCameraOutputStreamSizes(@NotNull Context $this$getCameraOutputStreamSizes, @NotNull String cameraId2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputStreamSizes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)InternalCameraExtensionsKt.getCameraCharacteristics($this$getCameraOutputStreamSizes, cameraId2).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        List list = streamConfigurationMap == null ? null : ((objectArray = streamConfigurationMap.getOutputSizes(35)) == null ? null : ArraysKt.toList((Object[])objectArray));
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @NotNull
    public static final List<Range<Integer>> getCameraFpsList(@NotNull Context $this$getCameraFpsList, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraFpsList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Object[] objectArray = (Range[])InternalCameraExtensionsKt.getCameraCharacteristics($this$getCameraFpsList, cameraId2).get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        List list = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }
}

