/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.bitbuffer;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.CharCodeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 L2\u00020\u0001:\u0001LB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u00020\u0000J\b\u00104\u001a\u000202H\u0002J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\rH\u0002J\u0006\u00107\u001a\u00020\u001dJ\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010;\u001a\u00020<J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<J\u000e\u0010!\u001a\u00020\r2\u0006\u0010;\u001a\u00020<J\u000e\u0010#\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020<J\u000e\u0010/\u001a\u00020.2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u001dJ\u0018\u0010?\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u00072\b\b\u0002\u00106\u001a\u00020\rJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u000209J\"\u0010?\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u00112\b\b\u0002\u00106\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020<J\"\u0010?\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00152\b\b\u0002\u00106\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020<J\"\u0010?\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00192\b\b\u0002\u00106\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020<J\"\u0010?\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\r2\b\b\u0002\u00106\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020<J\"\u0010?\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u000b2\b\b\u0002\u00106\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020<J\"\u0010?\u001a\u00020\u00002\u0006\u0010G\u001a\u00020.2\b\b\u0002\u00106\u001a\u00020\r2\b\b\u0002\u0010;\u001a\u00020<J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010G\u001a\u00020HJ\u0018\u0010I\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\rH\u0002J\u0016\u0010J\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bJ\u0006\u0010K\u001a\u00020\u0003R\u0016\u0010\u0002\u001a\n \u0005*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000fR\u0011\u0010\"\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u0010&\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000fR\u000e\u0010,\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006M"}, d2={"Lcom/github/thibaultbee/streampack/internal/bitbuffer/BitBuffer;", "", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "kotlin.jvm.PlatformType", "byte", "", "getByte", "()B", "cache", "", "capacity", "", "getCapacity", "()I", "char", "", "getChar", "()C", "double", "", "getDouble", "()D", "float", "", "getFloat", "()F", "hasRemaining", "", "getHasRemaining", "()Z", "int", "getInt", "long", "getLong", "()J", "value", "position", "getPosition", "setPosition", "(I)V", "remaining", "getRemaining", "remainingBits", "short", "", "getShort", "()S", "compact", "", "flip", "flushCache", "getBits", "numBits", "getBoolean", "getBytes", "", "n", "order", "Ljava/nio/ByteOrder;", "getValue", "maxValue", "put", "src", "b", "c", "d", "f", "i", "l", "s", "", "putBits", "putValue", "toByteBuffer", "Companion", "sdk_release"})
public final class BitBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ByteBuffer buffer;
    private int remainingBits;
    private long cache;
    @NotNull
    private static final long[] MASKS = new long[65];

    private BitBuffer(ByteBuffer buffer) {
        this.buffer = buffer.order(ByteOrder.BIG_ENDIAN);
        this.remainingBits = 64;
    }

    private final BitBuffer putBits(long value, int numBits) {
        if (this.remainingBits < numBits) {
            int upperHalfBits = numBits - this.remainingBits;
            this.cache |= value >> this.remainingBits & MASKS[this.remainingBits];
            this.buffer.putLong(this.cache);
            this.remainingBits = 64 - upperHalfBits;
            this.cache = (value & MASKS[upperHalfBits]) << this.remainingBits;
        } else {
            this.cache |= (value & MASKS[numBits]) << this.remainingBits - numBits;
            BitBuffer bitBuffer = this;
            bitBuffer.remainingBits -= numBits;
        }
        return this;
    }

    private final void flushCache() {
        this.buffer.putLong(this.cache);
        this.cache = 0L;
        this.remainingBits = 64;
    }

    @NotNull
    public final BitBuffer put(boolean b) {
        return this.putBits(b ? 1L : 0L, 1);
    }

    @NotNull
    public final BitBuffer put(byte b, int numBits) {
        return this.putBits(b, numBits);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, byte by, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8;
        }
        return bitBuffer.put(by, n);
    }

    @NotNull
    public final BitBuffer put(char c, int numBits, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        char c2 = Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Character.reverseBytes(c) : c;
        boolean bl = false;
        return this.putBits(c2, numBits);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, char c, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 16;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        return bitBuffer.put(c, n, byteOrder);
    }

    @NotNull
    public final BitBuffer put(double d, int numBits, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return this.put(Double.doubleToRawLongBits(d), numBits, order);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, double d, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 64;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        return bitBuffer.put(d, n, byteOrder);
    }

    @NotNull
    public final BitBuffer put(float f, int numBits, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return this.put(Float.floatToRawIntBits(f), numBits, order);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, float f, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 32;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        return bitBuffer.put(f, n, byteOrder);
    }

    @NotNull
    public final BitBuffer put(int i, int numBits, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return this.putBits(Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Integer.reverseBytes(i) : i, numBits);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, int n, int n2, ByteOrder byteOrder, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 32;
        }
        if ((n3 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        return bitBuffer.put(n, n2, byteOrder);
    }

    @NotNull
    public final BitBuffer put(long l, int numBits, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return this.putBits(Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Long.reverseBytes(l) : l, numBits);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, long l, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 64;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        return bitBuffer.put(l, n, byteOrder);
    }

    @NotNull
    public final BitBuffer put(short s, int numBits, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return this.putBits(Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Short.reverseBytes(s) : s, numBits);
    }

    public static /* synthetic */ BitBuffer put$default(BitBuffer bitBuffer, short s, int n, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 16;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        return bitBuffer.put(s, n, byteOrder);
    }

    @NotNull
    public final BitBuffer put(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = s;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        for (byte c : byArray) {
            BitBuffer.put$default(this, c, 0, 2, null);
        }
        return this;
    }

    @NotNull
    public final BitBuffer put(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (this.remainingBits % 8 == 0) {
            int numRewindBytes = this.remainingBits / 8;
            this.flushCache();
            this.buffer.position(this.buffer.position() - numRewindBytes);
            this.buffer.put(src);
        } else {
            for (byte b : src) {
                BitBuffer.put$default(this, b, 0, 2, null);
            }
        }
        return this;
    }

    @NotNull
    public final BitBuffer put(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (this.remainingBits % 8 == 0) {
            int numRewindBytes = this.remainingBits / 8;
            this.flushCache();
            this.buffer.position(this.buffer.position() - numRewindBytes);
            this.buffer.put(src);
        } else {
            while (src.hasRemaining()) {
                BitBuffer.put$default(this, src.get(), 0, 2, null);
            }
        }
        return this;
    }

    @NotNull
    public final BitBuffer putValue(long value, long maxValue) throws IllegalArgumentException {
        boolean bl = maxValue >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxValue must be positive!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        bl = Math.abs(value) <= maxValue;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "value must be less than or equal to maxValue!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long l = maxValue;
        boolean bl6 = false;
        int numBits = 64 - Long.numberOfLeadingZeros(l) + 1;
        return this.putBits(value, numBits);
    }

    @NotNull
    public final BitBuffer flip() {
        if (this.remainingBits != 64) {
            this.buffer.putLong(this.cache);
        }
        this.buffer.clear();
        this.remainingBits = 0;
        return this;
    }

    private final long getBits(int numBits) {
        long value = 0L;
        if (this.remainingBits < numBits) {
            value = this.cache & MASKS[this.remainingBits];
            this.cache = this.buffer.getLong();
            int difference = numBits - this.remainingBits;
            value |= (this.cache & MASKS[difference]) << this.remainingBits;
            this.cache >>= difference;
            this.remainingBits = 64 - difference;
        } else {
            value = this.cache & MASKS[numBits];
            this.cache >>= numBits;
            BitBuffer bitBuffer = this;
            bitBuffer.remainingBits -= numBits;
        }
        return value;
    }

    public final boolean getBoolean() {
        return this.getBits(1) != 0L;
    }

    public final byte getByte() {
        return (byte)this.getBits(8);
    }

    @NotNull
    public final byte[] getBytes(int n) {
        int n2 = 0;
        byte[] array = new byte[n];
        int n3 = array.length + -1;
        if (n2 <= n3) {
            do {
                int i = n2++;
                array[i] = this.getByte();
            } while (n2 <= n3);
        }
        return array;
    }

    public final char getChar() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        return this.getChar(byteOrder);
    }

    public final char getChar(@NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        int n = (int)this.getBits(16);
        boolean bl = false;
        if (n < CharCodeKt.access$getCode$p((char)'\u0000') || n > CharCodeKt.access$getCode$p((char)'\uffff')) {
            throw (Throwable)new IllegalArgumentException("Invalid Char code: " + n);
        }
        char value = (char)n;
        return Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Character.reverseBytes(value) : value;
    }

    public final double getDouble() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        return this.getDouble(byteOrder);
    }

    public final double getDouble(@NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return Double.longBitsToDouble(this.getLong(order));
    }

    public final float getFloat() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        return this.getFloat(byteOrder);
    }

    public final float getFloat(@NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        return Float.intBitsToFloat(this.getInt(order));
    }

    public final int getInt() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        return this.getInt(byteOrder);
    }

    public final int getInt(@NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        int value = (int)this.getBits(32);
        return Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Integer.reverseBytes(value) : value;
    }

    public final long getLong() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        return this.getLong(byteOrder);
    }

    public final long getLong(@NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        long value = this.getBits(64);
        return Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Long.reverseBytes(value) : value;
    }

    public final short getShort() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"LITTLE_ENDIAN");
        return this.getShort(byteOrder);
    }

    public final short getShort(@NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        short value = (short)this.getBits(16);
        return Intrinsics.areEqual((Object)order, (Object)ByteOrder.BIG_ENDIAN) ? Short.reverseBytes(value) : value;
    }

    public final long getValue(long maxValue) {
        boolean bl = maxValue >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxValue must be positive!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long l = maxValue;
        boolean bl5 = false;
        int numBits = 64 - Long.numberOfLeadingZeros(l) + 1;
        int unused = 64 - numBits;
        return this.getBits(numBits) << unused >> unused;
    }

    public final int getCapacity() {
        return this.buffer.capacity();
    }

    public final int getPosition() {
        return this.buffer.position();
    }

    public final void setPosition(int value) {
        this.flushCache();
        this.buffer.position(value);
    }

    public final int getRemaining() {
        return this.buffer.remaining() - 7 - (64 - this.remainingBits + 7) / 8;
    }

    public final boolean getHasRemaining() {
        return this.getRemaining() != 0;
    }

    public final void compact() {
        this.buffer.compact();
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        this.buffer.putLong(this.cache).rewind();
        this.buffer.limit(this.buffer.capacity() - 8);
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        return byteBuffer;
    }

    public /* synthetic */ BitBuffer(ByteBuffer buffer, DefaultConstructorMarker $constructor_marker) {
        this(buffer);
    }

    static {
        int n = 0;
        int n2 = MASKS.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                BitBuffer.MASKS[i] = BigInteger.valueOf(2L).pow(i).subtract(BigInteger.ONE).longValue();
            } while (n <= n2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/thibaultbee/streampack/internal/bitbuffer/BitBuffer$Companion;", "", "()V", "MASKS", "", "allocate", "Lcom/github/thibaultbee/streampack/internal/bitbuffer/BitBuffer;", "capacity", "", "bitCapacity", "", "allocateDirect", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BitBuffer allocate(int capacity) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(capacity + 8);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(capacity + Long.SIZE_BYTES)");
            return new BitBuffer(byteBuffer, null);
        }

        @NotNull
        public final BitBuffer allocate(long bitCapacity) {
            return this.allocate((int)((bitCapacity + (long)7) / (long)8));
        }

        @NotNull
        public final BitBuffer allocateDirect(int capacity) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(capacity + 8);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(capacity + Long.SIZE_BYTES)");
            return new BitBuffer(byteBuffer, null);
        }

        @NotNull
        public final BitBuffer allocateDirect(long bitCapacity) {
            return this.allocateDirect((int)((bitCapacity + (long)7) / (long)8));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

