/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.data;

import android.os.Build;
import android.util.Size;
import com.github.thibaultbee.streampack.internal.utils.AVExtensionsKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0001!B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\""}, d2={"Lcom/github/thibaultbee/streampack/data/VideoConfig;", "", "mimeType", "", "startBitrate", "", "resolution", "Landroid/util/Size;", "fps", "profile", "level", "(Ljava/lang/String;ILandroid/util/Size;III)V", "getFps", "()I", "getLevel", "getMimeType", "()Ljava/lang/String;", "getProfile", "getResolution", "()Landroid/util/Size;", "getStartBitrate", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "Builder", "sdk_release"})
public final class VideoConfig {
    @NotNull
    private final String mimeType;
    private final int startBitrate;
    @NotNull
    private final Size resolution;
    private final int fps;
    private final int profile;
    private final int level;

    public VideoConfig(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, int profile, int level) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        this.mimeType = mimeType;
        this.startBitrate = startBitrate;
        this.resolution = resolution;
        this.fps = fps;
        this.profile = profile;
        this.level = level;
        boolean bl = AVExtensionsKt.isVideo(this.mimeType);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Mime Type must be video";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    public final int getStartBitrate() {
        return this.startBitrate;
    }

    @NotNull
    public final Size getResolution() {
        return this.resolution;
    }

    public final int getFps() {
        return this.fps;
    }

    public final int getProfile() {
        return this.profile;
    }

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public final String component1() {
        return this.mimeType;
    }

    public final int component2() {
        return this.startBitrate;
    }

    @NotNull
    public final Size component3() {
        return this.resolution;
    }

    public final int component4() {
        return this.fps;
    }

    public final int component5() {
        return this.profile;
    }

    public final int component6() {
        return this.level;
    }

    @NotNull
    public final VideoConfig copy(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, int profile, int level) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        return new VideoConfig(mimeType, startBitrate, resolution, fps, profile, level);
    }

    public static /* synthetic */ VideoConfig copy$default(VideoConfig videoConfig, String string, int n, Size size, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            string = videoConfig.mimeType;
        }
        if ((n5 & 2) != 0) {
            n = videoConfig.startBitrate;
        }
        if ((n5 & 4) != 0) {
            size = videoConfig.resolution;
        }
        if ((n5 & 8) != 0) {
            n2 = videoConfig.fps;
        }
        if ((n5 & 0x10) != 0) {
            n3 = videoConfig.profile;
        }
        if ((n5 & 0x20) != 0) {
            n4 = videoConfig.level;
        }
        return videoConfig.copy(string, n, size, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "VideoConfig(mimeType=" + this.mimeType + ", startBitrate=" + this.startBitrate + ", resolution=" + this.resolution + ", fps=" + this.fps + ", profile=" + this.profile + ", level=" + this.level + ')';
    }

    public int hashCode() {
        int result = this.mimeType.hashCode();
        result = result * 31 + Integer.hashCode(this.startBitrate);
        result = result * 31 + this.resolution.hashCode();
        result = result * 31 + Integer.hashCode(this.fps);
        result = result * 31 + Integer.hashCode(this.profile);
        result = result * 31 + Integer.hashCode(this.level);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VideoConfig)) {
            return false;
        }
        VideoConfig videoConfig = (VideoConfig)other;
        if (!Intrinsics.areEqual((Object)this.mimeType, (Object)videoConfig.mimeType)) {
            return false;
        }
        if (this.startBitrate != videoConfig.startBitrate) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resolution, (Object)videoConfig.resolution)) {
            return false;
        }
        if (this.fps != videoConfig.fps) {
            return false;
        }
        if (this.profile != videoConfig.profile) {
            return false;
        }
        return this.level == videoConfig.level;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c2\u0003JE\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/thibaultbee/streampack/data/VideoConfig$Builder;", "", "mimeType", "", "startBitrate", "", "resolution", "Landroid/util/Size;", "fps", "profile", "level", "(Ljava/lang/String;ILandroid/util/Size;III)V", "build", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "setEncoderLevel", "setEncoderProfile", "setFps", "setMimeType", "setResolution", "setStartBitrate", "toString", "Companion", "sdk_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private String mimeType;
        private int startBitrate;
        @NotNull
        private Size resolution;
        private int fps;
        private int profile;
        private int level;

        public Builder(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, int profile, int level) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
            this.mimeType = mimeType;
            this.startBitrate = startBitrate;
            this.resolution = resolution;
            this.fps = fps;
            this.profile = profile;
            this.level = level;
        }

        public /* synthetic */ Builder(String string, int n, Size size, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                string = "video/avc";
            }
            if ((n5 & 2) != 0) {
                n = 2000000;
            }
            if ((n5 & 4) != 0) {
                size = new Size(1280, 720);
            }
            if ((n5 & 8) != 0) {
                n2 = 30;
            }
            if ((n5 & 0x10) != 0) {
                n3 = Builder.Companion.getDefaultProfile(string);
            }
            if ((n5 & 0x20) != 0) {
                n4 = Builder.Companion.getDefaultLevel(string);
            }
            this(string, n, size, n2, n3, n4);
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMimeType_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$setMimeType_u24lambda_u2d0.mimeType = mimeType;
            $this$setMimeType_u24lambda_u2d0.profile = Builder.Companion.getDefaultProfile(mimeType);
            $this$setMimeType_u24lambda_u2d0.level = Builder.Companion.getDefaultLevel(mimeType);
            return builder;
        }

        @NotNull
        public final Builder setStartBitrate(int startBitrate) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setStartBitrate_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$setStartBitrate_u24lambda_u2d1.startBitrate = startBitrate;
            return builder;
        }

        @NotNull
        public final Builder setResolution(@NotNull Size resolution) {
            Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setResolution_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$setResolution_u24lambda_u2d2.resolution = resolution;
            return builder;
        }

        @NotNull
        public final Builder setFps(int fps) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setFps_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$setFps_u24lambda_u2d3.fps = fps;
            return builder;
        }

        @NotNull
        public final Builder setEncoderProfile(int profile) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setEncoderProfile_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            $this$setEncoderProfile_u24lambda_u2d4.profile = profile;
            return builder;
        }

        @NotNull
        public final Builder setEncoderLevel(int level) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setEncoderLevel_u24lambda_u2d5 = builder;
            boolean bl3 = false;
            $this$setEncoderLevel_u24lambda_u2d5.level = level;
            return builder;
        }

        @NotNull
        public final VideoConfig build() {
            return new VideoConfig(this.mimeType, this.startBitrate, this.resolution, this.fps, this.profile, this.level);
        }

        private final String component1() {
            return this.mimeType;
        }

        private final int component2() {
            return this.startBitrate;
        }

        private final Size component3() {
            return this.resolution;
        }

        private final int component4() {
            return this.fps;
        }

        private final int component5() {
            return this.profile;
        }

        private final int component6() {
            return this.level;
        }

        @NotNull
        public final Builder copy(@NotNull String mimeType, int startBitrate, @NotNull Size resolution, int fps, int profile, int level) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
            return new Builder(mimeType, startBitrate, resolution, fps, profile, level);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, String string, int n, Size size, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = builder.mimeType;
            }
            if ((n5 & 2) != 0) {
                n = builder.startBitrate;
            }
            if ((n5 & 4) != 0) {
                size = builder.resolution;
            }
            if ((n5 & 8) != 0) {
                n2 = builder.fps;
            }
            if ((n5 & 0x10) != 0) {
                n3 = builder.profile;
            }
            if ((n5 & 0x20) != 0) {
                n4 = builder.level;
            }
            return builder.copy(string, n, size, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Builder(mimeType=" + this.mimeType + ", startBitrate=" + this.startBitrate + ", resolution=" + this.resolution + ", fps=" + this.fps + ", profile=" + this.profile + ", level=" + this.level + ')';
        }

        public int hashCode() {
            int result = this.mimeType.hashCode();
            result = result * 31 + Integer.hashCode(this.startBitrate);
            result = result * 31 + this.resolution.hashCode();
            result = result * 31 + Integer.hashCode(this.fps);
            result = result * 31 + Integer.hashCode(this.profile);
            result = result * 31 + Integer.hashCode(this.level);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.mimeType, (Object)builder.mimeType)) {
                return false;
            }
            if (this.startBitrate != builder.startBitrate) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.resolution, (Object)builder.resolution)) {
                return false;
            }
            if (this.fps != builder.fps) {
                return false;
            }
            if (this.profile != builder.profile) {
                return false;
            }
            return this.level == builder.level;
        }

        public Builder() {
            this(null, 0, null, 0, 0, 0, 63, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/github/thibaultbee/streampack/data/VideoConfig$Builder$Companion;", "", "()V", "getDefaultLevel", "", "mimeType", "", "getDefaultProfile", "sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            private final int getDefaultProfile(String mimeType) {
                int n;
                String string = mimeType;
                if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
                    n = 8;
                } else if (Intrinsics.areEqual((Object)string, (Object)"video/hevc")) {
                    n = 1;
                } else {
                    throw new IOException(Intrinsics.stringPlus((String)"Not supported mime type: ", (Object)mimeType));
                }
                return n;
            }

            private final int getDefaultLevel(String mimeType) {
                int n;
                String string = mimeType;
                if (Intrinsics.areEqual((Object)string, (Object)"video/avc")) {
                    n = Build.VERSION.SDK_INT >= 29 ? 524288 : 65536;
                } else if (Intrinsics.areEqual((Object)string, (Object)"video/hevc")) {
                    n = 0x1000000;
                } else {
                    throw new IOException(Intrinsics.stringPlus((String)"Not supported mime type: ", (Object)mimeType));
                }
                return n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

