/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.ext.rtmp.internal.endpoints;

import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.endpoints.ILiveEndpoint;
import io.github.thibaultbee.streampack.listeners.OnConnectionListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.rtmpdroid.Rtmp;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0019\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lio/github/thibaultbee/streampack/ext/rtmp/internal/endpoints/RtmpProducer;", "Lio/github/thibaultbee/streampack/internal/endpoints/ILiveEndpoint;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "logger", "Lio/github/thibaultbee/streampack/logger/ILogger;", "(Lkotlinx/coroutines/CoroutineDispatcher;Lio/github/thibaultbee/streampack/logger/ILogger;)V", "isOnError", "", "getLogger", "()Lio/github/thibaultbee/streampack/logger/ILogger;", "onConnectionListener", "Lio/github/thibaultbee/streampack/listeners/OnConnectionListener;", "getOnConnectionListener", "()Lio/github/thibaultbee/streampack/listeners/OnConnectionListener;", "setOnConnectionListener", "(Lio/github/thibaultbee/streampack/listeners/OnConnectionListener;)V", "socket", "Lvideo/api/rtmpdroid/Rtmp;", "configure", "", "config", "", "connect", "url", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "release", "startStream", "stopStream", "write", "packet", "Lio/github/thibaultbee/streampack/internal/data/Packet;", "extension-rtmp_release"})
public final class RtmpProducer
implements ILiveEndpoint {
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final ILogger logger;
    @Nullable
    private OnConnectionListener onConnectionListener;
    @NotNull
    private Rtmp socket;
    private boolean isOnError;

    public RtmpProducer(@NotNull CoroutineDispatcher coroutineDispatcher, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.coroutineDispatcher = coroutineDispatcher;
        this.logger = logger;
        this.socket = new Rtmp(false, 1, null);
    }

    public /* synthetic */ RtmpProducer(CoroutineDispatcher coroutineDispatcher, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(coroutineDispatcher, iLogger);
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @Nullable
    public OnConnectionListener getOnConnectionListener() {
        return this.onConnectionListener;
    }

    public void setOnConnectionListener(@Nullable OnConnectionListener onConnectionListener) {
        this.onConnectionListener = onConnectionListener;
    }

    public void configure(int config) {
    }

    @Nullable
    public Object connect(@NotNull String url, @NotNull Continuation<? super Unit> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, url, null){
            int label;
            final /* synthetic */ RtmpProducer this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Unit unit2;
                            RtmpProducer.access$setOnError$p(this.this$0, false);
                            RtmpProducer.access$getSocket$p(this.this$0).connect(Intrinsics.stringPlus((String)this.$url, (Object)" live=1"));
                            OnConnectionListener onConnectionListener = this.this$0.getOnConnectionListener();
                            if (onConnectionListener == null) {
                                unit2 = null;
                            } else {
                                onConnectionListener.onSuccess();
                                unit2 = Unit.INSTANCE;
                            }
                            unit = unit2;
                        }
                        catch (Exception e) {
                            RtmpProducer.access$setSocket$p(this.this$0, new Rtmp(false, 1, null));
                            OnConnectionListener onConnectionListener = this.this$0.getOnConnectionListener();
                            if (onConnectionListener != null) {
                                String string = e.getMessage();
                                if (string == null) {
                                    string = "Unknown error";
                                }
                                onConnectionListener.onFailed(string);
                            }
                            throw e;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public void disconnect() {
        this.socket.close();
        this.socket = new Rtmp(false, 1, null);
    }

    public void write(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (this.isOnError) {
            return;
        }
        try {
            this.socket.write(packet.getBuffer());
        }
        catch (SocketException e) {
            this.disconnect();
            this.isOnError = true;
            OnConnectionListener onConnectionListener = this.getOnConnectionListener();
            if (onConnectionListener != null) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Socket error";
                }
                onConnectionListener.onLost(string);
            }
            this.logger.e((Object)this, "Error while writing packet to socket", (Throwable)e);
            throw e;
        }
    }

    public void startStream() {
        this.socket.connectStream();
    }

    public void stopStream() {
        this.socket.deleteStream();
    }

    public void release() {
    }

    public static final /* synthetic */ void access$setOnError$p(RtmpProducer $this, boolean bl) {
        $this.isOnError = bl;
    }

    public static final /* synthetic */ Rtmp access$getSocket$p(RtmpProducer $this) {
        return $this.socket;
    }

    public static final /* synthetic */ void access$setSocket$p(RtmpProducer $this, Rtmp rtmp) {
        $this.socket = rtmp;
    }
}

