/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.lnurl.auth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tbk.lnurl.auth.K1;
import org.tbk.lnurl.auth.K1Cache;

public final class InMemoryK1Cache
implements K1Cache {
    private static final Logger log = LoggerFactory.getLogger(InMemoryK1Cache.class);
    private static final RemovalListener<K1, K1> LOG_REMOVAL_LISTENER = new RemovalListener<K1, K1>(){

        public void onRemoval(RemovalNotification<K1, K1> notification) {
            log.debug("Remove k1 '{}' from in-memory k1 cache: {}", notification.getKey(), (Object)notification.getCause());
        }
    };
    public final Cache<K1, K1> cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).maximumSize(100000L).removalListener(LOG_REMOVAL_LISTENER).build();

    public void put(K1 k1) {
        this.cache.put((Object)k1, (Object)k1);
    }

    public boolean isPresent(K1 k1) {
        return this.cache.getIfPresent((Object)k1) != null;
    }

    public void remove(K1 k1) {
        this.cache.invalidate((Object)k1);
    }
}

