/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.earndotcom.config;

import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.earndotcom.client.CachingEarndotcomApiClient;
import org.tbk.bitcoin.tool.fee.earndotcom.client.EarndotcomApiClient;
import org.tbk.bitcoin.tool.fee.earndotcom.client.EarndotcomApiClientImpl;
import org.tbk.bitcoin.tool.fee.earndotcom.config.EarndotcomFeeClientAutoConfigProperties;
import org.tbk.bitcoin.tool.fee.earndotcom.provider.EarndotcomFeeProvider;
import org.tbk.bitcoin.tool.fee.earndotcom.provider.FeeSelectionStrategy;
import org.tbk.bitcoin.tool.fee.earndotcom.provider.SimpleFeeSelectionStrategy;
import org.tbk.bitcoin.tool.fee.util.MoreCacheBuilder;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EarndotcomFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={EarndotcomApiClient.class, EarndotcomFeeProvider.class, FeeSelectionStrategy.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.earndotcom.enabled"}, havingValue="true", matchIfMissing=true)
public class EarndotcomFeeClientAutoConfiguration {
    private final EarndotcomFeeClientAutoConfigProperties properties;

    public EarndotcomFeeClientAutoConfiguration(EarndotcomFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={EarndotcomApiClient.class})
    public EarndotcomApiClient earndotcomApiClient() {
        EarndotcomApiClientImpl client = new EarndotcomApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
        return CachingEarndotcomApiClient.builder().delegate((EarndotcomApiClient)client).feesListCacheBuilderSpec(this.defaultFeesListCacheBuilderSpec()).feesRecommendedCacheBuilderSpec(this.defaultFeesRecommendedCacheBuilderSpec()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={FeeSelectionStrategy.class})
    public FeeSelectionStrategy earndotcomFeeSelectionStrategy() {
        return new SimpleFeeSelectionStrategy();
    }

    @Bean
    @ConditionalOnMissingBean(value={EarndotcomFeeProvider.class})
    public EarndotcomFeeProvider earndotcomFeeProvider(EarndotcomApiClient earndotcomApiClient, FeeSelectionStrategy earndotcomFeeSelectionStrategy) {
        return new EarndotcomFeeProvider(earndotcomApiClient, earndotcomFeeSelectionStrategy);
    }

    private CacheBuilderSpec defaultFeesListCacheBuilderSpec() {
        return MoreCacheBuilder.toCacheBuilderSpec((Map)ImmutableMap.builder().put((Object)"initialCapacity", (Object)Long.toString(1L)).put((Object)"maximumSize", (Object)Long.toString(1L)).put((Object)"expireAfterWrite", (Object)"30s").build());
    }

    private CacheBuilderSpec defaultFeesRecommendedCacheBuilderSpec() {
        return MoreCacheBuilder.toCacheBuilderSpec((Map)ImmutableMap.builder().put((Object)"initialCapacity", (Object)Long.toString(1L)).put((Object)"maximumSize", (Object)Long.toString(1L)).put((Object)"expireAfterWrite", (Object)"30s").build());
    }
}

