/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.bitgo.config;

import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.bitgo.BitgoFeeApiClient;
import org.tbk.bitcoin.tool.fee.bitgo.BitgoFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.bitgo.BitgoFeeProvider;
import org.tbk.bitcoin.tool.fee.bitgo.CachingBitgoFeeApiClient;
import org.tbk.bitcoin.tool.fee.bitgo.config.BitgoFeeClientAutoConfigProperties;
import org.tbk.bitcoin.tool.fee.util.MoreCacheBuilder;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BitgoFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={BitgoFeeApiClient.class, BitgoFeeProvider.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.bitgo.enabled"}, havingValue="true", matchIfMissing=true)
public class BitgoFeeClientAutoConfiguration {
    private final BitgoFeeClientAutoConfigProperties properties;

    public BitgoFeeClientAutoConfiguration(BitgoFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BitgoFeeApiClient.class})
    public BitgoFeeApiClient bitgoFeeApiClient() {
        BitgoFeeApiClientImpl bitgoFeeApiClient = new BitgoFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
        return CachingBitgoFeeApiClient.builder().delegate((BitgoFeeApiClient)bitgoFeeApiClient).responseCacheBuilderSpec(this.defaultResponseCacheBuilderSpec()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={BitgoFeeProvider.class})
    public BitgoFeeProvider bitgoFeeProvider(BitgoFeeApiClient bitgoFeeApiClient) {
        return new BitgoFeeProvider(bitgoFeeApiClient);
    }

    private CacheBuilderSpec defaultResponseCacheBuilderSpec() {
        return MoreCacheBuilder.toCacheBuilderSpec((Map)ImmutableMap.builder().put((Object)"initialCapacity", (Object)Long.toString(1L)).put((Object)"maximumSize", (Object)Long.toString(1L)).put((Object)"expireAfterWrite", (Object)"30s").build());
    }
}

