/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.bitcoinerlive.config;

import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.bitcoinerlive.BitcoinerliveFeeApiClient;
import org.tbk.bitcoin.tool.fee.bitcoinerlive.BitcoinerliveFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.bitcoinerlive.BitcoinerliveFeeProvider;
import org.tbk.bitcoin.tool.fee.bitcoinerlive.config.BitcoinerliveFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BitcoinerliveFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={BitcoinerliveFeeApiClient.class, BitcoinerliveFeeProvider.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.bitcoinerlive.enabled"}, havingValue="true", matchIfMissing=true)
public class BitcoinerliveFeeClientAutoConfiguration {
    private final BitcoinerliveFeeClientAutoConfigProperties properties;

    public BitcoinerliveFeeClientAutoConfiguration(BitcoinerliveFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BitcoinerliveFeeApiClient.class})
    public BitcoinerliveFeeApiClient bitcoinerliveFeeApiClient() {
        return new BitcoinerliveFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean(value={BitcoinerliveFeeProvider.class})
    public BitcoinerliveFeeProvider bitcoinerliveFeeProvider(BitcoinerliveFeeApiClient bitcoinerliveFeeApiClient) {
        return new BitcoinerliveFeeProvider(bitcoinerliveFeeApiClient);
    }
}

