/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.mempoolspace.config;

import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.mempoolspace.MempoolspaceFeeApiClient;
import org.tbk.bitcoin.tool.fee.mempoolspace.MempoolspaceFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.mempoolspace.ProjectedBlocksMempoolspaceFeeProvider;
import org.tbk.bitcoin.tool.fee.mempoolspace.SimpleMempoolspaceFeeProvider;
import org.tbk.bitcoin.tool.fee.mempoolspace.config.MempoolspaceFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MempoolspaceFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={MempoolspaceFeeApiClient.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.mempoolspace.enabled"}, havingValue="true", matchIfMissing=true)
public class MempoolspaceFeeClientAutoConfiguration {
    private final MempoolspaceFeeClientAutoConfigProperties properties;

    public MempoolspaceFeeClientAutoConfiguration(MempoolspaceFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={MempoolspaceFeeApiClient.class})
    public MempoolspaceFeeApiClient mempoolspaceFeeApiClient() {
        return new MempoolspaceFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean(value={SimpleMempoolspaceFeeProvider.class})
    public SimpleMempoolspaceFeeProvider simpleMempoolspaceFeeProvider(MempoolspaceFeeApiClient mempoolspaceFeeApiClient) {
        return new SimpleMempoolspaceFeeProvider(mempoolspaceFeeApiClient);
    }

    @Bean(value={"projectedBlocksMempoolspaceFeeProvider"})
    @ConditionalOnBean(value={ProjectedBlocksMempoolspaceFeeProvider.FeesFromProjectedBlockStrategy.class})
    @ConditionalOnMissingBean(value={ProjectedBlocksMempoolspaceFeeProvider.class})
    public ProjectedBlocksMempoolspaceFeeProvider projectedBlocksMempoolspaceFeeProviderWithCustomStrategy(MempoolspaceFeeApiClient mempoolspaceFeeApiClient, ProjectedBlocksMempoolspaceFeeProvider.FeesFromProjectedBlockStrategy strategy) {
        return new ProjectedBlocksMempoolspaceFeeProvider(mempoolspaceFeeApiClient, strategy);
    }

    @Bean(value={"projectedBlocksMempoolspaceFeeProvider"})
    @ConditionalOnMissingBean(value={ProjectedBlocksMempoolspaceFeeProvider.class, ProjectedBlocksMempoolspaceFeeProvider.FeesFromProjectedBlockStrategy.class})
    public ProjectedBlocksMempoolspaceFeeProvider projectedBlocksMempoolspaceFeeProvider(MempoolspaceFeeApiClient mempoolspaceFeeApiClient) {
        return new ProjectedBlocksMempoolspaceFeeProvider(mempoolspaceFeeApiClient);
    }
}

